/*
 * Decompiled with CFR 0.152.
 */
package com.arasthel.spannedgridlayoutmanager;

import android.graphics.Rect;
import com.arasthel.spannedgridlayoutmanager.RectExtensionsKt;
import com.arasthel.spannedgridlayoutmanager.RectsHelper$WhenMappings;
import com.arasthel.spannedgridlayoutmanager.SpanSize;
import com.arasthel.spannedgridlayoutmanager.SpannedGridLayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010!\u001a\u00020\bJ\u0016\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0014J\u0016\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\b2\u0006\u0010)\u001a\u00020\rJ\u0010\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\rH\u0014R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00190\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\nR\u0011\u0010\u001e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\n\u00a8\u0006,"}, d2={"Lcom/arasthel/spannedgridlayoutmanager/RectsHelper;", "", "layoutManager", "Lcom/arasthel/spannedgridlayoutmanager/SpannedGridLayoutManager;", "orientation", "Lcom/arasthel/spannedgridlayoutmanager/SpannedGridLayoutManager$Orientation;", "(Lcom/arasthel/spannedgridlayoutmanager/SpannedGridLayoutManager;Lcom/arasthel/spannedgridlayoutmanager/SpannedGridLayoutManager$Orientation;)V", "end", "", "getEnd", "()I", "freeRects", "", "Landroid/graphics/Rect;", "itemSize", "getItemSize", "getLayoutManager", "()Lcom/arasthel/spannedgridlayoutmanager/SpannedGridLayoutManager;", "getOrientation", "()Lcom/arasthel/spannedgridlayoutmanager/SpannedGridLayoutManager$Orientation;", "rectComparator", "Ljava/util/Comparator;", "rectsCache", "", "rows", "", "getRows", "()Ljava/util/Map;", "size", "getSize", "start", "getStart", "findPositionsForRow", "rowPosition", "findRect", "position", "spanSize", "Lcom/arasthel/spannedgridlayoutmanager/SpanSize;", "findRectForSpanSize", "pushRect", "", "rect", "subtract", "subtractedRect", "spannedgridlayoutmanager_release"})
public class RectsHelper {
    private final Comparator<Rect> rectComparator;
    @NotNull
    private final Map<Integer, Set<Integer>> rows;
    private final Map<Integer, Rect> rectsCache;
    private final List<Rect> freeRects;
    @NotNull
    private final SpannedGridLayoutManager layoutManager;
    @NotNull
    private final SpannedGridLayoutManager.Orientation orientation;

    @NotNull
    public final Map<Integer, Set<Integer>> getRows() {
        return this.rows;
    }

    public final int getSize() {
        return this.orientation == SpannedGridLayoutManager.Orientation.VERTICAL ? this.layoutManager.getWidth() - this.layoutManager.getPaddingLeft() - this.layoutManager.getPaddingRight() : this.layoutManager.getHeight() - this.layoutManager.getPaddingTop() - this.layoutManager.getPaddingBottom();
    }

    public final int getItemSize() {
        return this.getSize() / this.layoutManager.getSpans();
    }

    public final int getStart() {
        return this.orientation == SpannedGridLayoutManager.Orientation.VERTICAL ? this.freeRects.get((int)0).top * this.getItemSize() : this.freeRects.get((int)0).left * this.getItemSize();
    }

    public final int getEnd() {
        return this.orientation == SpannedGridLayoutManager.Orientation.VERTICAL ? (((Rect)CollectionsKt.last(this.freeRects)).top + 1) * this.getItemSize() : (((Rect)CollectionsKt.last(this.freeRects)).left + 1) * this.getItemSize();
    }

    @NotNull
    public final Rect findRect(int position, @NotNull SpanSize spanSize) {
        Intrinsics.checkParameterIsNotNull((Object)spanSize, (String)"spanSize");
        Rect rect = this.rectsCache.get(position);
        if (rect == null) {
            rect = this.findRectForSpanSize(spanSize);
        }
        return rect;
    }

    @NotNull
    protected Rect findRectForSpanSize(@NotNull SpanSize spanSize) {
        Object element$iv2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)spanSize, (String)"spanSize");
            Iterable $receiver$iv = this.freeRects;
            for (Object element$iv2 : $receiver$iv) {
                Rect it = (Rect)element$iv2;
                Rect itemRect = new Rect(it.left, it.top, it.left + spanSize.getWidth(), it.top + spanSize.getHeight());
                if (!it.contains(itemRect)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Rect lane = (Rect)element$iv2;
        return new Rect(lane.left, lane.top, lane.left + spanSize.getWidth(), lane.top + spanSize.getHeight());
    }

    public final void pushRect(int position, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        int start = this.orientation == SpannedGridLayoutManager.Orientation.VERTICAL ? rect.top : rect.left;
        Set set = this.rows.get(start);
        if (set == null || (set = CollectionsKt.toMutableSet((Iterable)set)) == null) {
            set = new LinkedHashSet();
        }
        Set startRow = set;
        startRow.add(position);
        Map<Integer, Set<Integer>> map = this.rows;
        Integer n = start;
        Map<Integer, Rect> map2 = startRow;
        map.put(n, (Set<Integer>)((Object)map2));
        int end = this.orientation == SpannedGridLayoutManager.Orientation.VERTICAL ? rect.bottom : rect.right;
        Set set2 = this.rows.get(end - 1);
        if (set2 == null || (set2 = CollectionsKt.toMutableSet((Iterable)set2)) == null) {
            set2 = new LinkedHashSet();
        }
        Set endRow = set2;
        endRow.add(position);
        map2 = this.rows;
        Integer n2 = end - 1;
        Set set3 = endRow;
        map2.put(n2, (Rect)set3);
        map2 = this.rectsCache;
        n2 = position;
        set3 = rect;
        map2.put(n2, (Rect)set3);
        this.subtract(rect);
    }

    @NotNull
    public final Set<Integer> findPositionsForRow(int rowPosition) {
        Set set = this.rows.get(rowPosition);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    protected void subtract(@NotNull Rect subtractedRect) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)subtractedRect, (String)"subtractedRect");
        Iterable iterable = $receiver$iv = (Iterable)this.freeRects;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Rect it = (Rect)element$iv$iv;
            if (!(RectExtensionsKt.isAdjacentTo(it, subtractedRect) || RectExtensionsKt.intersects(it, subtractedRect))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List interestingRects = (List)destination$iv$iv;
        List possibleNewRects = new ArrayList();
        List adjacentRects = new ArrayList();
        for (Rect free : interestingRects) {
            if (RectExtensionsKt.isAdjacentTo(free, subtractedRect) && !subtractedRect.contains(free)) {
                adjacentRects.add(free);
                continue;
            }
            this.freeRects.remove(free);
            if (free.left < subtractedRect.left) {
                possibleNewRects.add(new Rect(free.left, free.top, subtractedRect.left, free.bottom));
            }
            if (free.right > subtractedRect.right) {
                possibleNewRects.add(new Rect(subtractedRect.right, free.top, free.right, free.bottom));
            }
            if (free.top < subtractedRect.top) {
                possibleNewRects.add(new Rect(free.left, free.top, free.right, subtractedRect.top));
            }
            if (free.bottom <= subtractedRect.bottom) continue;
            possibleNewRects.add(new Rect(free.left, subtractedRect.bottom, free.right, free.bottom));
        }
        for (Rect rect : possibleNewRects) {
            boolean isContained;
            Object v2;
            block10: {
                boolean isAdjacent;
                Object v0;
                block9: {
                    Iterable $receiver$iv2 = adjacentRects;
                    for (Object element$iv : $receiver$iv2) {
                        Rect it = (Rect)element$iv;
                        if (!(Intrinsics.areEqual((Object)it, (Object)rect) ^ true && it.contains(rect))) continue;
                        v0 = element$iv;
                        break block9;
                    }
                    v0 = null;
                }
                boolean bl = isAdjacent = v0 != null;
                if (isAdjacent) continue;
                Iterable $receiver$iv3 = possibleNewRects;
                for (Object element$iv : $receiver$iv3) {
                    Rect it = (Rect)element$iv;
                    if (!(Intrinsics.areEqual((Object)it, (Object)rect) ^ true && it.contains(rect))) continue;
                    v2 = element$iv;
                    break block10;
                }
                v2 = null;
            }
            boolean bl = isContained = v2 != null;
            if (isContained) continue;
            this.freeRects.add(rect);
        }
        CollectionsKt.sortWith(this.freeRects, this.rectComparator);
    }

    @NotNull
    public final SpannedGridLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    @NotNull
    public final SpannedGridLayoutManager.Orientation getOrientation() {
        return this.orientation;
    }

    public RectsHelper(@NotNull SpannedGridLayoutManager layoutManager, @NotNull SpannedGridLayoutManager.Orientation orientation) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)layoutManager), (String)"layoutManager");
        Intrinsics.checkParameterIsNotNull((Object)((Object)orientation), (String)"orientation");
        this.layoutManager = layoutManager;
        this.orientation = orientation;
        this.rectComparator = new Comparator<Rect>(this){
            final /* synthetic */ RectsHelper this$0;

            public final int compare(Rect rect1, Rect rect2) {
                int n;
                switch (RectsHelper$WhenMappings.$EnumSwitchMapping$0[this.this$0.getOrientation().ordinal()]) {
                    case 1: {
                        if (rect1.top == rect2.top) {
                            if (rect1.left < rect2.left) {
                                n = -1;
                                break;
                            }
                            n = 1;
                            break;
                        }
                        if (rect1.top < rect2.top) {
                            n = -1;
                            break;
                        }
                        n = 1;
                        break;
                    }
                    case 2: {
                        if (rect1.left == rect2.left) {
                            if (rect1.top < rect2.top) {
                                n = -1;
                                break;
                            }
                            n = 1;
                            break;
                        }
                        if (rect1.left < rect2.left) {
                            n = -1;
                            break;
                        }
                        n = 1;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return n;
            }
            {
                this.this$0 = rectsHelper;
            }
        };
        RectsHelper rectsHelper = this;
        Object object = new LinkedHashMap();
        rectsHelper.rows = object;
        rectsHelper = this;
        object = new LinkedHashMap();
        rectsHelper.rectsCache = object;
        rectsHelper = this;
        rectsHelper.freeRects = object = (List)new ArrayList();
        Rect initialFreeRect = this.orientation == SpannedGridLayoutManager.Orientation.VERTICAL ? new Rect(0, 0, this.layoutManager.getSpans(), Integer.MAX_VALUE) : new Rect(0, 0, Integer.MAX_VALUE, this.layoutManager.getSpans());
        this.freeRects.add(initialFreeRect);
    }
}

