/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.ffmpegkit;

import com.arthenica.ffmpegkit.AbiDetect;
import com.arthenica.ffmpegkit.ExecuteCallback;
import com.arthenica.ffmpegkit.FFmpegKitConfig;
import com.arthenica.ffmpegkit.FFmpegSession;
import com.arthenica.ffmpegkit.LogCallback;
import com.arthenica.ffmpegkit.StatisticsCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class FFmpegKit {
    private FFmpegKit() {
    }

    public static FFmpegSession execute(String[] arguments) {
        FFmpegSession session = new FFmpegSession(arguments);
        FFmpegKitConfig.ffmpegExecute(session);
        return session;
    }

    public static FFmpegSession executeAsync(String[] arguments, ExecuteCallback executeCallback) {
        FFmpegSession session = new FFmpegSession(arguments, executeCallback);
        FFmpegKitConfig.asyncFFmpegExecute(session);
        return session;
    }

    public static FFmpegSession executeAsync(String[] arguments, ExecuteCallback executeCallback, LogCallback logCallback, StatisticsCallback statisticsCallback) {
        FFmpegSession session = new FFmpegSession(arguments, executeCallback, logCallback, statisticsCallback);
        FFmpegKitConfig.asyncFFmpegExecute(session);
        return session;
    }

    public static FFmpegSession executeAsync(String[] arguments, ExecuteCallback executeCallback, ExecutorService executorService) {
        FFmpegSession session = new FFmpegSession(arguments, executeCallback);
        FFmpegKitConfig.asyncFFmpegExecute(session, executorService);
        return session;
    }

    public static FFmpegSession executeAsync(String[] arguments, ExecuteCallback executeCallback, LogCallback logCallback, StatisticsCallback statisticsCallback, ExecutorService executorService) {
        FFmpegSession session = new FFmpegSession(arguments, executeCallback, logCallback, statisticsCallback);
        FFmpegKitConfig.asyncFFmpegExecute(session, executorService);
        return session;
    }

    public static FFmpegSession execute(String command) {
        return FFmpegKit.execute(FFmpegKit.parseArguments(command));
    }

    public static FFmpegSession executeAsync(String command, ExecuteCallback executeCallback) {
        return FFmpegKit.executeAsync(FFmpegKit.parseArguments(command), executeCallback);
    }

    public static FFmpegSession executeAsync(String command, ExecuteCallback executeCallback, LogCallback logCallback, StatisticsCallback statisticsCallback) {
        return FFmpegKit.executeAsync(FFmpegKit.parseArguments(command), executeCallback, logCallback, statisticsCallback);
    }

    public static FFmpegSession executeAsync(String command, ExecuteCallback executeCallback, ExecutorService executorService) {
        FFmpegSession session = new FFmpegSession(FFmpegKit.parseArguments(command), executeCallback);
        FFmpegKitConfig.asyncFFmpegExecute(session, executorService);
        return session;
    }

    public static FFmpegSession executeAsync(String command, ExecuteCallback executeCallback, LogCallback logCallback, StatisticsCallback statisticsCallback, ExecutorService executorService) {
        FFmpegSession session = new FFmpegSession(FFmpegKit.parseArguments(command), executeCallback, logCallback, statisticsCallback);
        FFmpegKitConfig.asyncFFmpegExecute(session, executorService);
        return session;
    }

    public static void cancel() {
        FFmpegKitConfig.nativeFFmpegCancel(0L);
    }

    public static void cancel(long sessionId) {
        FFmpegKitConfig.nativeFFmpegCancel(sessionId);
    }

    public static List<FFmpegSession> listSessions() {
        return FFmpegKitConfig.getFFmpegSessions();
    }

    public static String[] parseArguments(String command) {
        ArrayList<String> argumentList = new ArrayList<String>();
        StringBuilder currentArgument = new StringBuilder();
        boolean singleQuoteStarted = false;
        boolean doubleQuoteStarted = false;
        for (int i = 0; i < command.length(); ++i) {
            Character previousChar = i > 0 ? Character.valueOf(command.charAt(i - 1)) : null;
            char currentChar = command.charAt(i);
            if (currentChar == ' ') {
                if (singleQuoteStarted || doubleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                if (currentArgument.length() <= 0) continue;
                argumentList.add(currentArgument.toString());
                currentArgument = new StringBuilder();
                continue;
            }
            if (currentChar == '\'' && (previousChar == null || previousChar.charValue() != '\\')) {
                if (singleQuoteStarted) {
                    singleQuoteStarted = false;
                    continue;
                }
                if (doubleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                singleQuoteStarted = true;
                continue;
            }
            if (currentChar == '\"' && (previousChar == null || previousChar.charValue() != '\\')) {
                if (doubleQuoteStarted) {
                    doubleQuoteStarted = false;
                    continue;
                }
                if (singleQuoteStarted) {
                    currentArgument.append(currentChar);
                    continue;
                }
                doubleQuoteStarted = true;
                continue;
            }
            currentArgument.append(currentChar);
        }
        if (currentArgument.length() > 0) {
            argumentList.add(currentArgument.toString());
        }
        return argumentList.toArray(new String[0]);
    }

    public static String argumentsToString(String[] arguments) {
        if (arguments == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(arguments[i]);
        }
        return stringBuilder.toString();
    }

    static {
        AbiDetect.class.getName();
        FFmpegKitConfig.class.getName();
    }
}

