/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.ffmpegkit;

import com.arthenica.ffmpegkit.AbiDetect;
import com.arthenica.ffmpegkit.ExecuteCallback;
import com.arthenica.ffmpegkit.FFmpegKit;
import com.arthenica.ffmpegkit.FFmpegKitConfig;
import com.arthenica.ffmpegkit.FFprobeSession;
import com.arthenica.ffmpegkit.LogCallback;
import com.arthenica.ffmpegkit.MediaInformationSession;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class FFprobeKit {
    private FFprobeKit() {
    }

    public static FFprobeSession execute(String[] arguments) {
        FFprobeSession session = new FFprobeSession(arguments);
        FFmpegKitConfig.ffprobeExecute(session);
        return session;
    }

    public static FFprobeSession executeAsync(String[] arguments, ExecuteCallback executeCallback) {
        FFprobeSession session = new FFprobeSession(arguments, executeCallback);
        FFmpegKitConfig.asyncFFprobeExecute(session);
        return session;
    }

    public static FFprobeSession executeAsync(String[] arguments, ExecuteCallback executeCallback, LogCallback logCallback) {
        FFprobeSession session = new FFprobeSession(arguments, executeCallback, logCallback);
        FFmpegKitConfig.asyncFFprobeExecute(session);
        return session;
    }

    public static FFprobeSession executeAsync(String[] arguments, ExecuteCallback executeCallback, ExecutorService executorService) {
        FFprobeSession session = new FFprobeSession(arguments, executeCallback);
        FFmpegKitConfig.asyncFFprobeExecute(session, executorService);
        return session;
    }

    public static FFprobeSession executeAsync(String[] arguments, ExecuteCallback executeCallback, LogCallback logCallback, ExecutorService executorService) {
        FFprobeSession session = new FFprobeSession(arguments, executeCallback, logCallback);
        FFmpegKitConfig.asyncFFprobeExecute(session, executorService);
        return session;
    }

    public static FFprobeSession execute(String command) {
        return FFprobeKit.execute(FFmpegKit.parseArguments(command));
    }

    public static FFprobeSession executeAsync(String command, ExecuteCallback executeCallback) {
        return FFprobeKit.executeAsync(FFmpegKit.parseArguments(command), executeCallback);
    }

    public static FFprobeSession executeAsync(String command, ExecuteCallback executeCallback, LogCallback logCallback) {
        return FFprobeKit.executeAsync(FFmpegKit.parseArguments(command), executeCallback, logCallback);
    }

    public static FFprobeSession executeAsync(String command, ExecuteCallback executeCallback, ExecutorService executorService) {
        FFprobeSession session = new FFprobeSession(FFmpegKit.parseArguments(command), executeCallback);
        FFmpegKitConfig.asyncFFprobeExecute(session, executorService);
        return session;
    }

    public static FFprobeSession executeAsync(String command, ExecuteCallback executeCallback, LogCallback logCallback, ExecutorService executorService) {
        FFprobeSession session = new FFprobeSession(FFmpegKit.parseArguments(command), executeCallback, logCallback);
        FFmpegKitConfig.asyncFFprobeExecute(session, executorService);
        return session;
    }

    public static MediaInformationSession getMediaInformation(String path) {
        MediaInformationSession session = new MediaInformationSession(new String[]{"-v", "error", "-hide_banner", "-print_format", "json", "-show_format", "-show_streams", "-i", path});
        FFmpegKitConfig.getMediaInformationExecute(session, 5000);
        return session;
    }

    public static MediaInformationSession getMediaInformation(String path, int waitTimeout) {
        MediaInformationSession session = new MediaInformationSession(new String[]{"-v", "error", "-hide_banner", "-print_format", "json", "-show_format", "-show_streams", "-i", path});
        FFmpegKitConfig.getMediaInformationExecute(session, waitTimeout);
        return session;
    }

    public static MediaInformationSession getMediaInformationAsync(String path, ExecuteCallback executeCallback) {
        MediaInformationSession session = new MediaInformationSession(new String[]{"-v", "error", "-hide_banner", "-print_format", "json", "-show_format", "-show_streams", "-i", path}, executeCallback);
        FFmpegKitConfig.asyncGetMediaInformationExecute(session, 5000);
        return session;
    }

    public static MediaInformationSession getMediaInformationAsync(String path, ExecuteCallback executeCallback, LogCallback logCallback, int waitTimeout) {
        MediaInformationSession session = new MediaInformationSession(new String[]{"-v", "error", "-hide_banner", "-print_format", "json", "-show_format", "-show_streams", "-i", path}, executeCallback, logCallback);
        FFmpegKitConfig.asyncGetMediaInformationExecute(session, waitTimeout);
        return session;
    }

    public static MediaInformationSession getMediaInformationAsync(String path, ExecuteCallback executeCallback, ExecutorService executorService) {
        MediaInformationSession session = new MediaInformationSession(new String[]{"-v", "error", "-hide_banner", "-print_format", "json", "-show_format", "-show_streams", "-i", path}, executeCallback);
        FFmpegKitConfig.asyncGetMediaInformationExecute(session, executorService, 5000);
        return session;
    }

    public static MediaInformationSession getMediaInformationAsync(String path, ExecuteCallback executeCallback, LogCallback logCallback, ExecutorService executorService, int waitTimeout) {
        MediaInformationSession session = new MediaInformationSession(new String[]{"-v", "error", "-hide_banner", "-print_format", "json", "-show_format", "-show_streams", "-i", path}, executeCallback, logCallback);
        FFmpegKitConfig.asyncGetMediaInformationExecute(session, executorService, waitTimeout);
        return session;
    }

    public static MediaInformationSession getMediaInformationFromCommand(String command) {
        MediaInformationSession session = new MediaInformationSession(FFmpegKit.parseArguments(command));
        FFmpegKitConfig.asyncGetMediaInformationExecute(session, 5000);
        return session;
    }

    public static MediaInformationSession getMediaInformationFromCommandAsync(String command, ExecuteCallback executeCallback, LogCallback logCallback, int waitTimeout) {
        return FFprobeKit.getMediaInformationFromCommandArgumentsAsync(FFmpegKit.parseArguments(command), executeCallback, logCallback, waitTimeout);
    }

    private static MediaInformationSession getMediaInformationFromCommandArgumentsAsync(String[] arguments, ExecuteCallback executeCallback, LogCallback logCallback, int waitTimeout) {
        MediaInformationSession session = new MediaInformationSession(arguments, executeCallback, logCallback);
        FFmpegKitConfig.getMediaInformationExecute(session, waitTimeout);
        return session;
    }

    public static List<FFprobeSession> listSessions() {
        return FFmpegKitConfig.getFFprobeSessions();
    }

    static {
        AbiDetect.class.getName();
        FFmpegKitConfig.class.getName();
    }
}

