/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.ffmpegkit;

import com.arthenica.ffmpegkit.StreamInformation;
import java.util.List;
import org.json.JSONObject;

public class MediaInformation {
    public static final String KEY_MEDIA_PROPERTIES = "format";
    public static final String KEY_FILENAME = "filename";
    public static final String KEY_FORMAT = "format_name";
    public static final String KEY_FORMAT_LONG = "format_long_name";
    public static final String KEY_START_TIME = "start_time";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_SIZE = "size";
    public static final String KEY_BIT_RATE = "bit_rate";
    public static final String KEY_TAGS = "tags";
    private final JSONObject jsonObject;
    private final List<StreamInformation> streams;

    public MediaInformation(JSONObject jsonObject, List<StreamInformation> streams) {
        this.jsonObject = jsonObject;
        this.streams = streams;
    }

    public String getFilename() {
        return this.getStringProperty(KEY_FILENAME);
    }

    public String getFormat() {
        return this.getStringProperty(KEY_FORMAT);
    }

    public String getLongFormat() {
        return this.getStringProperty(KEY_FORMAT_LONG);
    }

    public String getDuration() {
        return this.getStringProperty(KEY_DURATION);
    }

    public String getStartTime() {
        return this.getStringProperty(KEY_START_TIME);
    }

    public String getSize() {
        return this.getStringProperty(KEY_SIZE);
    }

    public String getBitrate() {
        return this.getStringProperty(KEY_BIT_RATE);
    }

    public JSONObject getTags() {
        return this.getProperties(KEY_TAGS);
    }

    public List<StreamInformation> getStreams() {
        return this.streams;
    }

    public String getStringProperty(String key) {
        JSONObject mediaProperties = this.getMediaProperties();
        if (mediaProperties == null) {
            return null;
        }
        if (mediaProperties.has(key)) {
            return mediaProperties.optString(key);
        }
        return null;
    }

    public Long getNumberProperty(String key) {
        JSONObject mediaProperties = this.getMediaProperties();
        if (mediaProperties == null) {
            return null;
        }
        if (mediaProperties.has(key)) {
            return mediaProperties.optLong(key);
        }
        return null;
    }

    public JSONObject getProperties(String key) {
        JSONObject mediaProperties = this.getMediaProperties();
        if (mediaProperties == null) {
            return null;
        }
        return mediaProperties.optJSONObject(key);
    }

    public JSONObject getMediaProperties() {
        return this.jsonObject.optJSONObject(KEY_MEDIA_PROPERTIES);
    }

    public JSONObject getAllProperties() {
        return this.jsonObject;
    }
}

