/*
 * Decompiled with CFR 0.152.
 */
package com.arthenica.mobileffmpeg;

public class Statistics {
    private long executionId;
    private int videoFrameNumber;
    private float videoFps;
    private float videoQuality;
    private long size;
    private int time;
    private double bitrate;
    private double speed;

    public Statistics() {
        this.executionId = 0L;
        this.videoFrameNumber = 0;
        this.videoFps = 0.0f;
        this.videoQuality = 0.0f;
        this.size = 0L;
        this.time = 0;
        this.bitrate = 0.0;
        this.speed = 0.0;
    }

    public Statistics(long executionId, int videoFrameNumber, float videoFps, float videoQuality, long size, int time, double bitrate, double speed) {
        this.executionId = executionId;
        this.videoFrameNumber = videoFrameNumber;
        this.videoFps = videoFps;
        this.videoQuality = videoQuality;
        this.size = size;
        this.time = time;
        this.bitrate = bitrate;
        this.speed = speed;
    }

    public void update(Statistics newStatistics) {
        if (newStatistics != null) {
            this.executionId = newStatistics.getExecutionId();
            if (newStatistics.getVideoFrameNumber() > 0) {
                this.videoFrameNumber = newStatistics.getVideoFrameNumber();
            }
            if (newStatistics.getVideoFps() > 0.0f) {
                this.videoFps = newStatistics.getVideoFps();
            }
            if (newStatistics.getVideoQuality() > 0.0f) {
                this.videoQuality = newStatistics.getVideoQuality();
            }
            if (newStatistics.getSize() > 0L) {
                this.size = newStatistics.getSize();
            }
            if (newStatistics.getTime() > 0) {
                this.time = newStatistics.getTime();
            }
            if (newStatistics.getBitrate() > 0.0) {
                this.bitrate = newStatistics.getBitrate();
            }
            if (newStatistics.getSpeed() > 0.0) {
                this.speed = newStatistics.getSpeed();
            }
        }
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(long executionId) {
        this.executionId = executionId;
    }

    public int getVideoFrameNumber() {
        return this.videoFrameNumber;
    }

    public void setVideoFrameNumber(int videoFrameNumber) {
        this.videoFrameNumber = videoFrameNumber;
    }

    public float getVideoFps() {
        return this.videoFps;
    }

    public void setVideoFps(float videoFps) {
        this.videoFps = videoFps;
    }

    public float getVideoQuality() {
        return this.videoQuality;
    }

    public void setVideoQuality(float videoQuality) {
        this.videoQuality = videoQuality;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public double getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(double bitrate) {
        this.bitrate = bitrate;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Statistics{");
        stringBuilder.append("executionId=");
        stringBuilder.append(this.executionId);
        stringBuilder.append(", videoFrameNumber=");
        stringBuilder.append(this.videoFrameNumber);
        stringBuilder.append(", videoFps=");
        stringBuilder.append(this.videoFps);
        stringBuilder.append(", videoQuality=");
        stringBuilder.append(this.videoQuality);
        stringBuilder.append(", size=");
        stringBuilder.append(this.size);
        stringBuilder.append(", time=");
        stringBuilder.append(this.time);
        stringBuilder.append(", bitrate=");
        stringBuilder.append(this.bitrate);
        stringBuilder.append(", speed=");
        stringBuilder.append(this.speed);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

