/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.NetworkManagementClient;
import com.azure.resourcemanager.network.fluent.models.PrivateEndpointInner;
import com.azure.resourcemanager.network.fluent.models.SubnetInner;
import com.azure.resourcemanager.network.implementation.PrivateDnsZoneGroupsImpl;
import com.azure.resourcemanager.network.models.CustomDnsConfigPropertiesFormat;
import com.azure.resourcemanager.network.models.PrivateDnsZoneGroups;
import com.azure.resourcemanager.network.models.PrivateEndpoint;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnection;
import com.azure.resourcemanager.network.models.PrivateLinkServiceConnectionState;
import com.azure.resourcemanager.network.models.PrivateLinkSubResourceName;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class PrivateEndpointImpl
extends GroupableResourceImpl<PrivateEndpoint, PrivateEndpointInner, PrivateEndpointImpl, NetworkManager>
implements PrivateEndpoint,
PrivateEndpoint.Definition,
PrivateEndpoint.Update {
    private final ClientLogger logger = new ClientLogger(PrivateEndpointImpl.class);
    private PrivateDnsZoneGroups privateDnsZoneGroups;

    protected PrivateEndpointImpl(String name, PrivateEndpointInner innerObject, NetworkManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
    }

    @Override
    public PrivateDnsZoneGroups privateDnsZoneGroups() {
        if (this.privateDnsZoneGroups == null) {
            this.privateDnsZoneGroups = new PrivateDnsZoneGroupsImpl(this);
        }
        return this.privateDnsZoneGroups;
    }

    @Override
    public SubResource subnet() {
        return new SubResource().withId(((PrivateEndpointInner)((Object)this.innerModel())).subnet().id());
    }

    @Override
    public List<SubResource> networkInterfaces() {
        if (((PrivateEndpointInner)((Object)this.innerModel())).networkInterfaces() == null) {
            return Collections.emptyList();
        }
        return ((PrivateEndpointInner)((Object)this.innerModel())).networkInterfaces().stream().map(ni -> new SubResource().withId(ni.id())).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((PrivateEndpointInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public Map<String, PrivateEndpoint.PrivateLinkServiceConnection> privateLinkServiceConnections() {
        HashMap connections = new HashMap();
        if (((PrivateEndpointInner)((Object)this.innerModel())).privateLinkServiceConnections() != null) {
            connections.putAll(((PrivateEndpointInner)((Object)this.innerModel())).privateLinkServiceConnections().stream().map(connection -> new PrivateEndpointConnectionImpl((PrivateLinkServiceConnection)((Object)connection), this, false)).collect(Collectors.toMap(PrivateEndpointConnectionImpl::name, Function.identity())));
        }
        if (((PrivateEndpointInner)((Object)this.innerModel())).manualPrivateLinkServiceConnections() != null) {
            connections.putAll(((PrivateEndpointInner)((Object)this.innerModel())).manualPrivateLinkServiceConnections().stream().map(connection -> new PrivateEndpointConnectionImpl((PrivateLinkServiceConnection)((Object)connection), this, true)).collect(Collectors.toMap(PrivateEndpointConnectionImpl::name, Function.identity())));
        }
        return Collections.unmodifiableMap(connections);
    }

    @Override
    public List<CustomDnsConfigPropertiesFormat> customDnsConfigurations() {
        if (((PrivateEndpointInner)((Object)this.innerModel())).networkInterfaces() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(((PrivateEndpointInner)((Object)this.innerModel())).customDnsConfigs());
    }

    @Override
    public PrivateEndpointImpl withSubnet(Subnet subnet) {
        ((PrivateEndpointInner)((Object)this.innerModel())).withSubnet((SubnetInner)((Object)Objects.requireNonNull(subnet).innerModel()));
        return this;
    }

    @Override
    public PrivateEndpointImpl withSubnetId(String subnetId) {
        ((PrivateEndpointInner)((Object)this.innerModel())).withSubnet(new SubnetInner().withId(Objects.requireNonNull(subnetId)));
        return this;
    }

    @Override
    public PrivateEndpointImpl withoutPrivateLinkServiceConnection(String name) {
        if (((PrivateEndpointInner)((Object)this.innerModel())).privateLinkServiceConnections() != null) {
            ((PrivateEndpointInner)((Object)this.innerModel())).privateLinkServiceConnections().removeIf(connection -> connection.name().equals(name));
        }
        if (((PrivateEndpointInner)((Object)this.innerModel())).manualPrivateLinkServiceConnections() != null) {
            ((PrivateEndpointInner)((Object)this.innerModel())).manualPrivateLinkServiceConnections().removeIf(connection -> connection.name().equals(name));
        }
        return this;
    }

    public PrivateEndpointConnectionImpl definePrivateLinkServiceConnection(String name) {
        return new PrivateEndpointConnectionImpl(Objects.requireNonNull(name), this);
    }

    @Override
    public PrivateEndpoint.PrivateLinkServiceConnection.Update updatePrivateLinkServiceConnection(String name) {
        Optional<PrivateLinkServiceConnection> connection;
        if (((PrivateEndpointInner)((Object)this.innerModel())).privateLinkServiceConnections() != null && (connection = ((PrivateEndpointInner)((Object)this.innerModel())).privateLinkServiceConnections().stream().filter(c -> c.name().equals(name)).findAny()).isPresent()) {
            return new PrivateEndpointConnectionImpl(connection.get(), this, false);
        }
        if (((PrivateEndpointInner)((Object)this.innerModel())).manualPrivateLinkServiceConnections() != null && (connection = ((PrivateEndpointInner)((Object)this.innerModel())).manualPrivateLinkServiceConnections().stream().filter(c -> c.name().equals(name)).findAny()).isPresent()) {
            return new PrivateEndpointConnectionImpl(connection.get(), this, true);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Private link service connection not found for name '%s'", name)));
    }

    PrivateEndpointImpl withPrivateEndpointConnection(PrivateEndpointConnectionImpl connection) {
        if (connection.isManualApproval()) {
            if (((PrivateEndpointInner)((Object)this.innerModel())).manualPrivateLinkServiceConnections() == null) {
                ((PrivateEndpointInner)((Object)this.innerModel())).withManualPrivateLinkServiceConnections(new ArrayList<PrivateLinkServiceConnection>());
            }
            ((PrivateEndpointInner)((Object)this.innerModel())).manualPrivateLinkServiceConnections().add((PrivateLinkServiceConnection)((Object)connection.innerModel()));
        } else {
            if (((PrivateEndpointInner)((Object)this.innerModel())).privateLinkServiceConnections() == null) {
                ((PrivateEndpointInner)((Object)this.innerModel())).withPrivateLinkServiceConnections(new ArrayList<PrivateLinkServiceConnection>());
            }
            ((PrivateEndpointInner)((Object)this.innerModel())).privateLinkServiceConnections().add((PrivateLinkServiceConnection)((Object)connection.innerModel()));
        }
        return this;
    }

    public Mono<PrivateEndpoint> createResourceAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPrivateEndpoints().createOrUpdateAsync(this.resourceGroupName(), this.name(), (PrivateEndpointInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<PrivateEndpointInner> getInnerAsync() {
        return ((NetworkManagementClient)((NetworkManager)this.manager()).serviceClient()).getPrivateEndpoints().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    static class PrivateEndpointConnectionImpl
    extends ChildResourceImpl<PrivateLinkServiceConnection, PrivateEndpointImpl, PrivateEndpoint>
    implements PrivateEndpoint.PrivateLinkServiceConnection,
    PrivateEndpoint.PrivateLinkServiceConnection.Definition<PrivateEndpointImpl>,
    PrivateEndpoint.PrivateLinkServiceConnection.Update {
        private boolean manualApproval = false;

        PrivateEndpointConnectionImpl(String name, PrivateEndpointImpl parent) {
            super((Object)new PrivateLinkServiceConnection().withName(name), (Object)parent);
        }

        PrivateEndpointConnectionImpl(PrivateLinkServiceConnection innerModel, PrivateEndpointImpl parent, boolean manualApproval) {
            super((Object)innerModel, (Object)parent);
            this.manualApproval = manualApproval;
        }

        public String name() {
            return ((PrivateLinkServiceConnection)((Object)this.innerModel())).name();
        }

        @Override
        public PrivateLinkServiceConnectionState state() {
            return ((PrivateLinkServiceConnection)((Object)this.innerModel())).privateLinkServiceConnectionState();
        }

        @Override
        public String privateLinkResourceId() {
            return ((PrivateLinkServiceConnection)((Object)this.innerModel())).privateLinkServiceId();
        }

        @Override
        public List<PrivateLinkSubResourceName> subResourceNames() {
            if (((PrivateLinkServiceConnection)((Object)this.innerModel())).groupIds() == null) {
                return Collections.emptyList();
            }
            return ((PrivateLinkServiceConnection)((Object)this.innerModel())).groupIds().stream().map(PrivateLinkSubResourceName::fromString).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }

        @Override
        public String requestMessage() {
            return ((PrivateLinkServiceConnection)((Object)this.innerModel())).requestMessage();
        }

        @Override
        public ProvisioningState provisioningState() {
            return ((PrivateLinkServiceConnection)((Object)this.innerModel())).provisioningState();
        }

        @Override
        public boolean isManualApproval() {
            return this.manualApproval;
        }

        public PrivateEndpointImpl attach() {
            return ((PrivateEndpointImpl)this.parent()).withPrivateEndpointConnection(this);
        }

        public PrivateEndpointConnectionImpl withResource(com.azure.resourcemanager.resources.fluentcore.arm.models.Resource privateLinkServiceResource) {
            ((PrivateLinkServiceConnection)((Object)this.innerModel())).withPrivateLinkServiceId(Objects.requireNonNull(privateLinkServiceResource).id());
            return this;
        }

        public PrivateEndpointConnectionImpl withResourceId(String privateLinkServiceResourceId) {
            ((PrivateLinkServiceConnection)((Object)this.innerModel())).withPrivateLinkServiceId(Objects.requireNonNull(privateLinkServiceResourceId));
            return this;
        }

        public PrivateEndpointConnectionImpl withSubResource(PrivateLinkSubResourceName subResourceName) {
            ((PrivateLinkServiceConnection)((Object)this.innerModel())).withGroupIds(Collections.singletonList(Objects.requireNonNull(subResourceName).toString()));
            return this;
        }

        public PrivateEndpointConnectionImpl withoutSubResource() {
            ((PrivateLinkServiceConnection)((Object)this.innerModel())).withGroupIds(null);
            return this;
        }

        public PrivateEndpointConnectionImpl withManualApproval(String requestMessage) {
            this.manualApproval = true;
            ((PrivateLinkServiceConnection)((Object)this.innerModel())).withRequestMessage(requestMessage);
            return this;
        }

        @Override
        public PrivateEndpointConnectionImpl withRequestMessage(String requestMessage) {
            ((PrivateLinkServiceConnection)((Object)this.innerModel())).withRequestMessage(requestMessage);
            return this;
        }
    }
}

