/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.common.model;

import com.baidu.disconf.client.common.constants.SupportFileTypeEnum;
import com.baidu.disconf.client.common.model.DisconfCenterBaseModel;
import com.baidu.disconf.client.config.DisClientConfig;
import com.baidu.disconf.client.support.utils.ClassUtils;
import com.baidu.disconf.core.common.utils.ClassLoaderUtil;
import com.baidu.disconf.core.common.utils.OsUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconfCenterFile
extends DisconfCenterBaseModel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfCenterFile.class);
    private Map<String, FileItemValue> keyMaps = new HashMap<String, FileItemValue>();
    private Map<String, Object> additionalKeyMaps = new HashMap<String, Object>();
    private boolean isTaggedWithNonAnnotationFile = false;
    private Class<?> cls;
    private String fileName;
    private String copy2TargetDirPath;
    private SupportFileTypeEnum supportFileTypeEnum = SupportFileTypeEnum.ANY;

    public Class<?> getCls() {
        return this.cls;
    }

    public void setCls(Class<?> cls) {
        this.cls = cls;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Map<String, FileItemValue> getKeyMaps() {
        return this.keyMaps;
    }

    public void setKeyMaps(Map<String, FileItemValue> keyMaps) {
        this.keyMaps = keyMaps;
    }

    public Map<String, Object> getAdditionalKeyMaps() {
        return this.additionalKeyMaps;
    }

    public void setAdditionalKeyMaps(Map<String, Object> additionalKeyMaps) {
        this.additionalKeyMaps = additionalKeyMaps;
    }

    public SupportFileTypeEnum getSupportFileTypeEnum() {
        return this.supportFileTypeEnum;
    }

    public void setSupportFileTypeEnum(SupportFileTypeEnum supportFileTypeEnum) {
        this.supportFileTypeEnum = supportFileTypeEnum;
    }

    public boolean isTaggedWithNonAnnotationFile() {
        return this.isTaggedWithNonAnnotationFile;
    }

    public void setIsTaggedWithNonAnnotationFile(boolean isTaggedWithNonAnnotationFile) {
        this.isTaggedWithNonAnnotationFile = isTaggedWithNonAnnotationFile;
    }

    public String getCopy2TargetDirPath() {
        return this.copy2TargetDirPath;
    }

    public void setCopy2TargetDirPath(String copy2TargetDirPath) {
        this.copy2TargetDirPath = copy2TargetDirPath;
    }

    @Override
    public String toString() {
        return "\n\tDisconfCenterFile [\n\tkeyMaps=" + this.keyMaps + "\n\tcls=" + this.cls + "\n\tfileName=" + this.fileName + "\n\tcopy2TargetDirPath=" + this.copy2TargetDirPath + super.toString() + "]";
    }

    @Override
    public String infoString() {
        return "\n\tDisconfCenterFile [\n\tkeyMaps=" + this.keyMaps + "\n" + "\tadditionalKeyMaps=" + this.additionalKeyMaps + "\n\tcls=" + this.cls + super.infoString() + "]";
    }

    public Map<String, Object> getKV() {
        if (this.keyMaps.size() == 0) {
            return this.additionalKeyMaps;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.keyMaps.keySet()) {
            map.put(key, this.keyMaps.get(key).getValue());
        }
        return map;
    }

    public String getFilePath() {
        if (!DisClientConfig.getInstance().enableLocalDownloadDirInClassPath) {
            return OsUtil.pathJoin((String[])new String[]{DisClientConfig.getInstance().userDefineDownloadDir, this.fileName});
        }
        if (this.copy2TargetDirPath != null) {
            if (this.copy2TargetDirPath.startsWith("/")) {
                return OsUtil.pathJoin((String[])new String[]{this.copy2TargetDirPath, this.fileName});
            }
            return OsUtil.pathJoin((String[])new String[]{ClassLoaderUtil.getClassPath(), this.copy2TargetDirPath, this.fileName});
        }
        return OsUtil.pathJoin((String[])new String[]{ClassLoaderUtil.getClassPath(), this.fileName});
    }

    public String getFileDir() {
        if (this.copy2TargetDirPath != null) {
            if (this.copy2TargetDirPath.startsWith("/")) {
                return OsUtil.pathJoin((String[])new String[]{this.copy2TargetDirPath});
            }
            return OsUtil.pathJoin((String[])new String[]{ClassLoaderUtil.getClassPath(), this.copy2TargetDirPath});
        }
        return ClassLoaderUtil.getClassPath();
    }

    public static class FileItemValue {
        private Object value;
        private Field field;
        private Method setMethod;

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.field.getModifiers());
        }

        public Object setValue4StaticFileItem(Object value) throws Exception {
            if (this.setMethod != null) {
                this.setMethod.invoke(null, value);
            } else {
                this.field.set(null, value);
            }
            return value;
        }

        public Object setValue4FileItem(Object object, Object value) throws Exception {
            if (this.setMethod != null) {
                this.setMethod.invoke(object, value);
            } else {
                this.field.set(object, value);
            }
            return value;
        }

        public Object getFieldValueByType(Object fieldValue) throws Exception {
            return ClassUtils.getValeByType(this.field.getType(), fieldValue);
        }

        public Object getFieldDefaultValue(Object object) throws Exception {
            return this.field.get(object);
        }

        public String toString() {
            return "FileItemValue{value=" + this.value + ", field=" + this.field + ", setMethod=" + this.setMethod + '}';
        }

        public FileItemValue(Object value, Field field) {
            this.value = value;
            this.field = field;
        }

        public FileItemValue(Object value, Field field, Method setMethod) {
            this.value = value;
            this.field = field;
            this.setMethod = setMethod;
        }
    }
}

