/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.config.inner;

import com.baidu.disconf.client.config.DisClientConfig;
import com.baidu.disconf.client.config.DisClientSysConfig;
import com.baidu.disconf.client.support.utils.StringUtil;
import com.baidu.disconf.core.common.utils.ClassLoaderUtil;
import com.baidu.disconf.core.common.utils.OsUtil;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisInnerConfigHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisInnerConfigHelper.class);

    public static void verifyUserConfig() throws Exception {
        if (StringUtils.isEmpty((CharSequence)DisClientConfig.getInstance().CONF_SERVER_HOST)) {
            throw new Exception("settings: disconf.conf_server_host cannot find");
        }
        DisClientConfig.getInstance().setHostList(StringUtil.parseStringToStringList(DisClientConfig.getInstance().CONF_SERVER_HOST, ","));
        LOGGER.info("SERVER disconf.conf_server_host: " + DisClientConfig.getInstance().getHostList());
        if (StringUtils.isEmpty((CharSequence)DisClientConfig.getInstance().VERSION)) {
            throw new Exception("settings: disconf.version cannot find");
        }
        LOGGER.info("SERVER disconf.version: " + DisClientConfig.getInstance().VERSION);
        if (StringUtils.isEmpty((CharSequence)DisClientConfig.getInstance().APP)) {
            throw new Exception("settings: disconf.app cannot find");
        }
        LOGGER.info("SERVER disconf.app: " + DisClientConfig.getInstance().APP);
        if (StringUtils.isEmpty((CharSequence)DisClientConfig.getInstance().ENV)) {
            throw new Exception("settings: disconf.env  cannot find");
        }
        LOGGER.info("SERVER disconf.env: " + DisClientConfig.getInstance().ENV);
        LOGGER.info("SERVER disconf.enable.remote.conf: " + DisClientConfig.getInstance().ENABLE_DISCONF);
        LOGGER.info("SERVER disconf.debug: " + DisClientConfig.getInstance().DEBUG);
        if (!StringUtils.isEmpty((CharSequence)DisClientConfig.getInstance().userDefineDownloadDir)) {
            OsUtil.makeDirs((String)DisClientConfig.getInstance().userDefineDownloadDir);
            LOGGER.info("SERVER disconf.user_define_download_dir: " + DisClientConfig.getInstance().userDefineDownloadDir);
        }
        List<String> ignoreDisconfList = StringUtil.parseStringToStringList(DisClientConfig.getInstance().IGNORE_DISCONF_LIST, ",");
        HashSet<String> keySet = new HashSet<String>();
        if (ignoreDisconfList != null) {
            for (String ignoreData : ignoreDisconfList) {
                keySet.add(ignoreData.trim());
            }
        }
        DisClientConfig.getInstance().setIgnoreDisconfKeySet(keySet);
        LOGGER.info("SERVER ignore: " + DisClientConfig.getInstance().getIgnoreDisconfKeySet());
        LOGGER.debug("SERVER conf_server_url_retry_times: " + DisClientConfig.getInstance().CONF_SERVER_URL_RETRY_TIMES);
        LOGGER.debug("SERVER conf_server_url_retry_sleep_seconds: " + DisClientConfig.getInstance().confServerUrlRetrySleepSeconds);
        if (DisClientConfig.getInstance().enableLocalDownloadDirInClassPath) {
            String classpath = ClassLoaderUtil.getClassPath();
            if (classpath.isEmpty()) {
                LOGGER.warn("CLASSPATH is null. we will not transfer your config file to classpath in the following");
            } else {
                LOGGER.debug("classpath: " + classpath);
            }
        }
    }

    public static void verifySysConfig() throws Exception {
        if (StringUtils.isEmpty((CharSequence)DisClientSysConfig.getInstance().CONF_SERVER_STORE_ACTION)) {
            throw new Exception("settings: CONF_SERVER_STORE_ACTION cannot find");
        }
        LOGGER.debug("SERVER CONF_SERVER_STORE_ACTION: " + DisClientSysConfig.getInstance().CONF_SERVER_STORE_ACTION);
        if (StringUtils.isEmpty((CharSequence)DisClientSysConfig.getInstance().CONF_SERVER_ZOO_ACTION)) {
            throw new Exception("settings: CONF_SERVER_ZOO_ACTION cannot find");
        }
        LOGGER.debug("SERVER CONF_SERVER_ZOO_ACTION: " + DisClientSysConfig.getInstance().CONF_SERVER_ZOO_ACTION);
        if (StringUtils.isEmpty((CharSequence)DisClientSysConfig.getInstance().CONF_SERVER_MASTER_NUM_ACTION)) {
            throw new Exception("settings: CONF_SERVER_MASTER_NUM_ACTION  cannot find");
        }
        LOGGER.debug("SERVER CONF_SERVER_MASTER_NUM_ACTION Action URL: " + DisClientSysConfig.getInstance().CONF_SERVER_MASTER_NUM_ACTION);
        if (StringUtils.isEmpty((CharSequence)DisClientSysConfig.getInstance().LOCAL_DOWNLOAD_DIR)) {
            throw new Exception("settings: LOCAL_TMP_DIR cannot find");
        }
        LOGGER.debug("SERVER LOCAL_DOWNLOAD_DIR: " + DisClientSysConfig.getInstance().LOCAL_DOWNLOAD_DIR);
        OsUtil.makeDirs((String)DisClientSysConfig.getInstance().LOCAL_DOWNLOAD_DIR);
    }
}

