/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.scan.impl;

import com.baidu.disconf.client.config.DisClientConfig;
import com.baidu.disconf.client.scan.ScanMgr;
import com.baidu.disconf.client.scan.inner.dynamic.ScanDynamicStoreAdapter;
import com.baidu.disconf.client.scan.inner.statically.StaticScannerMgr;
import com.baidu.disconf.client.scan.inner.statically.StaticScannerMgrFactory;
import com.baidu.disconf.client.scan.inner.statically.impl.StaticScannerNonAnnotationFileMgrImpl;
import com.baidu.disconf.client.scan.inner.statically.model.ScanStaticModel;
import com.baidu.disconf.client.scan.inner.statically.strategy.ScanStaticStrategy;
import com.baidu.disconf.client.scan.inner.statically.strategy.impl.ReflectionScanStatic;
import com.baidu.disconf.client.store.inner.DisconfCenterHostFilesStore;
import com.baidu.disconf.client.support.registry.Registry;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanMgrImpl
implements ScanMgr {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ScanMgrImpl.class);
    private volatile ScanStaticModel scanModel = null;
    private Registry registry = null;
    private List<StaticScannerMgr> staticScannerMgrList = new ArrayList<StaticScannerMgr>();
    private ScanStaticStrategy scanStaticStrategy = new ReflectionScanStatic();

    public ScanMgrImpl(Registry registry) {
        this.registry = registry;
        this.staticScannerMgrList.add(StaticScannerMgrFactory.getDisconfFileStaticScanner());
        this.staticScannerMgrList.add(StaticScannerMgrFactory.getDisconfItemStaticScanner());
        this.staticScannerMgrList.add(StaticScannerMgrFactory.getDisconfNonAnnotationFileStaticScanner());
    }

    @Override
    public void firstScan(List<String> packageNameList) throws Exception {
        LOGGER.debug("start to scan package: " + packageNameList.toString());
        this.scanModel = this.scanStaticStrategy.scan(packageNameList);
        this.scanModel.setJustHostFiles(DisconfCenterHostFilesStore.getInstance().getJustHostFiles());
        for (StaticScannerMgr scannerMgr : this.staticScannerMgrList) {
            scannerMgr.scanData2Store(this.scanModel);
            scannerMgr.exclude(DisClientConfig.getInstance().getIgnoreDisconfKeySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void secondScan() throws Exception {
        if (DisClientConfig.getInstance().ENABLE_DISCONF) {
            if (this.scanModel == null) {
                ScanStaticModel scanStaticModel = this.scanModel;
                synchronized (scanStaticModel) {
                    if (this.scanModel == null) {
                        throw new Exception("You should run first scan before second Scan");
                    }
                }
            }
            ScanDynamicStoreAdapter.scanUpdateCallbacks(this.scanModel, this.registry);
        }
    }

    @Override
    public void reloadableScan(String fileName) throws Exception {
        StaticScannerNonAnnotationFileMgrImpl.scanData2Store(fileName);
    }
}

