/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.disconf.client.store.processor.impl;

import com.baidu.disconf.client.addons.properties.ReloadConfigurationMonitor;
import com.baidu.disconf.client.common.constants.SupportFileTypeEnum;
import com.baidu.disconf.client.common.model.DisConfCommonModel;
import com.baidu.disconf.client.common.model.DisconfCenterBaseModel;
import com.baidu.disconf.client.common.model.DisconfCenterFile;
import com.baidu.disconf.client.common.update.IDisconfUpdate;
import com.baidu.disconf.client.store.DisconfStoreProcessor;
import com.baidu.disconf.client.store.inner.DisconfCenterStore;
import com.baidu.disconf.client.store.processor.model.DisconfValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisconfStoreFileProcessorImpl
implements DisconfStoreProcessor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DisconfStoreFileProcessorImpl.class);

    @Override
    public void addUpdateCallbackList(String keyName, List<IDisconfUpdate> iDisconfUpdateList) {
        if (DisconfCenterStore.getInstance().getConfFileMap().containsKey(keyName)) {
            DisconfCenterStore.getInstance().getConfFileMap().get(keyName).getDisconfCommonCallbackModel().getDisconfConfUpdates().addAll(iDisconfUpdateList);
        }
    }

    @Override
    public List<IDisconfUpdate> getUpdateCallbackList(String keyName) {
        if (DisconfCenterStore.getInstance().getConfFileMap().containsKey(keyName)) {
            return DisconfCenterStore.getInstance().getConfFileMap().get(keyName).getDisconfCommonCallbackModel().getDisconfConfUpdates();
        }
        return new ArrayList<IDisconfUpdate>();
    }

    @Override
    public DisConfCommonModel getCommonModel(String keyName) {
        DisconfCenterFile disconfCenterFile = DisconfCenterStore.getInstance().getConfFileMap().get(keyName);
        if (disconfCenterFile == null) {
            LOGGER.error("cannot find " + keyName + " in store....");
            return null;
        }
        return disconfCenterFile.getDisConfCommonModel();
    }

    @Override
    public boolean hasThisConf(String keyName) {
        return DisconfCenterStore.getInstance().getConfFileMap().containsKey(keyName);
    }

    @Override
    public void inject2Instance(Object object, String fileName) {
        DisconfCenterFile disconfCenterFile = DisconfCenterStore.getInstance().getConfFileMap().get(fileName);
        if (disconfCenterFile == null) {
            LOGGER.error("cannot find " + fileName + " in store....");
            return;
        }
        if (object != null) {
            disconfCenterFile.setObject(object);
        }
        Map<String, DisconfCenterFile.FileItemValue> keMap = disconfCenterFile.getKeyMaps();
        for (String fileItem : keMap.keySet()) {
            try {
                if (object == null) {
                    if (!keMap.get(fileItem).isStatic()) continue;
                    LOGGER.debug(fileItem + " is a static field. ");
                    keMap.get(fileItem).setValue4StaticFileItem(keMap.get(fileItem).getValue());
                    continue;
                }
                LOGGER.debug(fileItem + " is a non-static field. ");
                if (keMap.get(fileItem).getValue() == null) {
                    Object defaultValue = keMap.get(fileItem).getFieldDefaultValue(object);
                    keMap.get(fileItem).setValue(defaultValue);
                    continue;
                }
                keMap.get(fileItem).setValue4FileItem(object, keMap.get(fileItem).getValue());
            }
            catch (Exception e) {
                LOGGER.error("inject2Instance fileName " + fileName + " " + e.toString(), (Throwable)e);
            }
        }
    }

    @Override
    public Object getConfig(String fileName, String keyName) {
        DisconfCenterFile disconfCenterFile = DisconfCenterStore.getInstance().getConfFileMap().get(fileName);
        if (disconfCenterFile == null) {
            LOGGER.debug("cannot find " + fileName + " in store....");
            return null;
        }
        if (disconfCenterFile.getKeyMaps().get(keyName) == null) {
            LOGGER.debug("cannot find " + fileName + ", " + keyName + " in store....");
            return null;
        }
        return disconfCenterFile.getKeyMaps().get(keyName).getValue();
    }

    @Override
    public void inject2Store(String fileName, DisconfValue disconfValue) {
        DisconfCenterFile disconfCenterFile = DisconfCenterStore.getInstance().getConfFileMap().get(fileName);
        if (disconfCenterFile == null) {
            LOGGER.error("cannot find " + fileName + " in store....");
            return;
        }
        if (disconfValue == null || disconfValue.getFileData() == null) {
            LOGGER.error("value is null for {}", (Object)fileName);
            return;
        }
        Map<String, DisconfCenterFile.FileItemValue> keMap = disconfCenterFile.getKeyMaps();
        if (keMap.size() > 0) {
            for (String fileItem : keMap.keySet()) {
                Object object = disconfValue.getFileData().get(fileItem);
                if (object == null) {
                    LOGGER.error("cannot find {} to be injected. file content is: {}", (Object)fileItem, (Object)disconfValue.getFileData().toString());
                    continue;
                }
                try {
                    Object value = keMap.get(fileItem).getFieldValueByType(object);
                    keMap.get(fileItem).setValue(value);
                }
                catch (Exception e) {
                    LOGGER.error("inject2Store filename: " + fileName + " " + e.toString(), (Throwable)e);
                }
            }
        }
        if (disconfCenterFile.isTaggedWithNonAnnotationFile()) {
            if (disconfCenterFile.getObject() == null && disconfCenterFile.getSupportFileTypeEnum().equals((Object)SupportFileTypeEnum.PROPERTIES)) {
                ReloadConfigurationMonitor.reload();
            }
            disconfCenterFile.setAdditionalKeyMaps(disconfValue.getFileData());
        }
    }

    @Override
    public void transformScanData(List<DisconfCenterBaseModel> disconfCenterBaseModels) {
        for (DisconfCenterBaseModel disconfCenterFile : disconfCenterBaseModels) {
            this.transformScanData(disconfCenterFile);
        }
    }

    @Override
    public void transformScanData(DisconfCenterBaseModel disconfCenterBaseModel) {
        DisconfCenterStore.getInstance().storeOneFile(disconfCenterBaseModel);
    }

    @Override
    public DisconfCenterBaseModel getConfData(String key) {
        if (DisconfCenterStore.getInstance().getConfFileMap().containsKey(key)) {
            return DisconfCenterStore.getInstance().getConfFileMap().get(key);
        }
        return null;
    }

    @Override
    public Set<String> getConfKeySet() {
        return DisconfCenterStore.getInstance().getConfFileMap().keySet();
    }

    @Override
    public String confToString() {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append("\n");
        Map<String, DisconfCenterFile> disMap = DisconfCenterStore.getInstance().getConfFileMap();
        for (String file : disMap.keySet()) {
            sBuffer.append("disconf-file:\t" + file + "\t");
            if (LOGGER.isDebugEnabled()) {
                sBuffer.append(disMap.get(file).toString());
            } else {
                sBuffer.append(disMap.get(file).infoString());
            }
            sBuffer.append("\n");
        }
        return sBuffer.toString();
    }

    @Override
    public void exclude(Set<String> keySet) {
        for (String key : keySet) {
            DisconfCenterStore.getInstance().excludeOneFile(key);
        }
    }
}

