/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.geofence;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import com.baidu.geofence.GeoFence;
import com.baidu.geofence.GeoFenceListener;
import com.baidu.geofence.PoiItem;
import com.baidu.geofence.a.b;
import com.baidu.geofence.a.c;
import com.baidu.geofence.a.d;
import com.baidu.geofence.model.DPoint;
import com.baidu.geofence.model.a;
import com.baidu.location.BDAbstractLocationListener;
import com.baidu.location.BDLocation;
import com.baidu.location.LocationClient;
import com.baidu.location.LocationClientOption;
import com.baidu.location.h.i;
import com.baidu.location.indoor.j;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeoFenceClient
extends BDAbstractLocationListener
implements d.a {
    public static final int GEOFENCE_IN = 1;
    public static final int GEOFENCE_OUT = 2;
    public static final int GEOFENCE_STAYED = 3;
    public static final int GEOFENCE_IN_OUT = 4;
    public static final int GEOFENCE_IN_STAYED = 5;
    public static final int GEOFENCE_OUT_STAYED = 6;
    public static final int GEOFENCE_IN_OUT_STAYED = 7;
    public static final String GCJ02 = "gcj02";
    public static final String WGS84 = "wgs84";
    public static final String BD09LL = "bd09ll";
    public static final String BD09MC = "bd09mc";
    private String a;
    private int b = 600;
    private GeoFenceListener c;
    private ArrayList<GeoFence> d;
    private LocationClient e;
    private Intent f;
    private PendingIntent g;
    private Context h;
    private int i = 1;
    private int j = 1;
    private boolean k = true;
    private LocationClientOption l;
    private boolean m = false;
    private boolean n = false;
    private long o;
    private StringBuilder p;
    private StringBuilder q;
    private StringBuilder r;
    private StringBuilder s;
    private StringBuilder t;
    private int u = Integer.MAX_VALUE;
    private int v = Integer.MAX_VALUE;
    private int w = Integer.MAX_VALUE;
    private Map<String, Integer> x;
    private static Handler y;

    public static Handler getHandlerInstance() {
        if (y == null) {
            y = Looper.myLooper() == null ? new Handler(Looper.getMainLooper()) : new Handler(Looper.myLooper());
        }
        return y;
    }

    public GeoFenceClient(Context context) {
        this.h = context;
        this.d = new ArrayList();
        this.x = new HashMap<String, Integer>();
        this.p = new StringBuilder();
        this.q = new StringBuilder();
        this.r = new StringBuilder();
        this.s = new StringBuilder();
        this.t = new StringBuilder();
        y = Looper.myLooper() == null ? new Handler(Looper.getMainLooper()) : new Handler(Looper.myLooper());
        try {
            this.e = new LocationClient(this.h);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.l = new LocationClientOption();
        this.l.setScanSpan(5000);
        this.l.setIsNeedAddress(true);
        if (this.e != null) {
            this.e.setLocOption(this.l);
            this.e.registerLocationListener(this);
        }
        this.o = System.currentTimeMillis();
        com.baidu.location.h.b.a().a(this.l.prodName, this.h.getPackageName());
    }

    public void isHighAccuracyLoc(boolean bl) {
        this.m = bl;
    }

    private boolean a(String string) {
        return GCJ02.equalsIgnoreCase(string) || BD09LL.equalsIgnoreCase(string) || BD09MC.equalsIgnoreCase(string) || WGS84.equalsIgnoreCase(string);
    }

    private BDLocation a(DPoint dPoint, String string) {
        BDLocation bDLocation = new BDLocation();
        bDLocation.setLatitude(dPoint.getLatitude());
        bDLocation.setLongitude(dPoint.getLongitude());
        BDLocation bDLocation2 = null;
        if (TextUtils.equals((CharSequence)BD09MC, (CharSequence)string)) {
            bDLocation2 = LocationClient.getBDLocationInCoorType(bDLocation, "bd092gcj");
        } else if (TextUtils.equals((CharSequence)BD09LL, (CharSequence)string)) {
            bDLocation2 = LocationClient.getBDLocationInCoorType(bDLocation, "bd09ll2gcj");
        } else if (TextUtils.equals((CharSequence)WGS84, (CharSequence)string)) {
            bDLocation2 = LocationClient.getBDLocationInCoorType(bDLocation, "gps2gcj");
        } else if (TextUtils.equals((CharSequence)GCJ02, (CharSequence)string)) {
            bDLocation2 = new BDLocation();
            bDLocation2.setLatitude(dPoint.getLatitude());
            bDLocation2.setLongitude(dPoint.getLongitude());
        }
        return bDLocation2;
    }

    private void a(GeoFence geoFence) {
        String string = geoFence.getActivatesAction();
        if (geoFence == null || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (string.contains("1")) {
            if (this.u < 1) {
                geoFence.setInTriggerCount(1);
            } else {
                geoFence.setInTriggerCount(this.u);
            }
        }
        if (string.contains("2")) {
            if (this.v < 1) {
                geoFence.setOutTriggerCount(1);
            } else {
                geoFence.setOutTriggerCount(this.v);
            }
        }
        if (string.contains("3")) {
            if (this.w < 1) {
                geoFence.setStayTriggerCount(1);
            } else {
                geoFence.setStayTriggerCount(this.w);
            }
        }
    }

    public void addGeoFence(DPoint dPoint, String string, float f2, String string2) {
        if (dPoint == null) {
            return;
        }
        this.p.append("[").append(dPoint.getLatitude()).append(",").append(dPoint.getLongitude()).append(",").append(string).append(",").append(f2).append(",").append(string2).append("]");
        this.a("1", this.b("1") + 1);
        if (TextUtils.isEmpty((CharSequence)string) || !this.a(string) || f2 <= 0.0f || TextUtils.isEmpty((CharSequence)string2)) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 8, string2);
            }
            return;
        }
        BDLocation bDLocation = this.a(dPoint, string);
        if (Math.abs(bDLocation.getLatitude()) > 90.0 || Math.abs(bDLocation.getLongitude()) > 180.0) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 8, string2);
            }
            return;
        }
        DPoint dPoint2 = new DPoint(bDLocation.getLatitude(), bDLocation.getLongitude());
        for (GeoFence object2 : this.d) {
            if (object2.getType() != 20 || object2.getCenter().getLatitude() != dPoint2.getLatitude() || object2.getCenter().getLongitude() != dPoint2.getLongitude() || object2.getRadius() != f2) continue;
            this.c.onGeoFenceCreateFinished(this.d, 14, string2);
            return;
        }
        GeoFence geoFence = new GeoFence();
        geoFence.setFenceType(20);
        geoFence.setActivatesAction(this.a);
        if (!TextUtils.isEmpty((CharSequence)this.a) && this.a.contains("3")) {
            geoFence.setStayTime(this.b);
        }
        geoFence.setCustomId(string2);
        geoFence.setFenceId(String.valueOf(this.j++));
        geoFence.setCenter(dPoint2);
        geoFence.setRadius(f2);
        this.a(geoFence);
        this.d.add(geoFence);
        this.x.put(geoFence.getFenceId(), 2);
        ArrayList<GeoFence> arrayList = new ArrayList<GeoFence>();
        arrayList.add(geoFence);
        if (this.c != null) {
            this.c.onGeoFenceCreateFinished(arrayList, 7, string2);
        }
        this.n = false;
        this.a();
    }

    public void addGeoFence(ArrayList<DPoint> arrayList, String string, String string2) {
        this.q.append("[").append(string).append(",").append(string2);
        if (arrayList != null && !arrayList.isEmpty()) {
            for (DPoint object22 : arrayList) {
                this.q.append(",").append("(").append(object22.getLatitude()).append(",").append(object22.getLongitude()).append(")");
            }
        }
        this.q.append("]");
        this.a("2", this.b("2") + 1);
        if (arrayList == null || arrayList.size() < 3 || TextUtils.isEmpty((CharSequence)string) || !this.a(string) || TextUtils.isEmpty((CharSequence)string2)) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 8, string2);
            }
            return;
        }
        ArrayList arrayList2 = new ArrayList();
        for (DPoint dPoint : arrayList) {
            BDLocation bDLocation = this.a(dPoint, string);
            if (Math.abs(bDLocation.getLatitude()) > 90.0 || Math.abs(bDLocation.getLongitude()) > 180.0) {
                if (this.c != null) {
                    this.c.onGeoFenceCreateFinished(null, 8, string2);
                }
                return;
            }
            DPoint dPoint2 = new DPoint(bDLocation.getLatitude(), bDLocation.getLongitude());
            arrayList2.add(dPoint2);
        }
        for (GeoFence geoFence : this.d) {
            if (geoFence.getType() != 21 || geoFence.getPoints().size() != arrayList2.size()) continue;
            int n2 = 0;
            for (int i2 = 0; i2 < arrayList2.size() && ((DPoint)arrayList2.get(i2)).getLatitude() == geoFence.getPoints().get(i2).getLatitude() && ((DPoint)arrayList2.get(i2)).getLongitude() == geoFence.getPoints().get(i2).getLongitude(); ++i2) {
                ++n2;
            }
            if (n2 != arrayList2.size()) continue;
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 14, string2);
            }
            return;
        }
        GeoFence geoFence = new GeoFence();
        geoFence.setPoints(arrayList2);
        geoFence.setFenceType(21);
        geoFence.setActivatesAction(this.a);
        if (!TextUtils.isEmpty((CharSequence)this.a) && this.a.contains("3")) {
            geoFence.setStayTime(this.b);
        }
        geoFence.setCustomId(string2);
        geoFence.setFenceId(String.valueOf(this.j++));
        this.a(geoFence);
        this.d.add(geoFence);
        this.x.put(geoFence.getFenceId(), 2);
        ArrayList<GeoFence> arrayList3 = new ArrayList<GeoFence>();
        arrayList3.add(geoFence);
        if (this.c != null) {
            this.c.onGeoFenceCreateFinished(arrayList3, 7, string2);
        }
        this.n = false;
        this.a();
    }

    public void addGeoFence(final String string, String string2, DPoint dPoint, String string3, float f2, int n2, final String string4) {
        if (dPoint == null) {
            return;
        }
        this.r.append("[").append(string).append(",").append(string2).append(",").append("(").append(dPoint.getLatitude()).append(",").append(dPoint.getLongitude()).append(")").append(",").append(string3).append(",").append(f2).append(",").append(n2).append(",").append(string4).append("]");
        this.a("3", this.b("3") + 1);
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || f2 < 1.0f || f2 > 5000.0f || n2 <= 0 || n2 > 25 || TextUtils.isEmpty((CharSequence)string4) || !this.a(string3)) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 8, string4);
            }
            return;
        }
        BDLocation bDLocation = this.a(dPoint, string3);
        if (Math.abs(bDLocation.getLatitude()) > 90.0 || Math.abs(bDLocation.getLongitude()) > 180.0) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 8, string4);
            }
            return;
        }
        if (!com.baidu.location.h.i.a(this.h)) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 9, string4);
            }
            return;
        }
        DPoint dPoint2 = new DPoint(bDLocation.getLatitude(), bDLocation.getLongitude());
        c c2 = new c(this.h, true, this.c, this.d);
        c2.a(n2);
        c2.b(string);
        c2.c(string2);
        c2.a(dPoint2);
        c2.a(f2);
        c2.a(string4);
        c2.a(new c.a(){

            @Override
            public void a(int n2, ArrayList<PoiItem> arrayList) {
                if (n2 != 0) {
                    if (GeoFenceClient.this.c != null) {
                        GeoFenceClient.this.c.onGeoFenceCreateFinished(null, 13, string4);
                    }
                } else {
                    if (arrayList == null) {
                        return;
                    }
                    if (arrayList.size() == 0) {
                        return;
                    }
                    ArrayList<Object> arrayList2 = null;
                    for (PoiItem poiItem : arrayList) {
                        if (GeoFenceClient.this.d != null && GeoFenceClient.this.d.size() != 0) {
                            boolean bl = false;
                            for (GeoFence geoFence : GeoFenceClient.this.d) {
                                if (geoFence.getType() != 22 || poiItem.getLatitude() != geoFence.getPoiItem().getLatitude() || poiItem.getLongitude() != geoFence.getPoiItem().getLongitude()) continue;
                                if (GeoFenceClient.this.c != null) {
                                    GeoFenceClient.this.c.onGeoFenceCreateFinished(null, 14, string4);
                                }
                                bl = true;
                            }
                            if (bl) continue;
                            GeoFence geoFence = new GeoFence();
                            geoFence.setFenceType(22);
                            geoFence.setPoiItem(poiItem);
                            geoFence.setRadius(200.0f);
                            geoFence.setKeyWord(string);
                            geoFence.setActivatesAction(GeoFenceClient.this.a);
                            if (!TextUtils.isEmpty((CharSequence)GeoFenceClient.this.a) && GeoFenceClient.this.a.contains("3")) {
                                geoFence.setStayTime(GeoFenceClient.this.b);
                            }
                            geoFence.setCustomId(string4);
                            geoFence.setFenceId(String.valueOf(GeoFenceClient.this.j++));
                            GeoFenceClient.this.x.put(geoFence.getFenceId(), 2);
                            geoFence.setCenter(new DPoint(poiItem.getLatitude(), poiItem.getLongitude()));
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList();
                            }
                            GeoFenceClient.this.a(geoFence);
                            arrayList2.add(geoFence);
                            continue;
                        }
                        GeoFence geoFence = new GeoFence();
                        geoFence.setFenceType(22);
                        geoFence.setPoiItem(poiItem);
                        geoFence.setRadius(200.0f);
                        geoFence.setKeyWord(string);
                        geoFence.setActivatesAction(GeoFenceClient.this.a);
                        if (!TextUtils.isEmpty((CharSequence)GeoFenceClient.this.a) && GeoFenceClient.this.a.contains("3")) {
                            geoFence.setStayTime(GeoFenceClient.this.b);
                        }
                        geoFence.setCustomId(string4);
                        geoFence.setFenceId(String.valueOf(GeoFenceClient.this.j++));
                        GeoFenceClient.this.x.put(geoFence.getFenceId(), 2);
                        geoFence.setCenter(new DPoint(poiItem.getLatitude(), poiItem.getLongitude()));
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<Object>();
                        }
                        GeoFenceClient.this.a(geoFence);
                        arrayList2.add(geoFence);
                    }
                    if (arrayList2 == null) {
                        if (GeoFenceClient.this.c != null) {
                            GeoFenceClient.this.c.onGeoFenceCreateFinished(null, 13, string4);
                        }
                        return;
                    }
                    if (!arrayList2.isEmpty() && GeoFenceClient.this.d != null) {
                        GeoFenceClient.this.d.addAll(arrayList2);
                        if (GeoFenceClient.this.c != null) {
                            GeoFenceClient.this.c.onGeoFenceCreateFinished((List<GeoFence>)arrayList2, 7, string4);
                        }
                        GeoFenceClient.this.n = false;
                        GeoFenceClient.this.a();
                    }
                }
            }
        });
    }

    public void addGeoFence(final String string, String string2, String string3, int n2, final String string4) {
        this.s.append("[").append(string).append(",").append(string2).append(",").append(string3).append(",").append(n2).append(",").append(string4).append("]");
        this.a("4", this.b("4") + 1);
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || n2 == 0 || TextUtils.isEmpty((CharSequence)string4)) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 8, string4);
            }
            return;
        }
        if (!com.baidu.location.h.i.a(this.h)) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 9, string4);
            }
            return;
        }
        c c2 = new c(this.h, false, this.c, this.d);
        c2.b(string);
        c2.d(string3);
        c2.c(string2);
        c2.a(n2);
        c2.a(string4);
        c2.a(new c.a(){

            @Override
            public void a(int n2, ArrayList<PoiItem> arrayList) {
                if (n2 != 0) {
                    if (GeoFenceClient.this.c != null) {
                        GeoFenceClient.this.c.onGeoFenceCreateFinished(null, 13, string4);
                    }
                } else {
                    if (arrayList == null) {
                        return;
                    }
                    if (arrayList.size() == 0) {
                        return;
                    }
                    ArrayList<Object> arrayList2 = null;
                    for (PoiItem poiItem : arrayList) {
                        if (GeoFenceClient.this.d != null && GeoFenceClient.this.d.size() != 0) {
                            boolean bl = false;
                            for (GeoFence geoFence : GeoFenceClient.this.d) {
                                if (geoFence.getType() != 22 || poiItem.getLatitude() != geoFence.getPoiItem().getLatitude() || poiItem.getLongitude() != geoFence.getPoiItem().getLongitude()) continue;
                                if (GeoFenceClient.this.c != null) {
                                    GeoFenceClient.this.c.onGeoFenceCreateFinished(null, 14, string4);
                                }
                                bl = true;
                            }
                            if (bl) continue;
                            GeoFence geoFence = new GeoFence();
                            geoFence.setFenceType(22);
                            geoFence.setRadius(1000.0f);
                            geoFence.setKeyWord(string);
                            geoFence.setActivatesAction(GeoFenceClient.this.a);
                            geoFence.setPoiItem(poiItem);
                            geoFence.setCustomId(string4);
                            geoFence.setFenceId(String.valueOf(GeoFenceClient.this.j++));
                            GeoFenceClient.this.x.put(geoFence.getFenceId(), 2);
                            geoFence.setCenter(new DPoint(poiItem.getLatitude(), poiItem.getLongitude()));
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList();
                            }
                            GeoFenceClient.this.a(geoFence);
                            arrayList2.add(geoFence);
                            continue;
                        }
                        GeoFence geoFence = new GeoFence();
                        geoFence.setFenceType(22);
                        geoFence.setRadius(1000.0f);
                        geoFence.setKeyWord(string);
                        geoFence.setActivatesAction(GeoFenceClient.this.a);
                        if (!TextUtils.isEmpty((CharSequence)GeoFenceClient.this.a) && GeoFenceClient.this.a.contains("3")) {
                            geoFence.setStayTime(GeoFenceClient.this.b);
                        }
                        geoFence.setPoiItem(poiItem);
                        geoFence.setCustomId(string4);
                        geoFence.setFenceId(String.valueOf(GeoFenceClient.this.j++));
                        GeoFenceClient.this.x.put(geoFence.getFenceId(), 2);
                        geoFence.setCenter(new DPoint(poiItem.getLatitude(), poiItem.getLongitude()));
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<Object>();
                        }
                        GeoFenceClient.this.a(geoFence);
                        arrayList2.add(geoFence);
                    }
                    if (arrayList2 == null) {
                        if (GeoFenceClient.this.c != null) {
                            GeoFenceClient.this.c.onGeoFenceCreateFinished(null, 13, string4);
                        }
                        return;
                    }
                    if (!arrayList2.isEmpty() && GeoFenceClient.this.d != null) {
                        GeoFenceClient.this.d.addAll(arrayList2);
                        if (GeoFenceClient.this.c != null) {
                            GeoFenceClient.this.c.onGeoFenceCreateFinished((List<GeoFence>)arrayList2, 7, string4);
                        }
                        GeoFenceClient.this.n = false;
                        GeoFenceClient.this.a();
                    }
                }
            }
        });
    }

    public void addGeoFence(final String string, final String string2) {
        this.t.append("[").append(string).append(",").append(string2).append("]");
        this.a("5", this.b("5") + 1);
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 8, string2);
            }
            return;
        }
        for (GeoFence geoFence : this.d) {
            if (geoFence.getType() != 23 || !TextUtils.equals((CharSequence)geoFence.getRegion(), (CharSequence)string)) continue;
            if (this.c != null) {
                this.c.onGeoFenceCreateFinished(null, 14, string2);
            }
            return;
        }
        b b2 = new b(string, this.h);
        b2.a(this.c);
        b2.a(new b.a(){

            @Override
            public void a(int n2) {
                if (n2 != 0) {
                    if (GeoFenceClient.this.c != null) {
                        GeoFenceClient.this.c.onGeoFenceCreateFinished(null, 13, string2);
                    }
                } else {
                    GeoFence geoFence = new GeoFence();
                    geoFence.setFenceType(23);
                    geoFence.setRegion(string);
                    geoFence.setKeyWord(string);
                    geoFence.setCustomId(string2);
                    geoFence.setActivatesAction(GeoFenceClient.this.a);
                    if (!TextUtils.isEmpty((CharSequence)GeoFenceClient.this.a) && GeoFenceClient.this.a.contains("3")) {
                        geoFence.setStayTime(GeoFenceClient.this.b);
                    }
                    geoFence.setFenceId(String.valueOf(GeoFenceClient.this.j++));
                    GeoFenceClient.this.a(geoFence);
                    GeoFenceClient.this.d.add(geoFence);
                    GeoFenceClient.this.x.put(geoFence.getFenceId(), 2);
                    ArrayList<GeoFence> arrayList = new ArrayList<GeoFence>();
                    arrayList.add(geoFence);
                    if (GeoFenceClient.this.c != null) {
                        GeoFenceClient.this.c.onGeoFenceCreateFinished(arrayList, 7, string2);
                    }
                    if (!TextUtils.equals((CharSequence)GeoFenceClient.this.l.getAddrType(), (CharSequence)"all") && GeoFenceClient.this.e != null) {
                        GeoFenceClient.this.l.setIsNeedAddress(true);
                        GeoFenceClient.this.e.setLocOption(GeoFenceClient.this.l);
                    }
                    GeoFenceClient.this.n = false;
                    GeoFenceClient.this.a();
                }
            }
        });
    }

    public void removeGeoFence() {
        if (this.d != null && !this.d.isEmpty()) {
            this.d.clear();
            this.k = false;
            this.j = 1;
            this.x.clear();
            if (this.e != null && this.e.isStarted()) {
                this.e.stop();
            }
        }
    }

    public boolean removeGeoFence(GeoFence geoFence) {
        if (geoFence == null || this.d == null || this.d.isEmpty()) {
            return false;
        }
        for (GeoFence geoFence2 : this.d) {
            if (!TextUtils.equals((CharSequence)geoFence2.getFenceId(), (CharSequence)geoFence.getFenceId())) continue;
            this.d.remove(geoFence);
            return true;
        }
        return false;
    }

    public List<GeoFence> getAllGeoFence() {
        return this.d;
    }

    public void setActivateAction(int n2) {
        if (n2 == 1) {
            this.a = "1";
        } else if (n2 == 2) {
            this.a = "2";
        } else if (n2 == 3) {
            this.a = "3";
        } else if (n2 == 4) {
            this.a = "12";
        } else if (n2 == 5) {
            this.a = "13";
        } else if (n2 == 6) {
            this.a = "23";
        } else if (n2 == 7) {
            this.a = "123";
        }
        if (TextUtils.isEmpty((CharSequence)this.a)) {
            return;
        }
    }

    public void setStayTime(int n2) {
        this.b = n2;
    }

    public void setTriggerCount(int n2, int n3, int n4) {
        if (TextUtils.isEmpty((CharSequence)this.a)) {
            return;
        }
        if (this.a.contains("1")) {
            this.u = n2 < 1 ? 1 : n2;
        }
        if (this.a.contains("2")) {
            this.v = n3 < 1 ? 1 : n3;
        }
        if (this.a.contains("3")) {
            this.w = n4 < 1 ? 1 : n4;
        }
    }

    public void setGeoFenceListener(GeoFenceListener geoFenceListener) {
        this.c = geoFenceListener;
    }

    public void setGeoFenceAble(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string) || this.d == null || this.d.size() == 0) {
            return;
        }
        for (GeoFence geoFence : this.d) {
            if (!TextUtils.equals((CharSequence)geoFence.getFenceId(), (CharSequence)string)) continue;
            geoFence.setAble(bl);
        }
    }

    public void pauseGeoFence() {
        this.n = true;
        this.k = false;
        if (this.e != null && this.e.isStarted()) {
            this.e.stop();
        }
    }

    public void resumeGeoFence() {
        if (this.d == null || this.d.size() == 0 || this.b()) {
            return;
        }
        if (this.isPause()) {
            this.k = true;
            this.n = false;
            this.a();
        }
    }

    public boolean isPause() {
        if (this.e == null) {
            return false;
        }
        return !this.k && !this.e.isStarted();
    }

    public void createPendingIntent(String string) {
        this.f = new Intent(string);
    }

    @Override
    public void onReceiveLocation(BDLocation bDLocation) {
        this.d();
        if (this.k) {
            if (bDLocation.getLocType() == 161 || bDLocation.getLocType() == 66 || bDLocation.getLocType() == 61) {
                for (GeoFence geoFence : this.d) {
                    if (!geoFence.isAble() || TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) continue;
                    if (geoFence.getType() == 20) {
                        this.a(1, bDLocation, geoFence);
                        continue;
                    }
                    if (geoFence.getType() == 22) {
                        this.a(1, bDLocation, geoFence);
                        continue;
                    }
                    if (geoFence.getType() == 21) {
                        this.a(2, bDLocation, geoFence);
                        continue;
                    }
                    if (geoFence.getType() != 23) continue;
                    this.a(3, bDLocation, geoFence);
                }
            } else {
                for (GeoFence geoFence : this.d) {
                    if (geoFence.isSend() && TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) continue;
                    this.a(18, geoFence, bDLocation.getLocType());
                }
            }
        }
        if (this.n) {
            return;
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        for (GeoFence geoFence : this.d) {
            if (!TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) {
                bl = false;
            }
            if (geoFence.getType() == 23 && !TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) {
                bl2 = true;
            }
            if (!geoFence.isOneSecond()) continue;
            bl3 = true;
        }
        if (bl) {
            this.pauseGeoFence();
        } else {
            this.k = true;
            this.n = false;
            if (bl2) {
                if (!TextUtils.equals((CharSequence)this.l.getAddrType(), (CharSequence)"all")) {
                    this.l.setIsNeedAddress(true);
                }
            } else {
                this.l.setIsNeedAddress(false);
            }
            if (bl3) {
                this.l.setScanSpan(1000);
                if (this.m && this.l.getLocationMode() != LocationClientOption.LocationMode.Hight_Accuracy) {
                    this.l.setLocationMode(LocationClientOption.LocationMode.Hight_Accuracy);
                }
            } else {
                this.l.setScanSpan(5000);
                if (this.l.getLocationMode() == LocationClientOption.LocationMode.Hight_Accuracy) {
                    this.l.setLocationMode(LocationClientOption.LocationMode.Battery_Saving);
                }
            }
            if (this.e != null) {
                this.e.setLocOption(this.l);
            }
            this.a();
        }
    }

    private void b(GeoFence geoFence) {
        if (this.l.getScanSpan() != 1000) {
            this.l.setScanSpan(1000);
            if (this.m && this.l.getLocationMode() != LocationClientOption.LocationMode.Hight_Accuracy) {
                this.l.setLocationMode(LocationClientOption.LocationMode.Hight_Accuracy);
            }
            if (this.e != null) {
                this.e.setLocOption(this.l);
            }
            geoFence.setOneSecond(true);
        }
    }

    private void a(GeoFence geoFence, BDLocation bDLocation) {
        if (geoFence.getActivatesAction().contains("3") && !geoFence.isIn()) {
            geoFence.setStartTimeMillis(System.currentTimeMillis());
            geoFence.setIn(true);
        }
        if (!geoFence.isSend()) {
            this.a(24, geoFence, bDLocation.getLocType());
            if (geoFence.getActivatesAction().contains("1")) {
                this.c(geoFence, bDLocation);
            }
            geoFence.setStatus(24);
            geoFence.setSend(true);
            return;
        }
        if (this.x.get(geoFence.getFenceId()) != 0 && geoFence.getActivatesAction().contains("1")) {
            this.c(geoFence, bDLocation);
        }
        if (geoFence.getActivatesAction().contains("3") && geoFence.isIn() && !geoFence.isOut() && this.a(geoFence.getStartTimeMillis(), System.currentTimeMillis()) > (long)geoFence.getStayTime()) {
            this.d(geoFence, bDLocation);
        }
    }

    private void b(GeoFence geoFence, BDLocation bDLocation) {
        geoFence.setCurrentLoc(bDLocation);
        geoFence.setStatus(16);
        boolean bl = this.a(16, geoFence, bDLocation.getLocType());
        if (bl) {
            int n2 = geoFence.getOutTriggerCount();
            geoFence.setOutTriggerCount(--n2);
        }
        if (geoFence.getOutTriggerCount() == 0 && !TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) {
            geoFence.setActivatesAction(geoFence.getActivatesAction().replace("2", ""));
        }
    }

    private void c(GeoFence geoFence, BDLocation bDLocation) {
        geoFence.setCurrentLoc(bDLocation);
        geoFence.setStatus(15);
        boolean bl = this.a(15, geoFence, bDLocation.getLocType());
        if (bl) {
            int n2 = geoFence.getInTriggerCount();
            geoFence.setInTriggerCount(--n2);
        }
        if (geoFence.getInTriggerCount() == 0 && !TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) {
            geoFence.setActivatesAction(geoFence.getActivatesAction().replace("1", ""));
        }
    }

    private void d(GeoFence geoFence, BDLocation bDLocation) {
        geoFence.setCurrentLoc(bDLocation);
        geoFence.setStatus(17);
        boolean bl = this.a(17, geoFence, bDLocation.getLocType());
        if (bl) {
            int n2 = geoFence.getStayTriggerCount();
            geoFence.setStayTriggerCount(--n2);
            this.c(geoFence);
        }
        if (geoFence.getStayTriggerCount() == 0 && !TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) {
            geoFence.setActivatesAction(geoFence.getActivatesAction().replace("3", ""));
        }
    }

    private void e(GeoFence geoFence, BDLocation bDLocation) {
        if (geoFence.isIn() && !geoFence.isOut()) {
            geoFence.setEndTimeMillis(System.currentTimeMillis());
            geoFence.setOut(true);
        }
        if (!geoFence.isSend()) {
            this.a(25, geoFence, bDLocation.getLocType());
            if (geoFence.getActivatesAction().contains("2")) {
                this.b(geoFence, bDLocation);
            }
            geoFence.setStatus(25);
            geoFence.setSend(true);
            return;
        }
        if (this.x.get(geoFence.getFenceId()) != 1 && geoFence.getActivatesAction().contains("2")) {
            this.b(geoFence, bDLocation);
        }
        if (geoFence.getActivatesAction().contains("3") && geoFence.isIn() && this.a(geoFence.getStartTimeMillis(), geoFence.getEndTimeMillis()) > (long)geoFence.getStayTime()) {
            this.d(geoFence, bDLocation);
        }
    }

    private void c(GeoFence geoFence) {
        geoFence.setIn(false);
        geoFence.setOut(false);
        geoFence.setStartTimeMillis(0L);
        geoFence.setEndTimeMillis(0L);
    }

    private void a(int n2, BDLocation bDLocation, GeoFence geoFence) {
        if (geoFence.getActivatesAction().contains("1")) {
            if (n2 == 1) {
                if (com.baidu.location.indoor.j.a(bDLocation.getLatitude(), bDLocation.getLongitude(), geoFence.getCenter().getLatitude(), geoFence.getCenter().getLongitude()) - (double)geoFence.getRadius() < 500.0) {
                    this.b(geoFence);
                }
            } else if (n2 == 2 && com.baidu.geofence.model.a.a(bDLocation, geoFence.getPoints())) {
                this.b(geoFence);
            }
        } else if (geoFence.getActivatesAction().contains("2")) {
            if (n2 == 1) {
                if (com.baidu.location.indoor.j.a(bDLocation.getLatitude(), bDLocation.getLongitude(), geoFence.getCenter().getLatitude(), geoFence.getCenter().getLongitude()) < (double)geoFence.getRadius() && (double)geoFence.getRadius() - com.baidu.location.indoor.j.a(bDLocation.getLatitude(), bDLocation.getLongitude(), geoFence.getCenter().getLatitude(), geoFence.getCenter().getLongitude()) < 100.0) {
                    this.b(geoFence);
                }
            } else if (n2 == 2 && com.baidu.geofence.model.a.a(new DPoint(bDLocation.getLatitude(), bDLocation.getLongitude()), geoFence.getPoints())) {
                this.b(geoFence);
            }
        } else if (geoFence.getActivatesAction().contains("3") && geoFence.isIn() && !geoFence.isOut()) {
            if (geoFence.getStayTime() - 20 >= 0) {
                long l2 = this.a(geoFence.getStartTimeMillis(), System.currentTimeMillis());
                if (l2 >= (long)(geoFence.getStayTime() - 20) && l2 <= (long)geoFence.getStayTime()) {
                    this.b(geoFence);
                }
            } else {
                this.b(geoFence);
            }
        }
        if (n2 == 1) {
            if (com.baidu.location.indoor.j.a(bDLocation.getLatitude(), bDLocation.getLongitude(), geoFence.getCenter().getLatitude(), geoFence.getCenter().getLongitude()) <= (double)geoFence.getRadius()) {
                this.a(geoFence, bDLocation);
                this.x.put(geoFence.getFenceId(), 0);
            } else {
                this.e(geoFence, bDLocation);
                this.x.put(geoFence.getFenceId(), 1);
            }
        } else if (n2 == 2) {
            if (com.baidu.geofence.model.a.a(new DPoint(bDLocation.getLatitude(), bDLocation.getLongitude()), geoFence.getPoints())) {
                this.a(geoFence, bDLocation);
                this.x.put(geoFence.getFenceId(), 0);
            } else {
                this.e(geoFence, bDLocation);
                this.x.put(geoFence.getFenceId(), 1);
            }
        } else if (n2 == 3) {
            if (!TextUtils.isEmpty((CharSequence)bDLocation.getAddrStr())) {
                if (bDLocation.getAddrStr().contains(geoFence.getRegion())) {
                    this.a(geoFence, bDLocation);
                    this.x.put(geoFence.getFenceId(), 0);
                } else {
                    this.e(geoFence, bDLocation);
                    this.x.put(geoFence.getFenceId(), 1);
                }
            } else {
                if (geoFence.isSend() && TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) {
                    return;
                }
                this.a(18, geoFence, bDLocation.getLocType());
            }
        }
        if (TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction()) && geoFence.isOneSecond()) {
            geoFence.setOneSecond(false);
        }
    }

    private boolean a(int n2, GeoFence geoFence, int n3) {
        Bundle bundle = new Bundle();
        bundle.putInt("3", n2);
        bundle.putString("2", geoFence.getCustomId());
        bundle.putParcelable("5", (Parcelable)geoFence);
        bundle.putInt("4", n3);
        bundle.putString("1", geoFence.getFenceId());
        this.f.setExtrasClassLoader(GeoFence.class.getClassLoader());
        this.f.putExtras(bundle);
        this.g = PendingIntent.getBroadcast((Context)this.h, (int)this.i, (Intent)this.f, (int)0xC000000);
        ++this.i;
        try {
            this.g.send();
            return true;
        }
        catch (PendingIntent.CanceledException canceledException) {
            return false;
        }
    }

    private void a() {
        this.k = true;
        if (this.e != null && !this.e.isStarted()) {
            this.e.start();
        }
    }

    private long a(long l2, long l3) {
        return (l3 - l2) / 1000L;
    }

    private boolean b() {
        if (this.d == null || this.d.isEmpty()) {
            return true;
        }
        for (GeoFence geoFence : this.d) {
            if (TextUtils.isEmpty((CharSequence)geoFence.getActivatesAction())) continue;
            return false;
        }
        return true;
    }

    private void a(String string, int n2) {
        SharedPreferences sharedPreferences = this.h.getApplicationContext().getSharedPreferences("geofence", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(string, n2);
        editor.apply();
    }

    private int b(String string) {
        SharedPreferences sharedPreferences = this.h.getApplicationContext().getSharedPreferences("geofence", 0);
        return sharedPreferences.getInt(string, 0);
    }

    @Override
    public void clear() {
        this.c();
    }

    private void c() {
        SharedPreferences sharedPreferences = this.h.getApplicationContext().getSharedPreferences("geofence", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt("1", 0);
        editor.putInt("2", 0);
        editor.putInt("3", 0);
        editor.putInt("4", 0);
        editor.putInt("5", 0);
        editor.apply();
    }

    private void d() {
        if (this.b("1") == 0 && this.b("2") == 0 && this.b("3") == 0 && this.b("4") == 0 && this.b("5") == 0) {
            return;
        }
        if (this.a(this.o, System.currentTimeMillis()) > 60L) {
            ArrayList<StringBuilder> arrayList = new ArrayList<StringBuilder>();
            arrayList.add(this.p);
            arrayList.add(this.q);
            arrayList.add(this.r);
            arrayList.add(this.s);
            arrayList.add(this.t);
            d d2 = new d();
            d2.a(arrayList);
            d2.a(this);
            String[] stringArray = new String[]{"circleFence:" + this.b("1"), "polygonFence:" + this.b("2"), "poiCircleFence:" + this.b("3"), "poiRegionFence:" + this.b("4"), "regionFence:" + this.b("5")};
            d2.a(stringArray);
            this.o = System.currentTimeMillis();
        }
    }
}

