/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location;

import android.text.TextUtils;

public final class LocationClientOption {
    public static final int MIN_SCAN_SPAN = 1000;
    public static final int GPS_FIRST = 1;
    public String coorType = "gcj02";
    public String addrType = "noaddr";
    public boolean openGps = false;
    public int scanSpan = 0;
    public int timeOut = 12000;
    public String prodName = "SDK6.0";
    public int priority = 1;
    public boolean location_change_notify = false;
    public boolean disableLocCache = true;
    public boolean enableSimulateGps = false;
    public String serviceName = "com.baidu.location.service_v2.9";
    public boolean isIgnoreCacheException = true;
    public boolean isIgnoreKillProcess = true;
    public boolean mIsNeedDeviceDirect = false;
    public boolean isNeedAptag = false;
    public boolean isNeedAptagd = false;
    public boolean isNeedPoiRegion = false;
    public boolean isNeedRegular = false;
    public boolean isNeedAltitude = false;
    public boolean isNeedNewVersionRgc = true;
    public boolean isOnceLocation = false;
    protected LocationMode a;
    public static final int LOC_SENSITIVITY_HIGHT = 1;
    public static final int LOC_SENSITIVITY_MIDDLE = 2;
    public static final int LOC_SENSITIVITY_LOW = 3;
    public static final int MIN_AUTO_NOTIFY_INTERVAL = 10000;
    public static final int GPS_ONLY = 2;
    public static final int NETWORK_FIRST = 3;
    public static final int FUZZY_MODE = 4;
    public int autoNotifyMaxInterval = 0;
    public float autoNotifyLocSensitivity = 0.5f;
    public int autoNotifyMinTimeInterval = 0;
    public int autoNotifyMinDistance = 0;
    public int wifiCacheTimeOut = Integer.MAX_VALUE;
    public int locLegalStatus = 1;
    public boolean isEnableBeidouMode = false;
    public FirstLocType firstLocType = FirstLocType.SPEED_IN_FIRST_LOC;
    public String mProxyHost = null;
    public int mProxyPort = -1;
    public String mUsername = null;
    public String mPassword = null;

    public LocationClientOption() {
    }

    public LocationClientOption(LocationClientOption locationClientOption) {
        this.coorType = locationClientOption.coorType;
        this.addrType = locationClientOption.addrType;
        this.openGps = locationClientOption.openGps;
        this.scanSpan = locationClientOption.scanSpan;
        this.timeOut = locationClientOption.timeOut;
        this.prodName = locationClientOption.prodName;
        this.priority = locationClientOption.priority;
        this.location_change_notify = locationClientOption.location_change_notify;
        this.serviceName = locationClientOption.serviceName;
        this.disableLocCache = locationClientOption.disableLocCache;
        this.isIgnoreCacheException = locationClientOption.isIgnoreCacheException;
        this.isIgnoreKillProcess = locationClientOption.isIgnoreKillProcess;
        this.enableSimulateGps = locationClientOption.enableSimulateGps;
        this.a = locationClientOption.a;
        this.isNeedAptag = locationClientOption.isNeedAptag;
        this.isNeedAptagd = locationClientOption.isNeedAptagd;
        this.isNeedPoiRegion = locationClientOption.isNeedPoiRegion;
        this.isNeedRegular = locationClientOption.isNeedRegular;
        this.mIsNeedDeviceDirect = locationClientOption.mIsNeedDeviceDirect;
        this.isNeedAltitude = locationClientOption.isNeedAltitude;
        this.autoNotifyMaxInterval = locationClientOption.autoNotifyMaxInterval;
        this.autoNotifyLocSensitivity = locationClientOption.autoNotifyLocSensitivity;
        this.autoNotifyMinTimeInterval = locationClientOption.autoNotifyMinTimeInterval;
        this.autoNotifyMinDistance = locationClientOption.autoNotifyMinDistance;
        this.wifiCacheTimeOut = locationClientOption.wifiCacheTimeOut;
        this.isNeedNewVersionRgc = locationClientOption.isNeedNewVersionRgc;
        this.isOnceLocation = locationClientOption.isOnceLocation;
        this.locLegalStatus = locationClientOption.locLegalStatus;
        this.isEnableBeidouMode = locationClientOption.isEnableBeidouMode;
        this.firstLocType = locationClientOption.firstLocType;
        this.mProxyHost = locationClientOption.mProxyHost;
        this.mProxyPort = locationClientOption.mProxyPort;
        this.mUsername = locationClientOption.mUsername;
        this.mPassword = locationClientOption.mPassword;
    }

    public boolean optionEquals(LocationClientOption locationClientOption) {
        return this.coorType.equals(locationClientOption.coorType) && this.addrType.equals(locationClientOption.addrType) && this.openGps == locationClientOption.openGps && this.scanSpan == locationClientOption.scanSpan && this.timeOut == locationClientOption.timeOut && this.prodName.equals(locationClientOption.prodName) && this.location_change_notify == locationClientOption.location_change_notify && this.priority == locationClientOption.priority && this.disableLocCache == locationClientOption.disableLocCache && this.isIgnoreCacheException == locationClientOption.isIgnoreCacheException && this.isNeedNewVersionRgc == locationClientOption.isNeedNewVersionRgc && this.isIgnoreKillProcess == locationClientOption.isIgnoreKillProcess && this.isNeedAptag == locationClientOption.isNeedAptag && this.isNeedAptagd == locationClientOption.isNeedAptagd && this.isNeedPoiRegion == locationClientOption.isNeedPoiRegion && this.isNeedRegular == locationClientOption.isNeedRegular && this.mIsNeedDeviceDirect == locationClientOption.mIsNeedDeviceDirect && this.autoNotifyMaxInterval == locationClientOption.autoNotifyMaxInterval && this.autoNotifyLocSensitivity == locationClientOption.autoNotifyLocSensitivity && this.autoNotifyMinTimeInterval == locationClientOption.autoNotifyMinTimeInterval && this.autoNotifyMinDistance == locationClientOption.autoNotifyMinDistance && this.wifiCacheTimeOut == locationClientOption.wifiCacheTimeOut && this.isOnceLocation == locationClientOption.isOnceLocation && this.locLegalStatus == locationClientOption.locLegalStatus && this.isEnableBeidouMode == locationClientOption.isEnableBeidouMode && this.isNeedAltitude == locationClientOption.isNeedAltitude && this.a == locationClientOption.a && this.enableSimulateGps == locationClientOption.enableSimulateGps && this.firstLocType == locationClientOption.firstLocType;
    }

    public String getCoorType() {
        return this.coorType;
    }

    public void setCoorType(String string) {
        if ((string = string.toLowerCase()).equals("gcj02") || string.equals("bd09") || string.equals("bd09ll")) {
            this.coorType = string;
        }
    }

    public String getAddrType() {
        return this.addrType;
    }

    @Deprecated
    public void setAddrType(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if ("all".equals(string)) {
            this.setIsNeedAddress(true);
        } else {
            this.setIsNeedAddress(false);
        }
    }

    public void setIsNeedAddress(boolean bl) {
        this.addrType = bl ? "all" : "noaddr";
    }

    public void setIsEnableBeidouMode(boolean bl) {
        this.isEnableBeidouMode = bl;
    }

    public void setLocStatus(boolean bl) {
        boolean bl2 = true;
        int n2 = 1;
        n2 = bl2 && bl ? 1 : (bl2 && !bl ? -2 : (!bl2 && bl ? -1 : 0));
        this.locLegalStatus = n2;
    }

    public void setWifiCacheTimeOut(int n2) {
        if (n2 >= 10000) {
            this.wifiCacheTimeOut = n2;
        }
    }

    @Deprecated
    public boolean isOpenGps() {
        return this.openGps;
    }

    public boolean isOpenGnss() {
        return this.openGps;
    }

    @Deprecated
    public void setOpenGps(boolean bl) {
        this.openGps = bl;
    }

    public void setOpenGnss(boolean bl) {
        this.openGps = bl;
    }

    public void setLocationPurpose(BDLocationPurpose bDLocationPurpose) {
        if (bDLocationPurpose != null) {
            if (bDLocationPurpose == BDLocationPurpose.SignIn) {
                this.setLocationMode(LocationMode.Hight_Accuracy);
                this.setLocationNotify(false);
                this.setScanSpan(0);
                this.setNeedNewVersionRgc(true);
                this.setIsNeedAddress(true);
                this.setIsNeedLocationPoiList(true);
                this.setIsNeedAltitude(true);
                this.setIsNeedLocationDescribe(true);
                this.setWifiCacheTimeOut(10000);
            } else if (bDLocationPurpose == BDLocationPurpose.Sport) {
                this.setLocationMode(LocationMode.Hight_Accuracy);
                this.setLocationNotify(true);
                this.setScanSpan(3000);
                this.setNeedNewVersionRgc(true);
                this.setIsNeedAddress(true);
                this.setIsNeedLocationPoiList(false);
                this.setIsNeedAltitude(true);
                this.setIsNeedLocationDescribe(false);
                this.setWifiCacheTimeOut(1000);
            } else if (bDLocationPurpose == BDLocationPurpose.Transport) {
                this.setLocationMode(LocationMode.Hight_Accuracy);
                this.setLocationNotify(true);
                this.setScanSpan(1000);
                this.setNeedNewVersionRgc(true);
                this.setIsNeedAddress(true);
                this.setIsNeedLocationPoiList(false);
                this.setIsNeedAltitude(true);
                this.setIsNeedLocationDescribe(false);
                this.setWifiCacheTimeOut(1000);
            }
        }
    }

    public boolean isLocationNotify() {
        return this.location_change_notify;
    }

    public void setLocationNotify(boolean bl) {
        this.location_change_notify = bl;
    }

    public boolean isOnceLocation() {
        return this.isOnceLocation;
    }

    public void setOnceLocation(boolean bl) {
        this.isOnceLocation = bl;
    }

    public void setOpenAutoNotifyMode() {
        this.setOpenAutoNotifyMode(0, 0, 1);
    }

    public void setOpenAutoNotifyMode(int n2, int n3, int n4) {
        int n5 = 180000;
        if (n2 > n5) {
            n5 = n2 + 1000;
        }
        if (n5 < 10000) {
            throw new IllegalArgumentException("Illegal this maxLocInterval : " + n5 + " , maxLocInterval must >= " + 10000);
        }
        switch (n4) {
            case 1: {
                this.autoNotifyLocSensitivity = 0.5f;
                break;
            }
            case 2: {
                this.autoNotifyLocSensitivity = 0.3f;
                break;
            }
            case 3: {
                this.autoNotifyLocSensitivity = 0.1f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal this locSensitivity : " + n4);
            }
        }
        this.autoNotifyMaxInterval = n5;
        this.autoNotifyMinTimeInterval = n2;
        this.autoNotifyMinDistance = n3;
    }

    int a() {
        return this.autoNotifyMaxInterval;
    }

    public int getAutoNotifyMinTimeInterval() {
        return this.autoNotifyMinTimeInterval;
    }

    public int getAutoNotifyMinDistance() {
        return this.autoNotifyMinDistance;
    }

    float b() {
        return this.autoNotifyLocSensitivity;
    }

    public int getScanSpan() {
        return this.scanSpan;
    }

    public void setScanSpan(int n2) {
        if (n2 >= 0) {
            this.scanSpan = n2;
        }
    }

    @Deprecated
    public int getTimeOut() {
        return this.timeOut;
    }

    @Deprecated
    public void setTimeOut(int n2) {
        this.timeOut = n2;
    }

    public String getProdName() {
        return this.prodName;
    }

    public void setProdName(String string) {
        if (string.length() > 64) {
            string = string.substring(0, 64);
        }
        this.prodName = string;
    }

    public int getPriority() {
        return this.priority;
    }

    @Deprecated
    public void setPriority(int n2) {
        if (n2 == 1 || n2 == 3) {
            this.priority = n2;
        }
    }

    public void setLocationMode(LocationMode locationMode) {
        switch (locationMode) {
            case Hight_Accuracy: {
                this.openGps = true;
                this.priority = 1;
                break;
            }
            case Battery_Saving: {
                this.openGps = false;
                this.priority = 3;
                break;
            }
            case Device_Sensors: {
                this.priority = 2;
                this.openGps = true;
                break;
            }
            case Fuzzy_Locating: {
                this.priority = 4;
                this.openGps = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal this mode : " + (Object)((Object)locationMode));
            }
        }
        this.a = locationMode;
    }

    public LocationMode getLocationMode() {
        return this.a;
    }

    public void setNeedDeviceDirect(boolean bl) {
        this.mIsNeedDeviceDirect = bl;
    }

    public void setNeedNewVersionRgc(boolean bl) {
        this.isNeedNewVersionRgc = bl;
    }

    @Deprecated
    public String getServiceName() {
        return this.serviceName;
    }

    @Deprecated
    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setIsNeedLocationDescribe(boolean bl) {
        this.isNeedAptag = bl;
    }

    public void setIsNeedAltitude(boolean bl) {
        this.isNeedAltitude = bl;
    }

    public void setIsNeedLocationPoiList(boolean bl) {
        this.isNeedAptagd = bl;
    }

    @Deprecated
    public void setSema(boolean bl, boolean bl2, boolean bl3) {
        this.isNeedAptag = bl;
        this.isNeedPoiRegion = bl2;
        this.isNeedRegular = bl3;
    }

    @Deprecated
    public void disableCache(boolean bl) {
        this.disableLocCache = bl;
    }

    @Deprecated
    public boolean isDisableCache() {
        return this.disableLocCache;
    }

    public void SetIgnoreCacheException(boolean bl) {
        this.isIgnoreCacheException = bl;
    }

    public void setIgnoreKillProcess(boolean bl) {
        this.isIgnoreKillProcess = bl;
    }

    @Deprecated
    public void setEnableSimulateGps(boolean bl) {
        this.enableSimulateGps = bl;
    }

    public void setEnableSimulateGnss(boolean bl) {
        this.enableSimulateGps = bl;
    }

    public void setFirstLocType(FirstLocType firstLocType) {
        this.firstLocType = firstLocType;
    }

    public void setProxy(String string, int n2) {
        this.mProxyHost = string;
        this.mProxyPort = n2;
    }

    public void setHttpProxyUsernameAndPassword(String string, String string2) {
        this.mUsername = string;
        this.mPassword = string2;
    }

    public static enum BDLocationPurpose {
        SignIn,
        Sport,
        Transport;

    }

    public static enum FirstLocType {
        SPEED_IN_FIRST_LOC,
        ACCURACY_IN_FIRST_LOC;

    }

    public static enum LocationMode {
        Hight_Accuracy,
        Battery_Saving,
        Device_Sensors,
        Fuzzy_Locating;

    }
}

