/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.session.Configuration;

public class TableInfo
implements Constants {
    private Class<?> entityType;
    private IdType idType = IdType.NONE;
    private String tableName;
    private String resultMap;
    private boolean autoInitResultMap;
    private boolean keyRelated;
    private String keyColumn;
    private String keyProperty;
    private Class<?> keyType;
    private KeySequence keySequence;
    private List<TableFieldInfo> fieldList;
    private String currentNamespace;
    @Deprecated
    private Configuration configuration;
    private boolean underCamel;
    private String allSqlSelect;
    private String sqlSelect;
    private boolean withInsertFill;
    private boolean withUpdateFill;
    private boolean withLogicDelete;
    private TableFieldInfo logicDeleteFieldInfo;
    private boolean withVersion;
    private TableFieldInfo versionFieldInfo;
    private List<TableFieldInfo> orderByFields;
    private Reflector reflector;

    public TableInfo(Configuration configuration, Class<?> entityType) {
        this.configuration = configuration;
        this.entityType = entityType;
        this.reflector = configuration.getReflectorFactory().findForClass(entityType);
        this.underCamel = configuration.isMapUnderscoreToCamelCase();
    }

    @Deprecated
    public String getSqlStatement(String sqlMethod) {
        return this.currentNamespace + "." + sqlMethod;
    }

    public boolean havePK() {
        return StringUtils.isNotBlank(this.keyColumn);
    }

    public String getKeySqlSelect() {
        if (this.sqlSelect != null) {
            return this.sqlSelect;
        }
        if (this.havePK()) {
            this.sqlSelect = this.keyColumn;
            if (this.resultMap == null && this.keyRelated) {
                this.sqlSelect = this.sqlSelect + " AS " + this.keyProperty;
            }
        } else {
            this.sqlSelect = "";
        }
        return this.sqlSelect;
    }

    public String getAllSqlSelect() {
        if (this.allSqlSelect != null) {
            return this.allSqlSelect;
        }
        this.allSqlSelect = this.chooseSelect(TableFieldInfo::isSelect);
        return this.allSqlSelect;
    }

    public String chooseSelect(Predicate<TableFieldInfo> predicate) {
        String sqlSelect = this.getKeySqlSelect();
        String fieldsSqlSelect = this.fieldList.stream().filter(predicate).map(TableFieldInfo::getSqlSelect).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank(sqlSelect) && StringUtils.isNotBlank(fieldsSqlSelect)) {
            return sqlSelect + "," + fieldsSqlSelect;
        }
        if (StringUtils.isNotBlank(fieldsSqlSelect)) {
            return fieldsSqlSelect;
        }
        return sqlSelect;
    }

    public String getKeyInsertSqlProperty(boolean batch, String prefix, boolean newLine) {
        String newPrefix;
        String string = newPrefix = prefix == null ? "" : prefix;
        if (this.havePK()) {
            String prefixKeyProperty = newPrefix + this.keyProperty;
            String keyColumn = SqlScriptUtils.safeParam(prefixKeyProperty) + ",";
            if (this.idType == IdType.AUTO) {
                if (batch) {
                    return "";
                }
                return SqlScriptUtils.convertIf(keyColumn, String.format("%s != null", prefixKeyProperty), newLine);
            }
            return keyColumn + (newLine ? "\n" : "");
        }
        return "";
    }

    public String getKeyInsertSqlColumn(boolean batch, String prefix, boolean newLine) {
        if (this.havePK()) {
            String newPrefix = prefix == null ? "" : prefix;
            String prefixKeyProperty = newPrefix + this.keyProperty;
            if (this.idType == IdType.AUTO) {
                if (batch) {
                    return "";
                }
                return SqlScriptUtils.convertIf(this.keyColumn + ",", String.format("%s != null", prefixKeyProperty), newLine);
            }
            return this.keyColumn + "," + (newLine ? "\n" : "");
        }
        return "";
    }

    public String getAllInsertSqlPropertyMaybeIf(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return this.getKeyInsertSqlProperty(false, newPrefix, true) + this.fieldList.stream().map(i -> i.getInsertSqlPropertyMaybeIf(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getAllInsertSqlColumnMaybeIf(String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return this.getKeyInsertSqlColumn(false, newPrefix, true) + this.fieldList.stream().map(i -> i.getInsertSqlColumnMaybeIf(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getAllSqlWhere(boolean fistAnd, boolean ignoreLogicDelFiled, boolean withId, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String filedSqlScript = this.fieldList.stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.isWithLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(i -> i.getSqlWhere(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        if (!withId || StringUtils.isBlank(this.keyProperty)) {
            return filedSqlScript;
        }
        String newKeyProperty = newPrefix + this.keyProperty;
        String keySqlScript = this.keyColumn + "=" + SqlScriptUtils.safeParam(newKeyProperty);
        return SqlScriptUtils.convertIf(fistAnd ? " AND " + keySqlScript : keySqlScript, String.format("%s != null", newKeyProperty), false) + "\n" + filedSqlScript;
    }

    public String getAllSqlSet(boolean ignoreLogicDelFiled, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        return this.fieldList.stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.isWithLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(i -> i.getSqlSet(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
    }

    public String getLogicDeleteSql(boolean startWithAnd, boolean isWhere) {
        if (this.withLogicDelete) {
            String logicDeleteSql = this.formatLogicDeleteSql(isWhere);
            if (startWithAnd) {
                logicDeleteSql = " AND " + logicDeleteSql;
            }
            return logicDeleteSql;
        }
        return "";
    }

    protected String formatLogicDeleteSql(boolean isWhere) {
        String value;
        String string = value = isWhere ? this.logicDeleteFieldInfo.getLogicNotDeleteValue() : this.logicDeleteFieldInfo.getLogicDeleteValue();
        if (isWhere) {
            if ("null".equalsIgnoreCase(value)) {
                return this.logicDeleteFieldInfo.getColumn() + " IS NULL";
            }
            return this.logicDeleteFieldInfo.getColumn() + "=" + String.format(this.logicDeleteFieldInfo.isCharSequence() ? "'%s'" : "%s", value);
        }
        String targetStr = this.logicDeleteFieldInfo.getColumn() + "=";
        if ("null".equalsIgnoreCase(value)) {
            return targetStr + "null";
        }
        return targetStr + String.format(this.logicDeleteFieldInfo.isCharSequence() ? "'%s'" : "%s", value);
    }

    void initResultMapIfNeed() {
        if (this.autoInitResultMap && null == this.resultMap) {
            String id = this.currentNamespace + "." + "mybatis-plus" + "_" + this.entityType.getSimpleName();
            ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
            if (this.havePK()) {
                ResultMapping idMapping = new ResultMapping.Builder(this.configuration, this.keyProperty, StringUtils.getTargetColumn(this.keyColumn), this.keyType).flags(Collections.singletonList(ResultFlag.ID)).build();
                resultMappings.add(idMapping);
            }
            if (CollectionUtils.isNotEmpty(this.fieldList)) {
                this.fieldList.forEach(i -> resultMappings.add(i.getResultMapping(this.configuration)));
            }
            ResultMap resultMap = new ResultMap.Builder(this.configuration, id, this.entityType, resultMappings).build();
            this.configuration.addResultMap(resultMap);
            this.resultMap = id;
        }
    }

    void setFieldList(List<TableFieldInfo> fieldList) {
        this.fieldList = fieldList;
        AtomicInteger logicDeleted = new AtomicInteger();
        AtomicInteger version = new AtomicInteger();
        fieldList.forEach(i -> {
            if (i.isLogicDelete()) {
                this.withLogicDelete = true;
                this.logicDeleteFieldInfo = i;
                logicDeleted.getAndAdd(1);
            }
            if (i.isWithInsertFill()) {
                this.withInsertFill = true;
            }
            if (i.isWithUpdateFill()) {
                this.withUpdateFill = true;
            }
            if (i.isOrderBy()) {
                this.getOrderByFields().add((TableFieldInfo)i);
            }
            if (i.isVersion()) {
                this.withVersion = true;
                this.versionFieldInfo = i;
                version.getAndAdd(1);
            }
        });
        Assert.isTrue(logicDeleted.get() <= 1, "@TableLogic not support more than one in Class: \"%s\"", this.entityType.getName());
        Assert.isTrue(version.get() <= 1, "@Version not support more than one in Class: \"%s\"", this.entityType.getName());
    }

    public List<TableFieldInfo> getFieldList() {
        return Collections.unmodifiableList(this.fieldList);
    }

    public List<TableFieldInfo> getOrderByFields() {
        if (null == this.orderByFields) {
            this.orderByFields = new LinkedList<TableFieldInfo>();
        }
        return this.orderByFields;
    }

    @Deprecated
    public boolean isLogicDelete() {
        return this.withLogicDelete;
    }

    public Object getPropertyValue(Object entity, String property) {
        try {
            return this.reflector.getGetInvoker(property).invoke(entity, null);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.mpe("Error: Cannot read property in %s.  Cause:", e, entity.getClass().getSimpleName());
        }
    }

    public void setPropertyValue(Object entity, String property, Object ... values) {
        try {
            this.reflector.getSetInvoker(property).invoke(entity, values);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.mpe("Error: Cannot write property in %s.  Cause:", e, entity.getClass().getSimpleName());
        }
    }

    public <T> T newInstance() {
        Constructor defaultConstructor = this.reflector.getDefaultConstructor();
        if (!defaultConstructor.isAccessible()) {
            defaultConstructor.setAccessible(true);
        }
        try {
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.mpe(e);
        }
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getResultMap() {
        return this.resultMap;
    }

    public boolean isAutoInitResultMap() {
        return this.autoInitResultMap;
    }

    public boolean isKeyRelated() {
        return this.keyRelated;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getKeyProperty() {
        return this.keyProperty;
    }

    public Class<?> getKeyType() {
        return this.keyType;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    public String getCurrentNamespace() {
        return this.currentNamespace;
    }

    public boolean isUnderCamel() {
        return this.underCamel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableInfo)) {
            return false;
        }
        TableInfo other = (TableInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoInitResultMap() != other.isAutoInitResultMap()) {
            return false;
        }
        if (this.isKeyRelated() != other.isKeyRelated()) {
            return false;
        }
        if (this.isUnderCamel() != other.isUnderCamel()) {
            return false;
        }
        if (this.isWithInsertFill() != other.isWithInsertFill()) {
            return false;
        }
        if (this.isWithUpdateFill() != other.isWithUpdateFill()) {
            return false;
        }
        if (this.isWithLogicDelete() != other.isWithLogicDelete()) {
            return false;
        }
        if (this.isWithVersion() != other.isWithVersion()) {
            return false;
        }
        Class<?> this$entityType = this.getEntityType();
        Class<?> other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        IdType this$idType = this.getIdType();
        IdType other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$resultMap = this.getResultMap();
        String other$resultMap = other.getResultMap();
        if (this$resultMap == null ? other$resultMap != null : !this$resultMap.equals(other$resultMap)) {
            return false;
        }
        String this$keyColumn = this.getKeyColumn();
        String other$keyColumn = other.getKeyColumn();
        if (this$keyColumn == null ? other$keyColumn != null : !this$keyColumn.equals(other$keyColumn)) {
            return false;
        }
        String this$keyProperty = this.getKeyProperty();
        String other$keyProperty = other.getKeyProperty();
        if (this$keyProperty == null ? other$keyProperty != null : !this$keyProperty.equals(other$keyProperty)) {
            return false;
        }
        Class<?> this$keyType = this.getKeyType();
        Class<?> other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
            return false;
        }
        KeySequence this$keySequence = this.getKeySequence();
        KeySequence other$keySequence = other.getKeySequence();
        if (this$keySequence == null ? other$keySequence != null : !this$keySequence.equals(other$keySequence)) {
            return false;
        }
        List<TableFieldInfo> this$fieldList = this.getFieldList();
        List<TableFieldInfo> other$fieldList = other.getFieldList();
        if (this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList)) {
            return false;
        }
        String this$currentNamespace = this.getCurrentNamespace();
        String other$currentNamespace = other.getCurrentNamespace();
        if (this$currentNamespace == null ? other$currentNamespace != null : !this$currentNamespace.equals(other$currentNamespace)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$allSqlSelect = this.getAllSqlSelect();
        String other$allSqlSelect = other.getAllSqlSelect();
        if (this$allSqlSelect == null ? other$allSqlSelect != null : !this$allSqlSelect.equals(other$allSqlSelect)) {
            return false;
        }
        String this$sqlSelect = this.sqlSelect;
        String other$sqlSelect = other.sqlSelect;
        if (this$sqlSelect == null ? other$sqlSelect != null : !this$sqlSelect.equals(other$sqlSelect)) {
            return false;
        }
        TableFieldInfo this$logicDeleteFieldInfo = this.getLogicDeleteFieldInfo();
        TableFieldInfo other$logicDeleteFieldInfo = other.getLogicDeleteFieldInfo();
        if (this$logicDeleteFieldInfo == null ? other$logicDeleteFieldInfo != null : !((Object)this$logicDeleteFieldInfo).equals(other$logicDeleteFieldInfo)) {
            return false;
        }
        TableFieldInfo this$versionFieldInfo = this.getVersionFieldInfo();
        TableFieldInfo other$versionFieldInfo = other.getVersionFieldInfo();
        if (this$versionFieldInfo == null ? other$versionFieldInfo != null : !((Object)this$versionFieldInfo).equals(other$versionFieldInfo)) {
            return false;
        }
        List<TableFieldInfo> this$orderByFields = this.getOrderByFields();
        List<TableFieldInfo> other$orderByFields = other.getOrderByFields();
        if (this$orderByFields == null ? other$orderByFields != null : !((Object)this$orderByFields).equals(other$orderByFields)) {
            return false;
        }
        Reflector this$reflector = this.getReflector();
        Reflector other$reflector = other.getReflector();
        return !(this$reflector == null ? other$reflector != null : !this$reflector.equals(other$reflector));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoInitResultMap() ? 79 : 97);
        result = result * 59 + (this.isKeyRelated() ? 79 : 97);
        result = result * 59 + (this.isUnderCamel() ? 79 : 97);
        result = result * 59 + (this.isWithInsertFill() ? 79 : 97);
        result = result * 59 + (this.isWithUpdateFill() ? 79 : 97);
        result = result * 59 + (this.isWithLogicDelete() ? 79 : 97);
        result = result * 59 + (this.isWithVersion() ? 79 : 97);
        Class<?> $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        IdType $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $resultMap = this.getResultMap();
        result = result * 59 + ($resultMap == null ? 43 : $resultMap.hashCode());
        String $keyColumn = this.getKeyColumn();
        result = result * 59 + ($keyColumn == null ? 43 : $keyColumn.hashCode());
        String $keyProperty = this.getKeyProperty();
        result = result * 59 + ($keyProperty == null ? 43 : $keyProperty.hashCode());
        Class<?> $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        KeySequence $keySequence = this.getKeySequence();
        result = result * 59 + ($keySequence == null ? 43 : $keySequence.hashCode());
        List<TableFieldInfo> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        String $currentNamespace = this.getCurrentNamespace();
        result = result * 59 + ($currentNamespace == null ? 43 : $currentNamespace.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $allSqlSelect = this.getAllSqlSelect();
        result = result * 59 + ($allSqlSelect == null ? 43 : $allSqlSelect.hashCode());
        String $sqlSelect = this.sqlSelect;
        result = result * 59 + ($sqlSelect == null ? 43 : $sqlSelect.hashCode());
        TableFieldInfo $logicDeleteFieldInfo = this.getLogicDeleteFieldInfo();
        result = result * 59 + ($logicDeleteFieldInfo == null ? 43 : ((Object)$logicDeleteFieldInfo).hashCode());
        TableFieldInfo $versionFieldInfo = this.getVersionFieldInfo();
        result = result * 59 + ($versionFieldInfo == null ? 43 : ((Object)$versionFieldInfo).hashCode());
        List<TableFieldInfo> $orderByFields = this.getOrderByFields();
        result = result * 59 + ($orderByFields == null ? 43 : ((Object)$orderByFields).hashCode());
        Reflector $reflector = this.getReflector();
        result = result * 59 + ($reflector == null ? 43 : $reflector.hashCode());
        return result;
    }

    public String toString() {
        return "TableInfo(entityType=" + this.getEntityType() + ", idType=" + this.getIdType() + ", tableName=" + this.getTableName() + ", resultMap=" + this.getResultMap() + ", autoInitResultMap=" + this.isAutoInitResultMap() + ", keyRelated=" + this.isKeyRelated() + ", keyColumn=" + this.getKeyColumn() + ", keyProperty=" + this.getKeyProperty() + ", keyType=" + this.getKeyType() + ", keySequence=" + this.getKeySequence() + ", fieldList=" + this.getFieldList() + ", currentNamespace=" + this.getCurrentNamespace() + ", configuration=" + this.getConfiguration() + ", underCamel=" + this.isUnderCamel() + ", allSqlSelect=" + this.getAllSqlSelect() + ", sqlSelect=" + this.sqlSelect + ", withInsertFill=" + this.isWithInsertFill() + ", withUpdateFill=" + this.isWithUpdateFill() + ", withLogicDelete=" + this.isWithLogicDelete() + ", logicDeleteFieldInfo=" + this.getLogicDeleteFieldInfo() + ", withVersion=" + this.isWithVersion() + ", versionFieldInfo=" + this.getVersionFieldInfo() + ", orderByFields=" + this.getOrderByFields() + ", reflector=" + this.getReflector() + ")";
    }

    TableInfo setEntityType(Class<?> entityType) {
        this.entityType = entityType;
        return this;
    }

    TableInfo setIdType(IdType idType) {
        this.idType = idType;
        return this;
    }

    TableInfo setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    TableInfo setResultMap(String resultMap) {
        this.resultMap = resultMap;
        return this;
    }

    TableInfo setAutoInitResultMap(boolean autoInitResultMap) {
        this.autoInitResultMap = autoInitResultMap;
        return this;
    }

    TableInfo setKeyRelated(boolean keyRelated) {
        this.keyRelated = keyRelated;
        return this;
    }

    TableInfo setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
        return this;
    }

    TableInfo setKeyProperty(String keyProperty) {
        this.keyProperty = keyProperty;
        return this;
    }

    TableInfo setKeyType(Class<?> keyType) {
        this.keyType = keyType;
        return this;
    }

    TableInfo setKeySequence(KeySequence keySequence) {
        this.keySequence = keySequence;
        return this;
    }

    TableInfo setCurrentNamespace(String currentNamespace) {
        this.currentNamespace = currentNamespace;
        return this;
    }

    TableInfo setUnderCamel(boolean underCamel) {
        this.underCamel = underCamel;
        return this;
    }

    TableInfo setReflector(Reflector reflector) {
        this.reflector = reflector;
        return this;
    }

    @Deprecated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isWithInsertFill() {
        return this.withInsertFill;
    }

    public boolean isWithUpdateFill() {
        return this.withUpdateFill;
    }

    public boolean isWithLogicDelete() {
        return this.withLogicDelete;
    }

    public TableFieldInfo getLogicDeleteFieldInfo() {
        return this.logicDeleteFieldInfo;
    }

    public boolean isWithVersion() {
        return this.withVersion;
    }

    public TableFieldInfo getVersionFieldInfo() {
        return this.versionFieldInfo;
    }

    public TableInfo setOrderByFields(List<TableFieldInfo> orderByFields) {
        this.orderByFields = orderByFields;
        return this;
    }

    public Reflector getReflector() {
        return this.reflector;
    }
}

