/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.index;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.builder.Entity;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.index.AbstractMapperMethodHandler;
import com.baomidou.mybatisplus.generator.jdbc.DatabaseMetaDataWrapper;
import com.baomidou.mybatisplus.generator.model.MapperMethod;
import com.baomidou.mybatisplus.generator.util.KotlinTypeUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultGenerateMapperMethodHandler
extends AbstractMapperMethodHandler {
    private final boolean singleIndex;

    public DefaultGenerateMapperMethodHandler() {
        this(true);
    }

    public DefaultGenerateMapperMethodHandler(boolean singleIndex) {
        this.singleIndex = singleIndex;
    }

    @Override
    public List<MapperMethod> getMethodList(TableInfo tableInfo) {
        Map<String, List<DatabaseMetaDataWrapper.Index>> indexlistMap = tableInfo.getIndexList().stream().collect(Collectors.groupingBy(DatabaseMetaDataWrapper.Index::getName));
        String entityName = tableInfo.getEntityName();
        GlobalConfig globalConfig = tableInfo.getGlobalConfig();
        Entity entity = tableInfo.getStrategyConfig().entity();
        boolean columnConstant = entity.isColumnConstant();
        Set<Map.Entry<String, List<DatabaseMetaDataWrapper.Index>>> entrySet = indexlistMap.entrySet();
        ArrayList<MapperMethod> methodList = new ArrayList<MapperMethod>();
        for (Map.Entry<String, List<DatabaseMetaDataWrapper.Index>> entry : entrySet) {
            String deleteByMethod;
            String updateByMethod;
            String selectByMethod;
            boolean returnList;
            String indexName = entry.getKey();
            List<DatabaseMetaDataWrapper.Index> indexList = entry.getValue();
            int indexSize = indexList.size();
            if (this.singleIndex && indexSize > 1 || "PRIMARY".equals(indexName) && indexSize == 1) continue;
            ArrayList<TableField> tableFieldList = new ArrayList<TableField>();
            Map<String, TableField> tableFieldMap = tableInfo.getTableFieldMap();
            StringBuilder baseMethodNameBuilder = new StringBuilder();
            StringBuilder argsBuilder = new StringBuilder();
            StringBuilder baseWrapperBuilder = new StringBuilder();
            boolean uniqueKey = false;
            for (int i = 0; i < indexSize; ++i) {
                DatabaseMetaDataWrapper.Index index = indexList.get(i);
                if (index.isUnique()) {
                    uniqueKey = true;
                }
                TableField tableField = tableFieldMap.get(index.getColumnName());
                if (index.getColumnName().equals(entity.getLogicDeleteColumnName()) || tableField.getPropertyName().equals(entity.getLogicDeletePropertyName())) continue;
                tableFieldList.add(tableField);
                baseMethodNameBuilder.append(tableField.getCapitalName());
                if (indexSize > 1) {
                    if (columnConstant) {
                        baseWrapperBuilder.append("eq(ObjectUtils.isNotNull(").append(tableField.getPropertyName()).append(")").append(", ").append(entityName).append(".").append(tableField.getName().toUpperCase());
                    } else {
                        baseWrapperBuilder.append("eq(ObjectUtils.isNotNull(").append(tableField.getPropertyName()).append(")").append(", ").append("\"").append(tableField.getColumnName()).append("\"");
                    }
                } else if (columnConstant) {
                    baseWrapperBuilder.append("eq(").append(entityName).append(".").append(tableField.getName().toUpperCase());
                } else {
                    baseWrapperBuilder.append("eq(").append("\"").append(tableField.getColumnName()).append("\"");
                }
                baseWrapperBuilder.append(",").append(" ").append(tableField.getPropertyName()).append(")");
                if (globalConfig.isKotlin()) {
                    argsBuilder.append(tableField.getPropertyName()).append(":").append(" ").append(KotlinTypeUtils.getStringType(tableField.getColumnType()));
                } else {
                    argsBuilder.append(tableField.getColumnType().getType()).append(" ").append(tableField.getPropertyName());
                }
                if (i >= indexSize - 1) continue;
                baseWrapperBuilder.append(".");
                baseMethodNameBuilder.append("And");
                argsBuilder.append(", ");
            }
            String baseMethodName = baseMethodNameBuilder.toString();
            if (StringUtils.isBlank((CharSequence)baseMethodNameBuilder)) continue;
            String args = argsBuilder.toString();
            String baseWrapper = baseWrapperBuilder.toString();
            boolean bl = returnList = indexSize > 1 || !uniqueKey;
            if (globalConfig.isKotlin()) {
                selectByMethod = returnList ? this.buildKotlinMethod("selectBy" + baseMethodName, args, "List<" + tableInfo.getEntityName() + ">?", "selectList(Wrappers.query<" + tableInfo.getEntityName() + ">()." + baseWrapper + ")") : this.buildKotlinMethod("selectBy" + baseMethodName, args, tableInfo.getEntityName() + "?", "selectOne(Wrappers.query<" + tableInfo.getEntityName() + ">()." + baseWrapper + ")");
                updateByMethod = this.buildKotlinMethod("updateBy" + baseMethodName, "entity: " + tableInfo.getEntityName() + ", " + args, "Int", "update(entity, Wrappers.update<" + tableInfo.getEntityName() + ">()." + baseWrapper + ")");
                deleteByMethod = this.buildKotlinMethod("deleteBy" + baseMethodName, args, "Int", "delete(Wrappers.update<" + tableInfo.getEntityName() + ">()." + baseWrapper + ")");
                methodList.add(new MapperMethod(indexName, selectByMethod, tableFieldList));
                methodList.add(new MapperMethod(indexName, updateByMethod, tableFieldList));
                methodList.add(new MapperMethod(indexName, deleteByMethod, tableFieldList));
                continue;
            }
            selectByMethod = returnList ? this.buildMethod("selectBy" + baseMethodName, args, "List<" + tableInfo.getEntityName() + ">", "selectList(Wrappers.<" + tableInfo.getEntityName() + ">query()." + baseWrapper + ")") : this.buildMethod("selectBy" + baseMethodName, args, tableInfo.getEntityName(), "selectOne(Wrappers.<" + tableInfo.getEntityName() + ">query()." + baseWrapper + ")");
            updateByMethod = this.buildMethod("updateBy" + baseMethodName, tableInfo.getEntityName() + " entity, " + args, "int", "update(entity, Wrappers.<" + tableInfo.getEntityName() + ">update()." + baseWrapper + ")");
            deleteByMethod = this.buildMethod("deleteBy" + baseMethodName, args, "int", "delete(Wrappers.<" + tableInfo.getEntityName() + ">update()." + baseWrapper + ")");
            methodList.add(new MapperMethod(indexName, selectByMethod, tableFieldList));
            methodList.add(new MapperMethod(indexName, updateByMethod, tableFieldList));
            methodList.add(new MapperMethod(indexName, deleteByMethod, tableFieldList));
        }
        return methodList;
    }

    @Override
    public Set<String> getImportPackages(TableInfo tableInfo) {
        GlobalConfig globalConfig = tableInfo.getGlobalConfig();
        HashSet<String> imports = new HashSet<String>();
        if (!this.singleIndex) {
            imports.add(ObjectUtils.class.getName());
        }
        if (!globalConfig.isKotlin()) {
            imports.add(List.class.getName());
        }
        imports.add(Wrappers.class.getName());
        return imports;
    }
}

