/*
 * Decompiled with CFR 0.152.
 */
package com.baoyz.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.baoyz.widget.PullRefreshLayout;
import com.baoyz.widget.RefreshDrawable;

class ArcDrawable
extends RefreshDrawable {
    private static final int MAX_LEVEL = 200;
    private boolean isRunning;
    private RectF mBounds;
    private int mWidth;
    private int mHeight;
    private int mTop;
    private int mOffsetTop;
    private Paint mPaint;
    private float mAngle;
    private int[] mColorSchemeColors;
    private Handler mHandler = new Handler();
    private int mLevel;
    private Runnable mAnimationTask = new Runnable(){

        @Override
        public void run() {
            if (ArcDrawable.this.isRunning()) {
                ArcDrawable.this.mLevel++;
                if (ArcDrawable.this.mLevel > 200) {
                    ArcDrawable.this.mLevel = 0;
                }
                ArcDrawable.this.updateLevel(ArcDrawable.this.mLevel);
                ArcDrawable.this.invalidateSelf();
                ArcDrawable.this.mHandler.postDelayed((Runnable)this, 20L);
            }
        }
    };

    ArcDrawable(Context context, PullRefreshLayout layout) {
        super(context, layout);
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-65536);
    }

    @Override
    public void setPercent(float percent) {
        this.mPaint.setColor(this.evaluate(percent, this.mColorSchemeColors[3], this.mColorSchemeColors[0]));
    }

    @Override
    public void setColorSchemeColors(int[] colorSchemeColors) {
        this.mColorSchemeColors = colorSchemeColors;
    }

    @Override
    public void offsetTopAndBottom(int offset) {
        this.mTop += offset;
        this.mOffsetTop += offset;
        float offsetTop = this.mOffsetTop;
        if (this.mOffsetTop > this.getRefreshLayout().getFinalOffset()) {
            offsetTop = this.getRefreshLayout().getFinalOffset();
        }
        this.mAngle = 360.0f * (offsetTop / (float)this.getRefreshLayout().getFinalOffset());
        this.invalidateSelf();
    }

    public void start() {
        this.isRunning = true;
        this.mHandler.post(this.mAnimationTask);
    }

    private void updateLevel(int level) {
        int animationLevel = level == 200 ? 0 : level;
        int stateForLevel = animationLevel / 50;
        float percent = (float)(level % 50) / 50.0f;
        int startColor = this.mColorSchemeColors[stateForLevel];
        int endColor = this.mColorSchemeColors[(stateForLevel + 1) % this.mColorSchemeColors.length];
        this.mPaint.setColor(this.evaluate(percent, startColor, endColor));
    }

    public void stop() {
        this.isRunning = false;
        this.mHandler.removeCallbacks(this.mAnimationTask);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mHeight = this.mWidth = this.dp2px(40);
        this.mBounds = new RectF((float)(bounds.width() / 2 - this.mWidth / 2), (float)bounds.top, (float)(bounds.width() / 2 + this.mWidth / 2), (float)(bounds.top + this.mHeight));
    }

    public void draw(Canvas canvas) {
        canvas.save();
        this.drawRing(canvas);
        canvas.restore();
    }

    private void drawRing(Canvas canvas) {
        canvas.drawArc(this.mBounds, 270.0f, this.mAngle, true, this.mPaint);
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    private int evaluate(float fraction, int startValue, int endValue) {
        int startInt = startValue;
        int startA = startInt >> 24 & 0xFF;
        int startR = startInt >> 16 & 0xFF;
        int startG = startInt >> 8 & 0xFF;
        int startB = startInt & 0xFF;
        int endInt = endValue;
        int endA = endInt >> 24 & 0xFF;
        int endR = endInt >> 16 & 0xFF;
        int endG = endInt >> 8 & 0xFF;
        int endB = endInt & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }
}

