/*
 * Decompiled with CFR 0.152.
 */
package com.baoyz.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.baoyz.widget.PullRefreshLayout;
import com.baoyz.widget.RefreshDrawable;
import java.security.InvalidParameterException;

class CirclesDrawable
extends RefreshDrawable
implements Runnable {
    private static final float MAX_LEVEL = 10000.0f;
    private static final float CIRCLE_COUNT = ProgressStates.values().length;
    private static final float MAX_LEVEL_PER_CIRCLE = 10000.0f / CIRCLE_COUNT;
    private static final int ALPHA_OPAQUE = 255;
    private Paint mFstHalfPaint;
    private Paint mScndHalfPaint;
    private Paint mAbovePaint;
    private RectF mOval = new RectF();
    private int mDiameter;
    private Path mPath;
    private int mHalf;
    private ProgressStates mCurrentState;
    private int mControlPointMinimum;
    private int mControlPointMaximum;
    private int mAxisValue;
    private ColorFilter mColorFilter;
    private static int mColor1;
    private static int mColor2;
    private static int mColor3;
    private static int mColor4;
    private int fstColor;
    private int scndColor;
    private boolean goesBackward;
    private Handler mHandler = new Handler();
    private int mLevel;
    private boolean isRunning;
    private int mTop;
    private int mDrawWidth;
    private int mDrawHeight;
    private Rect mBounds;

    public CirclesDrawable(Context context, PullRefreshLayout layout) {
        super(context, layout);
    }

    public void start() {
        this.mLevel = 2500;
        this.isRunning = true;
        this.mHandler.postDelayed((Runnable)this, 10L);
    }

    public void stop() {
        this.isRunning = false;
        this.mHandler.removeCallbacks((Runnable)this);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void setColorSchemeColors(int[] colorSchemeColors) {
        this.initCirclesProgress(colorSchemeColors);
    }

    @Override
    public void setPercent(float percent) {
        int level = (int)(2500.0f * percent);
        this.updateLevel(level);
    }

    private void updateLevel(int level) {
        boolean halfPassed;
        int animationLevel = (float)level == 10000.0f ? 0 : level;
        int stateForLevel = (int)((float)animationLevel / MAX_LEVEL_PER_CIRCLE);
        this.mCurrentState = ProgressStates.values()[stateForLevel];
        this.resetColor(this.mCurrentState);
        int levelForCircle = (int)((float)animationLevel % MAX_LEVEL_PER_CIRCLE);
        if (!this.goesBackward) {
            halfPassed = levelForCircle != (int)((float)animationLevel % (MAX_LEVEL_PER_CIRCLE / 2.0f));
        } else {
            halfPassed = levelForCircle == (int)((float)animationLevel % (MAX_LEVEL_PER_CIRCLE / 2.0f));
            levelForCircle = (int)(MAX_LEVEL_PER_CIRCLE - (float)levelForCircle);
        }
        this.mFstHalfPaint.setColor(this.fstColor);
        this.mScndHalfPaint.setColor(this.scndColor);
        if (!halfPassed) {
            this.mAbovePaint.setColor(this.mScndHalfPaint.getColor());
        } else {
            this.mAbovePaint.setColor(this.mFstHalfPaint.getColor());
        }
        this.mAbovePaint.setAlpha(200 + (int)(55.0f * ((float)levelForCircle / MAX_LEVEL_PER_CIRCLE)));
        this.mAxisValue = (int)((float)this.mControlPointMinimum + (float)(this.mControlPointMaximum - this.mControlPointMinimum) * ((float)levelForCircle / MAX_LEVEL_PER_CIRCLE));
    }

    @Override
    public void offsetTopAndBottom(int offset) {
        this.mTop += offset;
        this.invalidateSelf();
    }

    @Override
    public void run() {
        this.mLevel += 80;
        if ((float)this.mLevel > 10000.0f) {
            this.mLevel = 0;
        }
        if (this.isRunning) {
            this.mHandler.postDelayed((Runnable)this, 20L);
            this.updateLevel(this.mLevel);
            this.invalidateSelf();
        }
    }

    private void initCirclesProgress(int[] colors) {
        this.initColors(colors);
        this.mPath = new Path();
        Paint basePaint = new Paint();
        basePaint.setAntiAlias(true);
        this.mFstHalfPaint = new Paint(basePaint);
        this.mScndHalfPaint = new Paint(basePaint);
        this.mAbovePaint = new Paint(basePaint);
        this.setColorFilter(this.mColorFilter);
    }

    private void initColors(int[] colors) {
        if (colors == null || colors.length < 4) {
            throw new InvalidParameterException("The color scheme length must be 4");
        }
        mColor1 = colors[0];
        mColor2 = colors[1];
        mColor3 = colors[2];
        mColor4 = colors[3];
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mDrawHeight = this.mDrawWidth = this.dp2px(40);
        this.mTop = -this.mDrawHeight - (this.getRefreshLayout().getFinalOffset() - this.mDrawHeight) / 2;
        this.mBounds = bounds;
        this.measureCircleProgress(this.mDrawWidth, this.mDrawHeight);
    }

    private void resetColor(ProgressStates currentState) {
        switch (currentState) {
            case FOLDING_DOWN: {
                this.fstColor = mColor1;
                this.scndColor = mColor2;
                this.goesBackward = false;
                break;
            }
            case FOLDING_LEFT: {
                this.fstColor = mColor1;
                this.scndColor = mColor3;
                this.goesBackward = true;
                break;
            }
            case FOLDING_UP: {
                this.fstColor = mColor3;
                this.scndColor = mColor4;
                this.goesBackward = true;
                break;
            }
            case FOLDING_RIGHT: {
                this.fstColor = mColor2;
                this.scndColor = mColor4;
                this.goesBackward = false;
            }
        }
    }

    public void draw(Canvas canvas) {
        if (this.mCurrentState != null) {
            canvas.save();
            canvas.translate((float)(this.mBounds.width() / 2 - this.mDrawWidth / 2), (float)this.mTop);
            this.makeCirclesProgress(canvas);
            canvas.restore();
        }
    }

    private void measureCircleProgress(int width, int height) {
        this.mDiameter = Math.min(width, height);
        this.mHalf = this.mDiameter / 2;
        this.mOval.set(0.0f, 0.0f, (float)this.mDiameter, (float)this.mDiameter);
        this.mControlPointMinimum = -this.mDiameter / 6;
        this.mControlPointMaximum = this.mDiameter + this.mDiameter / 6;
    }

    private void makeCirclesProgress(Canvas canvas) {
        switch (this.mCurrentState) {
            case FOLDING_DOWN: 
            case FOLDING_UP: {
                this.drawYMotion(canvas);
                break;
            }
            case FOLDING_LEFT: 
            case FOLDING_RIGHT: {
                this.drawXMotion(canvas);
            }
        }
        canvas.drawPath(this.mPath, this.mAbovePaint);
    }

    private void drawXMotion(Canvas canvas) {
        canvas.drawArc(this.mOval, 90.0f, 180.0f, true, this.mFstHalfPaint);
        canvas.drawArc(this.mOval, -270.0f, -180.0f, true, this.mScndHalfPaint);
        this.mPath.reset();
        this.mPath.moveTo((float)this.mHalf, 0.0f);
        this.mPath.cubicTo((float)this.mAxisValue, 0.0f, (float)this.mAxisValue, (float)this.mDiameter, (float)this.mHalf, (float)this.mDiameter);
    }

    private void drawYMotion(Canvas canvas) {
        canvas.drawArc(this.mOval, 0.0f, -180.0f, true, this.mFstHalfPaint);
        canvas.drawArc(this.mOval, -180.0f, -180.0f, true, this.mScndHalfPaint);
        this.mPath.reset();
        this.mPath.moveTo(0.0f, (float)this.mHalf);
        this.mPath.cubicTo(0.0f, (float)this.mAxisValue, (float)this.mDiameter, (float)this.mAxisValue, (float)this.mDiameter, (float)this.mHalf);
    }

    @Override
    public void setColorFilter(ColorFilter cf) {
        this.mColorFilter = cf;
        this.mFstHalfPaint.setColorFilter(cf);
        this.mScndHalfPaint.setColorFilter(cf);
        this.mAbovePaint.setColorFilter(cf);
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    private static enum ProgressStates {
        FOLDING_DOWN,
        FOLDING_LEFT,
        FOLDING_UP,
        FOLDING_RIGHT;

    }
}

