/*
 * Decompiled with CFR 0.152.
 */
package com.baoyz.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import android.widget.ImageView;
import com.baoyz.widget.CirclesDrawable;
import com.baoyz.widget.MaterialDrawable;
import com.baoyz.widget.R;
import com.baoyz.widget.RefreshDrawable;
import com.baoyz.widget.RingDrawable;
import com.baoyz.widget.SmartisanDrawable;
import com.baoyz.widget.WaterDropDrawable;
import java.security.InvalidParameterException;

public class PullRefreshLayout
extends ViewGroup {
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private static final int DRAG_MAX_DISTANCE = 64;
    private static final int INVALID_POINTER = -1;
    private static final float DRAG_RATE = 0.5f;
    public static final int STYLE_MATERIAL = 0;
    public static final int STYLE_CIRCLES = 1;
    public static final int STYLE_WATER_DROP = 2;
    public static final int STYLE_RING = 3;
    public static final int STYLE_SMARTISAN = 4;
    private View mTarget;
    private ImageView mRefreshView;
    private Interpolator mDecelerateInterpolator;
    private int mTouchSlop;
    private int mSpinnerFinalOffset;
    private int mTotalDragDistance;
    private RefreshDrawable mRefreshDrawable;
    private int mCurrentOffsetTop;
    private boolean mRefreshing;
    private int mActivePointerId;
    private boolean mIsBeingDragged;
    private float mInitialMotionY;
    private int mFrom;
    private boolean mNotify;
    private OnRefreshListener mListener;
    private int[] mColorSchemeColors;
    public int mDurationToStartPosition;
    public int mDurationToCorrectPosition;
    private int mInitialOffsetTop;
    private boolean mDispatchTargetTouchDown;
    private float mDragPercent;
    private final Animation mAnimateToStartPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            PullRefreshLayout.this.moveToStart(interpolatedTime);
        }
    };
    private final Animation mAnimateToCorrectPosition = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            int endTarget = PullRefreshLayout.this.mSpinnerFinalOffset;
            int targetTop = PullRefreshLayout.this.mFrom + (int)((float)(endTarget - PullRefreshLayout.this.mFrom) * interpolatedTime);
            int offset = targetTop - PullRefreshLayout.this.mTarget.getTop();
            PullRefreshLayout.this.setTargetOffsetTop(offset, false);
        }
    };
    private Animation.AnimationListener mRefreshListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            PullRefreshLayout.this.mRefreshView.setVisibility(0);
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            if (PullRefreshLayout.this.mRefreshing) {
                PullRefreshLayout.this.mRefreshDrawable.start();
                if (PullRefreshLayout.this.mNotify && PullRefreshLayout.this.mListener != null) {
                    PullRefreshLayout.this.mListener.onRefresh();
                }
            } else {
                PullRefreshLayout.this.mRefreshDrawable.stop();
                PullRefreshLayout.this.mRefreshView.setVisibility(8);
                PullRefreshLayout.this.animateOffsetToStartPosition();
            }
            PullRefreshLayout.this.mCurrentOffsetTop = PullRefreshLayout.this.mTarget.getTop();
        }
    };
    private Animation.AnimationListener mToStartListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
            PullRefreshLayout.this.mRefreshDrawable.stop();
        }

        public void onAnimationRepeat(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            PullRefreshLayout.this.mRefreshView.setVisibility(8);
            PullRefreshLayout.this.mCurrentOffsetTop = PullRefreshLayout.this.mTarget.getTop();
        }
    };

    public PullRefreshLayout(Context context) {
        this(context, null);
    }

    public PullRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        int defaultDuration;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.refresh_PullRefreshLayout);
        int type = a.getInteger(R.styleable.refresh_PullRefreshLayout_refreshType, 0);
        int colorsId = a.getResourceId(R.styleable.refresh_PullRefreshLayout_refreshColors, 0);
        int colorId = a.getResourceId(R.styleable.refresh_PullRefreshLayout_refreshColor, 0);
        a.recycle();
        this.mDecelerateInterpolator = new DecelerateInterpolator(2.0f);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mDurationToStartPosition = defaultDuration = this.getResources().getInteger(0x10E0001);
        this.mDurationToCorrectPosition = defaultDuration;
        this.mSpinnerFinalOffset = this.mTotalDragDistance = this.dp2px(64);
        this.mColorSchemeColors = colorsId > 0 ? context.getResources().getIntArray(colorsId) : new int[]{Color.rgb((int)201, (int)52, (int)55), Color.rgb((int)55, (int)91, (int)241), Color.rgb((int)247, (int)210, (int)62), Color.rgb((int)52, (int)163, (int)80)};
        if (colorId > 0) {
            this.mColorSchemeColors = new int[]{context.getResources().getColor(colorId)};
        }
        this.mRefreshView = new ImageView(context);
        this.setRefreshStyle(type);
        this.mRefreshView.setVisibility(8);
        this.addView((View)this.mRefreshView, 0);
        this.setWillNotDraw(false);
        ViewCompat.setChildrenDrawingOrderEnabled((ViewGroup)this, (boolean)true);
    }

    public void setColorSchemeColors(int ... colorSchemeColors) {
        this.mColorSchemeColors = colorSchemeColors;
        this.mRefreshDrawable.setColorSchemeColors(colorSchemeColors);
    }

    public void setColor(int color) {
        this.setColorSchemeColors(color);
    }

    public void setRefreshStyle(int type) {
        this.setRefreshing(false);
        switch (type) {
            case 0: {
                this.mRefreshDrawable = new MaterialDrawable(this.getContext(), this);
                break;
            }
            case 1: {
                this.mRefreshDrawable = new CirclesDrawable(this.getContext(), this);
                break;
            }
            case 2: {
                this.mRefreshDrawable = new WaterDropDrawable(this.getContext(), this);
                break;
            }
            case 3: {
                this.mRefreshDrawable = new RingDrawable(this.getContext(), this);
                break;
            }
            case 4: {
                this.mRefreshDrawable = new SmartisanDrawable(this.getContext(), this);
                break;
            }
            default: {
                throw new InvalidParameterException("Type does not exist");
            }
        }
        this.mRefreshDrawable.setColorSchemeColors(this.mColorSchemeColors);
        this.mRefreshView.setImageDrawable((Drawable)this.mRefreshDrawable);
    }

    public void setRefreshDrawable(RefreshDrawable drawable) {
        this.setRefreshing(false);
        this.mRefreshDrawable = drawable;
        this.mRefreshDrawable.setColorSchemeColors(this.mColorSchemeColors);
        this.mRefreshView.setImageDrawable((Drawable)this.mRefreshDrawable);
    }

    public int getFinalOffset() {
        return this.mSpinnerFinalOffset;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.ensureTarget();
        if (this.mTarget == null) {
            return;
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft()), (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000);
        this.mTarget.measure(widthMeasureSpec, heightMeasureSpec);
        this.mRefreshView.measure(widthMeasureSpec, heightMeasureSpec);
    }

    private void ensureTarget() {
        if (this.mTarget != null) {
            return;
        }
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child == this.mRefreshView) continue;
                this.mTarget = child;
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || this.canChildScrollUp() && !this.mRefreshing) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                if (!this.mRefreshing) {
                    this.setTargetOffsetTop(0, true);
                }
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.mIsBeingDragged = false;
                float initialMotionY = this.getMotionEventY(ev, this.mActivePointerId);
                if (initialMotionY == -1.0f) {
                    return false;
                }
                this.mInitialMotionY = initialMotionY;
                this.mInitialOffsetTop = this.mCurrentOffsetTop;
                this.mDispatchTargetTouchDown = false;
                this.mDragPercent = 0.0f;
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                float y = this.getMotionEventY(ev, this.mActivePointerId);
                if (y == -1.0f) {
                    return false;
                }
                float yDiff = y - this.mInitialMotionY;
                if (this.mRefreshing) {
                    this.mIsBeingDragged = !(yDiff < 0.0f) || this.mCurrentOffsetTop > 0;
                    break;
                }
                if (!(yDiff > (float)this.mTouchSlop) || this.mIsBeingDragged) break;
                this.mIsBeingDragged = true;
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mIsBeingDragged) {
            return super.onTouchEvent(ev);
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 2: {
                int targetY;
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (pointerIndex < 0) {
                    return false;
                }
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                float yDiff = y - this.mInitialMotionY;
                if (this.mRefreshing) {
                    targetY = (int)((float)this.mInitialOffsetTop + yDiff);
                    if (this.canChildScrollUp()) {
                        targetY = -1;
                        this.mInitialMotionY = y;
                        this.mInitialOffsetTop = 0;
                        if (this.mDispatchTargetTouchDown) {
                            this.mTarget.dispatchTouchEvent(ev);
                        } else {
                            MotionEvent obtain = MotionEvent.obtain((MotionEvent)ev);
                            obtain.setAction(0);
                            this.mDispatchTargetTouchDown = true;
                            this.mTarget.dispatchTouchEvent(obtain);
                        }
                    } else if (targetY < 0) {
                        if (this.mDispatchTargetTouchDown) {
                            this.mTarget.dispatchTouchEvent(ev);
                        } else {
                            MotionEvent obtain = MotionEvent.obtain((MotionEvent)ev);
                            obtain.setAction(0);
                            this.mDispatchTargetTouchDown = true;
                            this.mTarget.dispatchTouchEvent(obtain);
                        }
                        targetY = 0;
                    } else if (targetY > this.mTotalDragDistance) {
                        targetY = this.mTotalDragDistance;
                    } else if (this.mDispatchTargetTouchDown) {
                        MotionEvent obtain = MotionEvent.obtain((MotionEvent)ev);
                        obtain.setAction(3);
                        this.mDispatchTargetTouchDown = false;
                        this.mTarget.dispatchTouchEvent(obtain);
                    }
                } else {
                    float scrollTop = yDiff * 0.5f;
                    float originalDragPercent = scrollTop / (float)this.mTotalDragDistance;
                    if (originalDragPercent < 0.0f) {
                        return false;
                    }
                    this.mDragPercent = Math.min(1.0f, Math.abs(originalDragPercent));
                    float extraOS = Math.abs(scrollTop) - (float)this.mTotalDragDistance;
                    float slingshotDist = this.mSpinnerFinalOffset;
                    float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, slingshotDist * 2.0f) / slingshotDist);
                    float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
                    float extraMove = slingshotDist * tensionPercent * 2.0f;
                    targetY = (int)(slingshotDist * this.mDragPercent + extraMove);
                    if (this.mRefreshView.getVisibility() != 0) {
                        this.mRefreshView.setVisibility(0);
                    }
                    if (scrollTop < (float)this.mTotalDragDistance) {
                        this.mRefreshDrawable.setPercent(this.mDragPercent);
                    }
                }
                this.setTargetOffsetTop(targetY - this.mCurrentOffsetTop, true);
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mActivePointerId == -1) {
                    return false;
                }
                if (this.mRefreshing) {
                    if (this.mDispatchTargetTouchDown) {
                        this.mTarget.dispatchTouchEvent(ev);
                        this.mDispatchTargetTouchDown = false;
                    }
                    return false;
                }
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                float overscrollTop = (y - this.mInitialMotionY) * 0.5f;
                this.mIsBeingDragged = false;
                if (overscrollTop > (float)this.mTotalDragDistance) {
                    this.setRefreshing(true, true);
                } else {
                    this.mRefreshing = false;
                    this.animateOffsetToStartPosition();
                }
                this.mActivePointerId = -1;
                return false;
            }
        }
        return true;
    }

    public void setDurations(int durationToStartPosition, int durationToCorrectPosition) {
        this.mDurationToStartPosition = durationToStartPosition;
        this.mDurationToCorrectPosition = durationToCorrectPosition;
    }

    private void animateOffsetToStartPosition() {
        this.mFrom = this.mCurrentOffsetTop;
        this.mAnimateToStartPosition.reset();
        this.mAnimateToStartPosition.setDuration((long)this.mDurationToStartPosition);
        this.mAnimateToStartPosition.setInterpolator(this.mDecelerateInterpolator);
        this.mAnimateToStartPosition.setAnimationListener(this.mToStartListener);
        this.mRefreshView.clearAnimation();
        this.mRefreshView.startAnimation(this.mAnimateToStartPosition);
    }

    private void animateOffsetToCorrectPosition() {
        this.mFrom = this.mCurrentOffsetTop;
        this.mAnimateToCorrectPosition.reset();
        this.mAnimateToCorrectPosition.setDuration((long)this.mDurationToCorrectPosition);
        this.mAnimateToCorrectPosition.setInterpolator(this.mDecelerateInterpolator);
        this.mAnimateToCorrectPosition.setAnimationListener(this.mRefreshListener);
        this.mRefreshView.clearAnimation();
        this.mRefreshView.startAnimation(this.mAnimateToCorrectPosition);
    }

    private void moveToStart(float interpolatedTime) {
        int targetTop = this.mFrom - (int)((float)this.mFrom * interpolatedTime);
        int offset = targetTop - this.mTarget.getTop();
        this.setTargetOffsetTop(offset, false);
        this.mRefreshDrawable.setPercent(this.mDragPercent * (1.0f - interpolatedTime));
    }

    public void setRefreshing(boolean refreshing) {
        if (this.mRefreshing != refreshing) {
            this.setRefreshing(refreshing, false);
        }
    }

    private void setRefreshing(boolean refreshing, boolean notify) {
        if (this.mRefreshing != refreshing) {
            this.mNotify = notify;
            this.ensureTarget();
            this.mRefreshing = refreshing;
            if (this.mRefreshing) {
                this.mRefreshDrawable.setPercent(1.0f);
                this.animateOffsetToCorrectPosition();
            } else {
                this.animateOffsetToStartPosition();
            }
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private float getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
        if (index < 0) {
            return -1.0f;
        }
        return MotionEventCompat.getY((MotionEvent)ev, (int)index);
    }

    private void setTargetOffsetTop(int offset, boolean requiresUpdate) {
        this.mTarget.offsetTopAndBottom(offset);
        this.mCurrentOffsetTop = this.mTarget.getTop();
        this.mRefreshDrawable.offsetTopAndBottom(offset);
        if (requiresUpdate && Build.VERSION.SDK_INT < 11) {
            this.invalidate();
        }
    }

    private boolean canChildScrollUp() {
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTarget instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTarget;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return this.mTarget.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.ensureTarget();
        if (this.mTarget == null) {
            return;
        }
        int height = this.getMeasuredHeight();
        int width = this.getMeasuredWidth();
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int right = this.getPaddingRight();
        int bottom = this.getPaddingBottom();
        this.mTarget.layout(left, top + this.mTarget.getTop(), left + width - right, top + height - bottom + this.mTarget.getTop());
        this.mRefreshView.layout(left, top, left + width - right, top + height - bottom);
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    public void setOnRefreshListener(OnRefreshListener listener) {
        this.mListener = listener;
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

