/*
 * Decompiled with CFR 0.152.
 */
package com.baoyz.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.baoyz.widget.PullRefreshLayout;
import com.baoyz.widget.RefreshDrawable;

public class SmartisanDrawable
extends RefreshDrawable {
    RectF mBounds;
    float mWidth;
    float mHeight;
    float mCenterX;
    float mCenterY;
    float mPercent;
    final float mMaxAngle = 153.0f;
    final float mRadius = this.dp2px(12);
    final float mLineLength = (float)(2.670353755551324 * (double)this.mRadius);
    final float mLineWidth = this.dp2px(3);
    final float mArrowLength = (int)((double)this.mLineLength * 0.15);
    final float mArrowAngle = 0.43633232f;
    final float mArrowXSpace = (int)((double)this.mArrowLength * Math.sin(0.4363323152065277));
    final float mArrowYSpace = (int)((double)this.mArrowLength * Math.cos(0.4363323152065277));
    final Paint mPaint = new Paint();
    int mOffset;
    boolean mRunning;
    float mDegrees;

    public SmartisanDrawable(Context context, PullRefreshLayout layout) {
        super(context, layout);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth(this.mLineWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setColor(-7829368);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mWidth = this.mHeight = (float)this.getRefreshLayout().getFinalOffset();
        this.mBounds = new RectF((float)(bounds.width() / 2) - this.mWidth / 2.0f, (float)bounds.top - this.mHeight / 2.0f, (float)(bounds.width() / 2) + this.mWidth / 2.0f, (float)bounds.top + this.mHeight / 2.0f);
        this.mCenterX = this.mBounds.centerX();
        this.mCenterY = this.mBounds.centerY();
    }

    @Override
    public void setPercent(float percent) {
        this.mPercent = percent;
        this.invalidateSelf();
    }

    @Override
    public void setColorSchemeColors(int[] colorSchemeColors) {
        if (colorSchemeColors != null && colorSchemeColors.length > 0) {
            this.mPaint.setColor(colorSchemeColors[0]);
        }
    }

    @Override
    public void offsetTopAndBottom(int offset) {
        this.mOffset += offset;
        this.invalidateSelf();
    }

    public void start() {
        this.mRunning = true;
        this.mDegrees = 0.0f;
        this.invalidateSelf();
    }

    public void stop() {
        this.mRunning = false;
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public void draw(Canvas canvas) {
        canvas.save();
        canvas.translate(0.0f, (float)(this.mOffset / 2));
        canvas.clipRect(this.mBounds);
        if ((float)this.mOffset > this.mHeight && !this.isRunning()) {
            canvas.rotate(((float)this.mOffset - this.mHeight) / this.mHeight * 360.0f, this.mCenterX, this.mCenterY);
        }
        if (this.isRunning()) {
            canvas.rotate(this.mDegrees, this.mCenterX, this.mCenterY);
            this.mDegrees = this.mDegrees < 360.0f ? this.mDegrees + 10.0f : 0.0f;
            this.invalidateSelf();
        }
        if (this.mPercent <= 0.5f) {
            float percent = this.mPercent / 0.5f;
            float leftX = this.mCenterX - this.mRadius;
            float leftY = this.mCenterY + this.mLineLength - this.mLineLength * percent;
            canvas.drawLine(leftX, leftY, leftX, leftY + this.mLineLength, this.mPaint);
            canvas.drawLine(leftX, leftY, leftX - this.mArrowXSpace, leftY + this.mArrowYSpace, this.mPaint);
            float rightX = this.mCenterX + this.mRadius;
            float rightY = this.mCenterY - this.mLineLength + this.mLineLength * percent;
            canvas.drawLine(rightX, rightY, rightX, rightY - this.mLineLength, this.mPaint);
            canvas.drawLine(rightX, rightY, rightX + this.mArrowXSpace, rightY - this.mArrowYSpace, this.mPaint);
        } else {
            float percent = (this.mPercent - 0.5f) / 0.5f;
            float leftX = this.mCenterX - this.mRadius;
            float leftY = this.mCenterY;
            canvas.drawLine(leftX, leftY, leftX, leftY + this.mLineLength - this.mLineLength * percent, this.mPaint);
            RectF oval = new RectF(this.mCenterX - this.mRadius, this.mCenterY - this.mRadius, this.mCenterX + this.mRadius, this.mCenterY + this.mRadius);
            canvas.drawArc(oval, 180.0f, 153.0f * percent, false, this.mPaint);
            float rightX = this.mCenterX + this.mRadius;
            float rightY = this.mCenterY;
            canvas.drawLine(rightX, rightY, rightX, rightY - this.mLineLength + this.mLineLength * percent, this.mPaint);
            canvas.drawArc(oval, 0.0f, 153.0f * percent, false, this.mPaint);
            canvas.save();
            canvas.rotate(153.0f * percent, this.mCenterX, this.mCenterY);
            canvas.drawLine(leftX, leftY, leftX - this.mArrowXSpace, leftY + this.mArrowYSpace, this.mPaint);
            canvas.drawLine(rightX, rightY, rightX + this.mArrowXSpace, rightY - this.mArrowYSpace, this.mPaint);
            canvas.restore();
        }
        canvas.restore();
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }
}

