/*
 * Decompiled with CFR 0.152.
 */
package com.baoyz.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import com.baoyz.widget.PullRefreshLayout;
import com.baoyz.widget.RefreshDrawable;
import java.security.InvalidParameterException;

class WaterDropDrawable
extends RefreshDrawable
implements Runnable {
    private static final float MAX_LEVEL = 10000.0f;
    private static final float CIRCLE_COUNT = ProgressStates.values().length;
    private static final float MAX_LEVEL_PER_CIRCLE = 10000.0f / CIRCLE_COUNT;
    private int mLevel;
    private Point p1;
    private Point p2;
    private Point p3;
    private Point p4;
    private Paint mPaint;
    private Path mPath;
    private int mHeight;
    private int mWidth;
    private int mTop;
    private int[] mColorSchemeColors;
    private ProgressStates mCurrentState;
    private Handler mHandler = new Handler();
    private boolean isRunning;

    public WaterDropDrawable(Context context, PullRefreshLayout layout) {
        super(context, layout);
        this.mPaint = new Paint();
        this.mPaint.setColor(-16776961);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mPath = new Path();
        this.p1 = new Point();
        this.p2 = new Point();
        this.p3 = new Point();
        this.p4 = new Point();
    }

    public void draw(Canvas canvas) {
        canvas.save();
        canvas.translate(0.0f, this.mTop > 0 ? (float)this.mTop : 0.0f);
        this.mPath.reset();
        this.mPath.moveTo((float)this.p1.x, (float)this.p1.y);
        this.mPath.cubicTo((float)this.p3.x, (float)this.p3.y, (float)this.p4.x, (float)this.p4.y, (float)this.p2.x, (float)this.p2.y);
        canvas.drawPath(this.mPath, this.mPaint);
        canvas.restore();
    }

    protected void onBoundsChange(Rect bounds) {
        this.mWidth = bounds.width();
        this.updateBounds();
        super.onBoundsChange(bounds);
    }

    private void updateBounds() {
        int height = this.mHeight;
        int width = this.mWidth;
        if (height > this.getRefreshLayout().getFinalOffset()) {
            height = this.getRefreshLayout().getFinalOffset();
        }
        float percent = (float)height / (float)this.getRefreshLayout().getFinalOffset();
        int offsetX = (int)((float)(width / 2) * percent);
        int offsetY = 0;
        this.p1.set(offsetX, offsetY);
        this.p2.set(width - offsetX, offsetY);
        this.p3.set(width / 2 - height, height);
        this.p4.set(width / 2 + height, height);
    }

    @Override
    public void setColorSchemeColors(int[] colorSchemeColors) {
        if (colorSchemeColors == null || colorSchemeColors.length < 4) {
            throw new InvalidParameterException("The color scheme length must be 4");
        }
        this.mPaint.setColor(colorSchemeColors[0]);
        this.mColorSchemeColors = colorSchemeColors;
    }

    @Override
    public void setPercent(float percent) {
        this.mPaint.setColor(this.evaluate(percent, this.mColorSchemeColors[0], this.mColorSchemeColors[1]));
    }

    private void updateLevel(int level) {
        int animationLevel = (float)level == 10000.0f ? 0 : level;
        int stateForLevel = (int)((float)animationLevel / MAX_LEVEL_PER_CIRCLE);
        this.mCurrentState = ProgressStates.values()[stateForLevel];
        float percent = (float)(level % 2500) / 2500.0f;
        int startColor = this.mColorSchemeColors[stateForLevel];
        int endColor = this.mColorSchemeColors[(stateForLevel + 1) % ProgressStates.values().length];
        this.mPaint.setColor(this.evaluate(percent, startColor, endColor));
    }

    @Override
    public void offsetTopAndBottom(int offset) {
        this.mHeight += offset;
        this.mTop = this.mHeight - this.getRefreshLayout().getFinalOffset();
        this.updateBounds();
        this.invalidateSelf();
    }

    public void start() {
        this.mLevel = 2500;
        this.isRunning = true;
        this.mHandler.postDelayed((Runnable)this, 20L);
    }

    public void stop() {
        this.mHandler.removeCallbacks((Runnable)this);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void run() {
        this.mLevel += 60;
        if ((float)this.mLevel > 10000.0f) {
            this.mLevel = 0;
        }
        if (this.isRunning) {
            this.mHandler.postDelayed((Runnable)this, 20L);
            this.updateLevel(this.mLevel);
            this.invalidateSelf();
        }
    }

    private int evaluate(float fraction, int startValue, int endValue) {
        int startInt = startValue;
        int startA = startInt >> 24 & 0xFF;
        int startR = startInt >> 16 & 0xFF;
        int startG = startInt >> 8 & 0xFF;
        int startB = startInt & 0xFF;
        int endInt = endValue;
        int endA = endInt >> 24 & 0xFF;
        int endR = endInt >> 16 & 0xFF;
        int endG = endInt >> 8 & 0xFF;
        int endB = endInt & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }

    private static enum ProgressStates {
        ONE,
        TWO,
        TREE,
        FOUR;

    }
}

