/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.monitor;

import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.monitor.AbandonedTraceExt;
import com.frameworkset.common.poolman.monitor.PoolMonitorService;
import com.frameworkset.common.poolman.monitor.PoolmanStatic;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.util.TransferObjectFactory;
import java.util.ArrayList;
import java.util.List;

public class PoolMonitorServiceImpl
implements PoolMonitorService {
    @Override
    public List<PoolmanStatic> getAllPools() {
        ArrayList<PoolmanStatic> all = new ArrayList<PoolmanStatic>();
        List<String> pools = DBUtil.getAllPoolNames();
        JDBCPoolMetaData jdbcPoolMetaData = null;
        for (int i = 0; pools != null && i < pools.size(); ++i) {
            String dbname = pools.get(i);
            jdbcPoolMetaData = DBUtil.getJDBCPoolMetaData(dbname);
            PoolmanStatic ps = new PoolmanStatic();
            TransferObjectFactory.createTransferObject((Object)jdbcPoolMetaData, (Object)ps);
            ps.setActiveconnections(DBUtil.getNumActive(dbname));
            ps.setHeapconnections(DBUtil.getMaxNumActive(dbname));
            if (!jdbcPoolMetaData.isUsepool()) {
                ps.setIdleconnections(DBUtil.getNumIdle(dbname));
            }
            ps.setStartTime(DBUtil.getStartTime(dbname));
            ps.setStopTime(DBUtil.getStopTime(dbname));
            ps.setStatus(DBUtil.getStatus(dbname));
            ps.setDbname(dbname);
            all.add(ps);
        }
        return all;
    }

    @Override
    public PoolmanStatic getPoolmanStatic(String dbname) {
        PoolmanStatic ps = new PoolmanStatic();
        TransferObjectFactory.createTransferObject((Object)DBUtil.getJDBCPoolMetaData(dbname), (Object)ps);
        ps.setActiveconnections(DBUtil.getNumActive(dbname));
        ps.setHeapconnections(DBUtil.getMaxNumActive(dbname));
        if (!ps.isUsepool()) {
            ps.setIdleconnections(DBUtil.getNumIdle(dbname));
        }
        ps.setStartTime(DBUtil.getStartTime(dbname));
        ps.setStopTime(DBUtil.getStopTime(dbname));
        ps.setStatus(DBUtil.getStatus(dbname));
        ps.setDbname(dbname);
        return ps;
    }

    @Override
    public boolean startPool(String dbname) {
        try {
            DBUtil.startPool(dbname);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String statusCheckPool(String dbname) {
        try {
            String status = DBUtil.statusCheck(dbname);
            if ("start".equals(status)) {
                return "START";
            }
            if ("stop".equals(status)) {
                return "STOP";
            }
            if ("unknown".equals(status)) {
                return "UNKNOWN";
            }
            return "FAILED";
        }
        catch (Exception e) {
            return "FAILED";
        }
    }

    @Override
    public boolean stopPool(String dbname) {
        try {
            DBUtil.stopPool(dbname);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<AbandonedTraceExt> getTraceObjects(String dbname) {
        return DBUtil.getGoodTraceObjects(dbname);
    }

    public List<AbandonedTraceExt> getGoodTraceObjects(String dbname) {
        return DBUtil.getGoodTraceObjects(dbname);
    }
}

