/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.orm.adapter;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.SQLExecutor;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.security.DBInfoEncrypt;
import com.frameworkset.common.poolman.util.JDBCPoolMetaData;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.orm.engine.model.Domain;
import com.frameworkset.orm.engine.model.SchemaType;
import com.frameworkset.orm.platform.PlatformOracleImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

public class DBOracle
extends DB {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String columncommentsql = "select c.comments from user_col_comments c where NLS_LOWER(c.table_name)=? and NLS_LOWER(c.column_name)=?";
    private static final String tablecommentsql = "select comments from user_tab_comments where NLS_LOWER(table_name)=? and table_type='TABLE'";

    protected DBOracle() {
        this.platform = new PlatformOracleImpl();
        this.date_format = "yyyy-MM-dd HH24:mi:ss";
    }

    @Override
    public String toUpperCase(String in) {
        return "UPPER(" + in + ")";
    }

    @Override
    public String ignoreCase(String in) {
        return "UPPER(" + in + ")";
    }

    @Override
    public String to_char(String date, String format) {
        StringBuilder ret = new StringBuilder();
        ret.append("to_char(").append(date).append(",'").append(format != null ? format : this.FORMART_ALL).append("')");
        return ret.toString();
    }

    @Override
    public String to_char(String date) {
        return this.to_char(date, this.FORMART_ALL);
    }

    @Override
    public String getDateString(Date date) {
        return this.to_date(date, this.date_format);
    }

    @Override
    public String getDateString(String date) {
        return this.to_date(date, this.date_format);
    }

    @Override
    public String getDateString(Date date, String format) {
        return this.to_date(date, format);
    }

    @Override
    public String getDateString(String date, String format) {
        return this.to_date(date, format);
    }

    @Override
    public String to_date(Date date) {
        return this.to_date(date, this.date_format);
    }

    @Override
    public String to_date(String date) {
        return this.to_date(date, this.date_format);
    }

    @Override
    public String to_date(Date date, String format) {
        if (date == null) {
            return null;
        }
        return "TO_DATE('" + new SimpleDateFormat(DATE_FORMAT).format(date) + "', '" + format + "')";
    }

    @Override
    public String to_date(String date, String format) {
        if (date == null) {
            return null;
        }
        return "TO_DATE('" + date + "', '" + format + "')";
    }

    @Override
    public String filedToDateFunction(String date) {
        return this.filedToDateFunction(date, this.date_format);
    }

    @Override
    public String filedToDateFunction(String date, String format) {
        if (date == null) {
            return null;
        }
        if (date == null) {
            return null;
        }
        return "TO_DATE(" + date + ", '" + format + "')";
    }

    @Override
    public String getIDMethodType() {
        return "sequence";
    }

    @Override
    public String getIDMethodSQL(Object sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    @Override
    public void lockTable(Connection con, String table) throws SQLException {
        Statement statement = con.createStatement();
        StringBuilder stmt = new StringBuilder();
        stmt.append("SELECT next_id FROM ").append(table).append(" FOR UPDATE");
        statement.executeQuery(stmt.toString());
    }

    @Override
    public void unlockTable(Connection con, String table) throws SQLException {
        con.commit();
    }

    @Override
    public boolean supportsNativeLimit() {
        return true;
    }

    @Override
    public int getLimitStyle() {
        return 4;
    }

    @Override
    public boolean escapeText() {
        return false;
    }

    @Override
    public Object getCharValue(ResultSet res, int i, String value) {
        if (value == null) {
            return null;
        }
        return value;
    }

    @Override
    public String getOROPR() {
        return "||";
    }

    @Override
    public String getSchema(JDBCPoolMetaData info) {
        if (info.getUserName() == null || info.getUserName().equals("")) {
            return null;
        }
        if (!info.isEncryptdbinfo()) {
            return info.getUserName().toUpperCase();
        }
        DBInfoEncrypt dbInfoEncrypt = DBOracle.getDBInfoEncrypt();
        return dbInfoEncrypt.decryptDBUser(info.getUserName()).toUpperCase();
    }

    @Override
    public String getIDMAXSql(String table_name, String table_id_name, String table_id_prefix, String type) {
        String maxSql = "select nvl(max(" + table_id_name + "),0) from " + table_name;
        if (type.equalsIgnoreCase("string") || type.equalsIgnoreCase("java.lang.string")) {
            maxSql = table_id_prefix != null && !table_id_prefix.trim().equals("") ? "select nvl(max(TO_NUMBER(SUBSTR(" + table_id_name + ",LENGTH('" + table_id_prefix + "') + 1))),0) from " + table_name : "select nvl(max(TO_NUMBER(" + table_id_name + ")),0) from " + table_name;
        }
        return maxSql;
    }

    @Override
    public String getNativeIdMethod() {
        return this.platform.getNativeIdMethod();
    }

    @Override
    public int getMaxColumnNameLength() {
        return this.platform.getMaxColumnNameLength();
    }

    @Override
    public Domain getDomainForSchemaType(SchemaType jdbcType) {
        return this.getDomainForSchemaType(jdbcType);
    }

    @Override
    public String getNullString(boolean notNull) {
        return this.platform.getNullString(notNull);
    }

    @Override
    public String getAutoIncrement() {
        return this.platform.getAutoIncrement();
    }

    @Override
    public boolean hasSize(String sqlType) {
        return this.platform.hasSize(sqlType);
    }

    @Override
    public boolean hasScale(String sqlType) {
        return this.platform.hasScale(sqlType);
    }

    @Override
    public String getLimitSelect(String selectSql, int limit) {
        StringBuilder ret = new StringBuilder();
        ret.append("select * from (").append(selectSql).append(") where rownum <=").append(limit);
        return ret.toString();
    }

    @Override
    public DB.PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared) {
        StringBuilder ret = null;
        ret = prepared ? new StringBuilder().append("select ss1.* from (select tt1.*,rownum rowno_ from (").append(sql).append(") tt1 where rownum <= ?) ss1 where ss1.rowno_ >= ?") : new StringBuilder("select ss1.* from (select tt1.*,rownum rowno_ from (").append(sql).append(") tt1 where rownum <= ").append(offset + (long)maxsize).append(") ss1 where ss1.rowno_ >= ").append(offset + 1L);
        return new DB.PagineSql(ret.toString(), offset + (long)maxsize, offset + 1L, offset, maxsize, prepared).setRebuilded(true);
    }

    @Override
    public String getStringPagineSql(String sql) {
        StringBuilder ret = new StringBuilder().append("select ss1.* from (select tt1.*,rownum rowno_ from (").append(sql).append(") tt1 where rownum <= ?) ss1 where ss1.rowno_ >= ?");
        return ret.toString();
    }

    @Override
    public String getStringPagineSql(String schema, String tablename, String pkname, String columns) {
        StringBuilder sqlbuilder = new StringBuilder();
        sqlbuilder.append("select * from (SELECT ");
        if (columns != null && !columns.equals("")) {
            sqlbuilder.append(columns);
        } else {
            sqlbuilder.append("* ");
        }
        sqlbuilder.append(",ROW_NUMBER() OVER ( ORDER BY ").append(pkname).append(") rownum__  from   ");
        if (schema != null && !schema.equals("")) {
            sqlbuilder.append(schema).append(".");
        }
        sqlbuilder.append(tablename);
        if (columns != null && !columns.equals("")) {
            sqlbuilder.append(" ) bb where bb.rownum__ <=? and bb.rownum__ >=?");
        } else {
            sqlbuilder.append(" t) bb where bb.rownum__ <=? and bb.rownum__ >=?");
        }
        return sqlbuilder.toString();
    }

    @Override
    public void queryByNullRowHandler(NullRowHandler handler, String dbname, String pageinestatement, long offset, int pagesize) throws SQLException {
        SQLExecutor.queryWithDBNameByNullRowHandler(handler, dbname, pageinestatement, offset + (long)pagesize, offset + 1L);
    }

    @Override
    public void resetPostion(PreparedStatement statement, int startidx, int endidx, long offset, int maxsize) throws SQLException {
        statement.setLong(startidx, offset + (long)maxsize);
        statement.setLong(endidx, offset + 1L);
    }

    @Override
    public String getOracleLimitSelect(String selectSql, int limit, String rownum) {
        StringBuilder ret = new StringBuilder();
        ret.append("select * from (").append(selectSql).append(") where ").append(rownum).append(" <=").append(limit);
        return ret.toString();
    }

    @Override
    public DB.PagineSql getDBPagineSql(String sql, long offset, int maxsize, boolean prepared, String orderby) {
        StringBuilder ret = null;
        ret = prepared ? new StringBuilder().append("SELECT *  FROM (SELECT b.*, ROW_NUMBER () OVER (").append(orderby).append(") AS rownums FROM (").append(sql).append(") b) WHERE rownums <= ? and rownums >=?") : new StringBuilder().append("SELECT *  FROM (SELECT b.*, ROW_NUMBER () OVER (").append(orderby).append(") AS rownums FROM (").append(sql).append(") b) WHERE rownums <= ").append(offset + (long)maxsize).append(" and rownums >=").append(offset + 1L);
        return new DB.PagineSql(ret.toString(), offset + (long)maxsize, offset + 1L, offset, maxsize, prepared).setRebuilded(true);
    }

    @Override
    public String getStringPagineSql(String sql, String orderby) {
        StringBuilder ret = new StringBuilder().append("SELECT *  FROM (SELECT b.*, ROW_NUMBER () OVER (").append(orderby).append(") AS rownums FROM (").append(sql).append(") b) WHERE rownums <= ? and rownums >=?");
        return ret.toString();
    }

    @Override
    public String getStringPagineSql(String schema, String tablename, String pkname, String columns, String orderby) {
        StringBuilder newsql = new StringBuilder().append("SELECT *  FROM (SELECT b.*, ROW_NUMBER () OVER (").append(orderby).append(") AS rownums FROM (").append("SELECT ");
        if (columns != null && !columns.equals("")) {
            newsql.append(columns);
        } else {
            newsql.append("* ");
        }
        newsql.append(" from   ");
        if (schema != null && !schema.equals("")) {
            newsql.append(schema).append(".");
        }
        newsql.append(tablename).append(") b) WHERE rownums <= ? and rownums >=?");
        return newsql.toString();
    }

    @Override
    public DB.PagineSql getOracleDBPagineSql(String sql, long offset, int maxsize, String rownum, boolean prepared) {
        StringBuilder ret = null;
        ret = prepared ? new StringBuilder().append("select * from (").append(sql).append(") where ").append(rownum).append(" between ? and ?") : new StringBuilder().append("select * from (").append(sql).append(") where ").append(rownum).append(" between ").append(offset + 1L).append(" and ").append(offset + (long)maxsize);
        return new DB.PagineSql(ret.toString(), offset + 1L, offset + (long)maxsize, offset, maxsize, prepared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableRemarks(Connection con, String tableName, String tableRemark) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(tablecommentsql);
            pstmt.setString(1, tableName.toLowerCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String remark = rs.getString(1);
                if (remark == null) {
                    remark = "";
                }
                String string = remark;
                return string;
            }
        }
        catch (SQLException e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return tableRemark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnRemarks(Connection con, String tableName, String columnName, String remarks_c) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(columncommentsql);
            pstmt.setString(1, tableName.toLowerCase());
            pstmt.setString(2, columnName.toLowerCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String remark = rs.getString(1);
                if (remark == null) {
                    remark = "";
                }
                String string = remark;
                return string;
            }
        }
        catch (SQLException e) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return remarks_c;
    }

    @Override
    public int getSCROLLType(String dbdriver) {
        return 1003;
    }

    @Override
    public int getCusorType(String dbdriver) {
        return 1007;
    }

    @Override
    public void updateClob(Object content, Connection conn, String table, String clobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
        Statement stmt = null;
        ResultSet rs = null;
        Writer wr = null;
        StringBuilder sqlBuffer = new StringBuilder();
        boolean flag = false;
        boolean oldAutoCommit = false;
        try {
            oldAutoCommit = conn.getAutoCommit();
            if (oldAutoCommit) {
                conn.setAutoCommit(false);
                flag = true;
            }
            sqlBuffer.append("select ");
            sqlBuffer.append(clobColumn);
            sqlBuffer.append(" from ");
            sqlBuffer.append(table);
            sqlBuffer.append(" where ");
            sqlBuffer.append(keyColumn);
            sqlBuffer.append("=");
            sqlBuffer.append("?");
            sqlBuffer.append(" for update nowait");
            stmt = conn.prepareStatement(sqlBuffer.toString());
            SQLUtil.setValue((PreparedStatement)stmt, 1, table, keyColumn, keyValue, dbName, conn);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                DBOracle.commitBig(oldAutoCommit, conn, flag);
                throw new IllegalArgumentException("no record found for keyValue: '" + keyValue + "'");
            }
            CLOB clob = (CLOB)rs.getClob(clobColumn);
            if (clob == null) {
                clob = this.initClob(conn, table, clobColumn, keyColumn, keyValue, dbName);
            }
            wr = clob.getCharacterOutputStream();
            if (content instanceof String) {
                wr.write((String)content);
            } else if (content instanceof File) {
                File f = (File)content;
                FileReader reader = new FileReader(f);
                char[] cbuf = new char[1024];
                int i = 0;
                while ((i = reader.read(cbuf)) > 0) {
                    wr.write(cbuf, 0, i);
                }
            } else {
                String temp = String.valueOf(content);
                wr.write(temp);
            }
            wr.flush();
            DBOracle.commitBig(oldAutoCommit, conn, flag);
        }
        catch (SQLException e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw e;
        }
        catch (IOException e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw e;
        }
        catch (Exception e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw new SQLException(e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conn != null && oldAutoCommit) {
                    conn.setAutoCommit(true);
                }
            }
            catch (Exception exception) {}
            try {
                if (wr != null) {
                    wr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updateBlob(InputStream instream, Connection conn, String table, String blobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
        Statement stmt = null;
        ResultSet rs = null;
        OutputStream outstream = null;
        StringBuilder sqlBuffer = new StringBuilder();
        boolean oldAutoCommit = false;
        boolean flag = false;
        try {
            oldAutoCommit = conn.getAutoCommit();
            if (oldAutoCommit) {
                conn.setAutoCommit(false);
                flag = true;
            }
            sqlBuffer.append("select ");
            sqlBuffer.append(blobColumn);
            sqlBuffer.append(" from ");
            sqlBuffer.append(table);
            sqlBuffer.append(" where ");
            sqlBuffer.append(keyColumn);
            sqlBuffer.append("=");
            sqlBuffer.append("?");
            sqlBuffer.append(" for update nowait");
            stmt = conn.prepareStatement(sqlBuffer.toString());
            SQLUtil.setValue((PreparedStatement)stmt, 1, table, keyColumn, keyValue, dbName, conn);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                DBOracle.commitBig(oldAutoCommit, conn, flag);
                throw new SQLException("no record found for keyValue: '" + keyValue + "'");
            }
            BLOB blob = (BLOB)rs.getBlob(blobColumn);
            if (blob == null) {
                blob = DBOracle.initBlob(conn, table, blobColumn, keyColumn, keyValue, dbName);
            }
            outstream = blob.getBinaryOutputStream();
            int bufferSize = blob.getChunkSize();
            byte[] buffer = new byte[bufferSize];
            int bytesRead = -1;
            while ((bytesRead = instream.read(buffer)) > 0) {
                outstream.write(buffer, 0, bytesRead);
            }
            outstream.flush();
            DBOracle.commitBig(oldAutoCommit, conn, flag);
        }
        catch (SQLException e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw e;
        }
        catch (IOException e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw new SQLException(e.getMessage());
        }
        catch (Exception e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw new SQLException(e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outstream != null) {
                    outstream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conn != null && oldAutoCommit) {
                    conn.setAutoCommit(true);
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void commitBig(boolean oldAutoCommit, Connection conn, boolean flag) throws SQLException {
        if (oldAutoCommit && flag) {
            SQLException ee = null;
            try {
                conn.commit();
            }
            catch (SQLException e) {
                ee = e;
            }
            try {
                conn.setAutoCommit(oldAutoCommit);
            }
            catch (SQLException e) {
                ee = e;
            }
            if (ee != null) {
                throw ee;
            }
        }
    }

    private static void rollbackBig(boolean oldAutoCommit, Connection conn, boolean flag) {
        if (oldAutoCommit && flag) {
            SQLException ee = null;
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                ee = e1;
            }
            try {
                conn.setAutoCommit(oldAutoCommit);
            }
            catch (SQLException e1) {
                SQLException sQLException = e1;
            }
        }
    }

    @Override
    public void updateBlob(byte[] value, Connection conn, String table, String blobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
        Statement stmt = null;
        ResultSet rs = null;
        ByteArrayInputStream instream = null;
        OutputStream outstream = null;
        StringBuilder sqlBuffer = new StringBuilder();
        boolean oldAutoCommit = false;
        boolean flag = false;
        try {
            oldAutoCommit = conn.getAutoCommit();
            if (oldAutoCommit) {
                conn.setAutoCommit(false);
                flag = true;
            }
            sqlBuffer.append("select ");
            sqlBuffer.append(blobColumn);
            sqlBuffer.append(" from ");
            sqlBuffer.append(table);
            sqlBuffer.append(" where ");
            sqlBuffer.append(keyColumn);
            sqlBuffer.append("=");
            sqlBuffer.append("?");
            sqlBuffer.append(" for update nowait");
            stmt = conn.prepareStatement(sqlBuffer.toString());
            SQLUtil.setValue((PreparedStatement)stmt, 1, table, keyColumn, keyValue, dbName, conn);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                DBOracle.commitBig(oldAutoCommit, conn, flag);
                throw new SQLException("no record found for keyValue: '" + keyValue + "'");
            }
            BLOB blob = (BLOB)rs.getBlob(blobColumn);
            if (blob == null) {
                blob = DBOracle.initBlob(conn, table, blobColumn, keyColumn, keyValue, dbName);
            }
            instream = new ByteArrayInputStream(value);
            outstream = blob.getBinaryOutputStream();
            int bufferSize = blob.getChunkSize();
            byte[] buffer = new byte[bufferSize];
            int bytesRead = -1;
            while ((bytesRead = instream.read(buffer)) != -1) {
                outstream.write(buffer, 0, bytesRead);
            }
            outstream.flush();
            DBOracle.commitBig(oldAutoCommit, conn, flag);
        }
        catch (SQLException e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw e;
        }
        catch (IOException e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw new SQLException(e.getMessage());
        }
        catch (Exception e) {
            DBOracle.rollbackBig(oldAutoCommit, conn, flag);
            throw new SQLException(e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outstream != null) {
                    outstream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conn != null && oldAutoCommit) {
                    conn.setAutoCommit(true);
                }
            }
            catch (Exception exception) {}
        }
    }

    private static BLOB initBlob(Connection conn, String table, String blobColumn, String keyColumn, String keyValue, String dbName) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            sql.append("update ").append(table).append(" set ").append(blobColumn).append("=?").append(" where ").append(keyColumn).append("=").append("'").append(keyValue).append("'");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setBlob(1, (Blob)BLOB.empty_lob());
            pstmt.executeUpdate();
            StringBuilder sqlBuffer = new StringBuilder();
            sqlBuffer.append("select ");
            sqlBuffer.append(blobColumn);
            sqlBuffer.append(" from ");
            sqlBuffer.append(table);
            sqlBuffer.append(" where ");
            sqlBuffer.append(keyColumn);
            sqlBuffer.append("=");
            sqlBuffer.append("?");
            sqlBuffer.append("  ");
            stmt = conn.prepareStatement(sqlBuffer.toString());
            SQLUtil.setValue((PreparedStatement)stmt, 1, table, keyColumn, keyValue, dbName, conn);
            rs = stmt.executeQuery();
            if (rs.next()) {
                BLOB blob;
                BLOB bLOB = blob = (BLOB)rs.getBlob(blobColumn);
                return bLOB;
            }
            try {
                throw new SQLException("no record found for keyValue: '" + keyValue + "'");
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private CLOB initClob(Connection conn, String table, String clobColumn, String keyColumn, String keyValue, String dbName) throws SQLException {
        Statement pstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("update ").append(table).append(" set ").append(clobColumn).append("=?").append(" where ").append(keyColumn).append("=").append("'").append(keyValue).append("'");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setClob(1, (Clob)CLOB.empty_lob());
            pstmt.executeUpdate();
            StringBuilder sqlBuffer = new StringBuilder();
            sqlBuffer.append("select ");
            sqlBuffer.append(clobColumn);
            sqlBuffer.append(" from ");
            sqlBuffer.append(table);
            sqlBuffer.append(" where ");
            sqlBuffer.append(keyColumn);
            sqlBuffer.append("=");
            sqlBuffer.append("?");
            sqlBuffer.append("  ");
            stmt = conn.prepareStatement(sqlBuffer.toString());
            SQLUtil.setValue((PreparedStatement)stmt, 1, table, keyColumn, keyValue, dbName, conn);
            rs = stmt.executeQuery();
            if (rs.next()) {
                CLOB clob;
                CLOB cLOB = clob = (CLOB)rs.getClob(clobColumn);
                return cLOB;
            }
            try {
                throw new SQLException("no record found for keyValue: '" + keyValue + "'");
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public void updateBLOB(Blob blob_, File file) throws SQLException {
        BLOB blob = (BLOB)blob_;
        if (blob == null) {
            return;
        }
        if (file == null || !file.exists()) {
            return;
        }
        InputStream instream = null;
        OutputStream outstream = null;
        try {
            outstream = blob.getBinaryOutputStream();
            instream = new BufferedInputStream(new FileInputStream(file));
            int bufferSize = blob.getChunkSize();
            byte[] buffer = new byte[bufferSize];
            int bytesRead = -1;
            while ((bytesRead = instream.read(buffer)) > 0) {
                outstream.write(buffer, 0, bytesRead);
            }
            outstream.flush();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (Exception exception) {}
            instream = null;
            try {
                if (outstream != null) {
                    outstream.close();
                }
            }
            catch (Exception exception) {}
            outstream = null;
        }
    }

    @Override
    public void updateBLOB(Blob blob_, InputStream instream) throws SQLException {
        BLOB blob = (BLOB)blob_;
        if (blob == null) {
            return;
        }
        if (instream == null) {
            return;
        }
        OutputStream outstream = null;
        try {
            outstream = blob.getBinaryOutputStream();
            int bufferSize = blob.getChunkSize();
            byte[] buffer = new byte[bufferSize];
            int bytesRead = -1;
            while ((bytesRead = instream.read(buffer)) > 0) {
                outstream.write(buffer, 0, bytesRead);
            }
            outstream.flush();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (Exception exception) {}
            instream = null;
            try {
                if (outstream != null) {
                    outstream.close();
                }
            }
            catch (Exception exception) {}
            outstream = null;
        }
    }

    @Override
    public void updateCLOB(Clob clob_, Object content) throws SQLException {
        CLOB clob = (CLOB)clob_;
        if (clob == null) {
            return;
        }
        if (content == null) {
            return;
        }
        Reader reader = null;
        Writer wr = null;
        try {
            wr = clob.getCharacterOutputStream();
            if (content instanceof String) {
                reader = new BufferedReader(new StringReader((String)content));
            } else if (content instanceof File) {
                File f = (File)content;
                reader = new BufferedReader(new FileReader(f));
            } else if (content instanceof Reader) {
                reader = (Reader)content;
            } else {
                String s = content.toString();
                reader = new BufferedReader(new StringReader(s));
            }
            char[] cbuf = new char[1024];
            int i = 0;
            while ((i = reader.read(cbuf)) > 0) {
                wr.write(cbuf, 0, i);
            }
            wr.flush();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            reader = null;
            wr = null;
        }
    }

    @Override
    public byte[] getBytesFromResultset(ResultSet res, String columnName) throws SQLException {
        BLOB blob = ((OracleResultSet)res).getBLOB(columnName);
        byte[] content = new byte[(int)blob.length()];
        content = blob.getBytes(1L, (int)blob.length());
        return content;
    }

    @Override
    public byte[] getBytesFromBlob(Blob blob) throws SQLException {
        byte[] content = new byte[(int)blob.length()];
        content = blob.getBytes(1L, (int)blob.length());
        return content;
    }

    @Override
    public byte[] getBytesFromClob(Clob clob_) {
        CLOB clob = (CLOB)clob_;
        byte[] content = clob.getBytes();
        return content;
    }

    @Override
    public String getStringFromClob(Clob clob_) {
        CLOB clob = (CLOB)clob_;
        byte[] content = clob.getBytes();
        String ret = new String(content);
        return ret;
    }
}

