/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.persitent.util;

import com.frameworkset.common.poolman.sql.PoolManResultSetMetaData;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.util.VariableHandler;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.frameworkset.cache.MissingStaticCache;
import org.frameworkset.persitent.util.SQLBaseCache;
import org.frameworkset.persitent.util.SQLInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLMissingCache
extends SQLBaseCache {
    private static final Logger logger = LoggerFactory.getLogger(SQLMissingCache.class);
    private Map<String, MissingStaticCache<String, VariableHandler.SQLStruction>> parserTPLSQLStructions = new HashMap<String, MissingStaticCache<String, VariableHandler.SQLStruction>>();
    private Map<String, MissingStaticCache<String, VariableHandler.SQLStruction>> parserTPLTotalsizeSQLStructions = new HashMap<String, MissingStaticCache<String, VariableHandler.SQLStruction>>();
    protected Map<String, MissingStaticCache<String, PoolManResultSetMetaData>> missingCacheMetas = new HashMap<String, MissingStaticCache<String, PoolManResultSetMetaData>>();

    public SQLMissingCache(String sqlfile, int resultMetaCacheSize, int perKeySqlStructionCacheSize) {
        super(sqlfile, resultMetaCacheSize, perKeySqlStructionCacheSize);
    }

    @Override
    public void clear() {
        this.missingCacheMetas.clear();
        this.parserTPLSQLStructions.clear();
        this.parserTPLTotalsizeSQLStructions.clear();
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolManResultSetMetaData getPoolManResultSetMetaData(DB db, String dbname, String sqlkey, ResultSetMetaData rsmetadata) throws SQLException {
        PoolManResultSetMetaData meta = null;
        MissingStaticCache dbmetas = this.missingCacheMetas.get(dbname);
        if (dbmetas == null) {
            Map<String, MissingStaticCache<String, PoolManResultSetMetaData>> map = this.missingCacheMetas;
            synchronized (map) {
                dbmetas = this.missingCacheMetas.get(dbname);
                if (dbmetas == null) {
                    dbmetas = new MissingStaticCache(this.resultMetaCacheSize);
                    this.missingCacheMetas.put(dbname, (MissingStaticCache<String, PoolManResultSetMetaData>)dbmetas);
                }
            }
        }
        if (dbmetas.stopCache()) {
            meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
            if (logger.isWarnEnabled()) {
                this.logMetaWarn(logger, sqlkey, dbmetas.getMissesMax());
            }
            return meta;
        }
        boolean newMeta = false;
        meta = (PoolManResultSetMetaData)dbmetas.get((Object)sqlkey);
        if (meta == null) {
            try {
                this.metaLock.lock();
                meta = (PoolManResultSetMetaData)dbmetas.get((Object)sqlkey);
                if (meta == null) {
                    dbmetas.increamentMissing();
                    newMeta = true;
                    meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
                    if (!dbmetas.stopCache()) {
                        dbmetas.put((Object)sqlkey, (Object)meta);
                    }
                }
            }
            finally {
                this.metaLock.unlock();
            }
        }
        if (!newMeta && this.needRefreshMeta(meta, rsmetadata)) {
            meta = PoolManResultSetMetaData.getCopy(db, rsmetadata);
            dbmetas.put((Object)sqlkey, (Object)meta);
        }
        if (dbmetas.stopCache() && logger.isWarnEnabled()) {
            this.logMetaWarn(logger, sqlkey, dbmetas.getMissesMax());
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected VariableHandler.SQLStruction _getVTPLSQLStruction(boolean isTotalSize, SQLInfo sqlinfo, String newsql, String okey, int cacheSize) {
        Map<String, MissingStaticCache<String, VariableHandler.SQLStruction>> _parserTPLSQLStructions = !isTotalSize ? this.parserTPLSQLStructions : this.parserTPLTotalsizeSQLStructions;
        String ikey = newsql;
        MissingStaticCache sqlstructionMap = _parserTPLSQLStructions.get(okey);
        if (sqlstructionMap == null) {
            try {
                this.vtplLock.lock();
                sqlstructionMap = _parserTPLSQLStructions.get(okey);
                if (sqlstructionMap == null) {
                    sqlstructionMap = new MissingStaticCache(cacheSize);
                    _parserTPLSQLStructions.put(okey, (MissingStaticCache<String, VariableHandler.SQLStruction>)sqlstructionMap);
                }
            }
            finally {
                this.vtplLock.unlock();
            }
        }
        if (sqlstructionMap.stopCache()) {
            if (logger.isWarnEnabled()) {
                this.logSqlStructionWarn(logger, ikey, sqlstructionMap.getMissesMax(), okey);
            }
            return VariableHandler.parserSQLStruction((String)newsql);
        }
        VariableHandler.SQLStruction urlStruction = (VariableHandler.SQLStruction)sqlstructionMap.get((Object)ikey);
        if (urlStruction == null) {
            try {
                this.vtplLock.lock();
                urlStruction = (VariableHandler.SQLStruction)sqlstructionMap.get((Object)ikey);
                if (urlStruction == null) {
                    sqlstructionMap.increamentMissing();
                    urlStruction = VariableHandler.parserSQLStruction((String)newsql);
                    if (!sqlstructionMap.stopCache()) {
                        sqlstructionMap.put((Object)ikey, (Object)urlStruction);
                    }
                }
            }
            finally {
                this.vtplLock.unlock();
            }
            if (sqlstructionMap.stopCache() && logger.isWarnEnabled()) {
                this.logSqlStructionWarn(logger, ikey, sqlstructionMap.getMissesMax(), okey);
            }
        }
        return urlStruction;
    }
}

