/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.util;

import com.frameworkset.common.util.ValueObjectUtil;
import java.util.Date;

public final class CompareUtil {
    public static int compareValue(Object left, Object right) {
        return CompareUtil.compareValue(left, right, true);
    }

    public static int compareValue(Object left, Object right, boolean desc) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null && right != null) {
            return CompareUtil.lessThan(desc);
        }
        if (left != null && right == null) {
            return CompareUtil.moreThan(desc);
        }
        if (Integer.TYPE.isInstance(left) || Integer.class.isInstance(left)) {
            return CompareUtil.compareInt((Integer)left, (Integer)right, desc);
        }
        if (Short.TYPE.isInstance(left) || Short.class.isInstance(left)) {
            return CompareUtil.compareShort((Short)left, (Short)right, desc);
        }
        if (Character.TYPE.isInstance(left) || Character.class.isInstance(left)) {
            return CompareUtil.compareChar(((Character)left).charValue(), ((Character)right).charValue(), desc);
        }
        if (Long.TYPE.isInstance(left) || Long.class.isInstance(left)) {
            return CompareUtil.compareLong((Long)left, (Long)right, desc);
        }
        if (Double.TYPE.isInstance(left) || Double.class.isInstance(left)) {
            return CompareUtil.compareDouble((Double)left, (Double)right, desc);
        }
        if (String.class.isInstance(left)) {
            return CompareUtil.compareString((String)left, (String)right, desc);
        }
        if (Boolean.TYPE.isInstance(left) || Boolean.class.isInstance(left)) {
            return CompareUtil.compareBoolean((Boolean)left, (Boolean)right, desc);
        }
        if (Date.class.isInstance(left)) {
            return CompareUtil.compareDate((Date)left, (Date)right, desc);
        }
        if (Float.TYPE.isInstance(left) || Float.class.isInstance(left)) {
            return CompareUtil.compareFloat(((Float)left).floatValue(), ((Float)right).floatValue(), desc);
        }
        return 0;
    }

    public static int compareBoolean(boolean left, boolean right, boolean desc) {
        if (left && right) {
            return 0;
        }
        if (left && !right) {
            return CompareUtil.moreThan(desc);
        }
        if (!left && right) {
            return CompareUtil.lessThan(desc);
        }
        return 0;
    }

    public static int compareString(String left, String right, boolean desc) {
        int ret = left.compareTo(right);
        if (ret > 0) {
            return CompareUtil.moreThan(desc);
        }
        if (ret < 0) {
            return CompareUtil.lessThan(desc);
        }
        return 0;
    }

    public static int compareInt(int left, int right, boolean desc) {
        if (left < right) {
            return CompareUtil.lessThan(desc);
        }
        if (left == right) {
            return 0;
        }
        return CompareUtil.moreThan(desc);
    }

    public static int compareDate(Date left, Date right, boolean desc) {
        int ret = left.compareTo(right);
        if (ret > 0) {
            return CompareUtil.moreThan(desc);
        }
        if (ret < 0) {
            return CompareUtil.lessThan(desc);
        }
        return ret;
    }

    public static int compareLong(long left, long right, boolean desc) {
        if (left < right) {
            return CompareUtil.lessThan(desc);
        }
        if (left > right) {
            return CompareUtil.moreThan(desc);
        }
        return 0;
    }

    public static int compareShort(short left, short right, boolean desc) {
        if (left < right) {
            return CompareUtil.lessThan(desc);
        }
        if (left > right) {
            return CompareUtil.moreThan(desc);
        }
        return 0;
    }

    public static int compareDouble(double left, double right, boolean desc) {
        if (left < right) {
            return CompareUtil.lessThan(desc);
        }
        if (left > right) {
            return CompareUtil.moreThan(desc);
        }
        return 0;
    }

    public static int compareFloat(float left, float right, boolean desc) {
        if (left < right) {
            return CompareUtil.lessThan(desc);
        }
        if (left > right) {
            return CompareUtil.moreThan(desc);
        }
        return 0;
    }

    public static int compareChar(char left, char right, boolean desc) {
        if (left < right) {
            return CompareUtil.lessThan(desc);
        }
        if (left > right) {
            return CompareUtil.moreThan(desc);
        }
        return 0;
    }

    private static int lessThan(boolean desc) {
        return desc ? 1 : -1;
    }

    private static int moreThan(boolean desc) {
        return desc ? -1 : 1;
    }

    public static int compareField(Object obj, String field, Object compareValue) {
        return CompareUtil.compareField(obj, field, compareValue, true);
    }

    public static int compareField(Object obj, String field, Object compareValue, boolean desc) {
        Object value = ValueObjectUtil.getValue(obj, field.trim());
        return CompareUtil.compareValue(value, compareValue, desc);
    }

    public static int compareField(Object obj, String field, Object obj1, String field1, boolean desc) {
        Object value = ValueObjectUtil.getValue(obj, field.trim());
        Object value1 = ValueObjectUtil.getValue(obj1, field1.trim());
        return CompareUtil.compareValue(value, value1, desc);
    }

    public static int compareField(Object obj, String field, Object obj1, String field1) {
        return CompareUtil.compareField(obj, field, obj1, field1, true);
    }
}

