/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.cache;

import com.frameworkset.util.DaemonThread;
import com.frameworkset.util.FileUtil;
import com.frameworkset.util.ResourceInitial;
import com.frameworkset.util.SimpleStringUtil;
import com.frameworkset.util.UUIDResource;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileContentCache {
    private static Method shutdownMethod;
    private static Logger log;
    private Map<String, String> democontentCache = new HashMap<String, String>();
    public static final int HTMLNoBREncode = 0;
    public static final int HTMLEncode = 1;
    public static final int PLAINEncode = 2;
    public static final int HTMLEncodej = 3;
    private Object lock = new Object();
    private DaemonThread damon = null;
    private long refreshInterval = 5000L;

    private String _getFileContent(String path, String charset, int encodeType) {
        String content = "";
        try {
            content = encodeType == 0 ? SimpleStringUtil.HTMLNoBREncode(FileUtil.getFileContent(path, charset)) : (encodeType == 1 ? SimpleStringUtil.HTMLEncode(FileUtil.getFileContent(path, charset)) : (encodeType == 3 ? SimpleStringUtil.HTMLEncodej(FileUtil.getFileContent(path, charset)) : FileUtil.getFileContent(path, charset)));
        }
        catch (IOException e) {
            log.error("Get File Content Error:path=" + path + ",charset=" + charset + ",convertHtmlTag=" + encodeType, (Throwable)e);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContent(String path, String charset, int encodeType) {
        String key = path + "|" + charset + "|" + encodeType;
        String content = this.democontentCache.get(key);
        if (content != null) {
            return content;
        }
        Object object = this.lock;
        synchronized (object) {
            content = this.democontentCache.get(key);
            if (content != null) {
                return content;
            }
            content = this._getFileContent(path, charset, encodeType);
            this.democontentCache.put(key, content);
            this.damon.addFile(path, (ResourceInitial)new ResourceCacheRefresh(key));
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removecache(String cachekey) {
        Object object = this.lock;
        synchronized (object) {
            this.democontentCache.remove(cachekey);
        }
    }

    public void start(String name) throws Exception {
        this.damon = new DaemonThread(this.refreshInterval, "FileContentCache Refresh Monitor Worker for " + name);
        this.damon.start();
        if (shutdownMethod != null) {
            shutdownMethod.invoke(null, new Runnable(){

                @Override
                public void run() {
                    try {
                        FileContentCache.this.destroy();
                    }
                    catch (RuntimeException e) {
                        log.warn("", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.warn("", (Throwable)e);
                    }
                    catch (Throwable e) {
                        log.warn("", e);
                    }
                }
            });
        }
    }

    public void start() throws Exception {
        this.damon = new DaemonThread(this.refreshInterval, "FileContentCache Refresh Monitor Worker");
        this.damon.start();
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void destroy() throws Exception {
        if (this.damon != null) {
            this.damon.stopped();
            this.damon = null;
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.frameworkset.spi.BaseApplicationContext");
            shutdownMethod = clazz.getMethod("addShutdownHook", Runnable.class);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        log = LoggerFactory.getLogger(FileContentCache.class);
    }

    class ResourceCacheRefresh
    implements ResourceInitial,
    UUIDResource {
        private String cachekey;

        public ResourceCacheRefresh(String cachekey) {
            this.cachekey = cachekey;
        }

        @Override
        public void reinit() {
            FileContentCache.this.removecache(this.cachekey);
        }

        @Override
        public String getUUID() {
            return this.cachekey;
        }
    }
}

