/*
 * Decompiled with CFR 0.152.
 */
package org.frameworkset.util.io;

import com.frameworkset.util.EditorInf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.frameworkset.util.SystemPropertyUtils;
import org.frameworkset.util.io.PathMatchingResourcePatternResolver;
import org.frameworkset.util.io.Resource;
import org.frameworkset.util.io.ResourcePatternResolver;

public class ResourceArrayPropertyEditor
implements EditorInf<Resource[]> {
    private final ResourcePatternResolver resourcePatternResolver;

    public ResourceArrayPropertyEditor() {
        this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
    }

    public ResourceArrayPropertyEditor(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }

    @Override
    public Resource[] getValueFromObject(Object value) {
        if (value instanceof Collection || value instanceof Object[] && !(value instanceof Resource[])) {
            List<Object> input = value instanceof Collection ? (List<Object>)value : Arrays.asList((Object[])value);
            ArrayList<Resource> merged = new ArrayList<Resource>();
            for (Object e : input) {
                if (e instanceof String) {
                    String pattern = this.resolvePath((String)e).trim();
                    try {
                        Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                        for (int i = 0; i < resources.length; ++i) {
                            Resource resource = resources[i];
                            if (merged.contains(resource)) continue;
                            merged.add(resource);
                        }
                        continue;
                    }
                    catch (IOException ex) {
                        throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
                    }
                }
                if (e instanceof Resource) {
                    if (merged.contains(e)) continue;
                    merged.add((Resource)e);
                    continue;
                }
                throw new IllegalArgumentException("Cannot convert element [" + e + "] to [" + Resource.class.getName() + "]: only location String and Resource object supported");
            }
            return merged.toArray(new Resource[merged.size()]);
        }
        if (value instanceof Resource[]) {
            return (Resource[])value;
        }
        return this.getValueFromString(String.valueOf(value));
    }

    @Override
    public Resource[] getValueFromString(String text) {
        String pattern = this.resolvePath(text).trim();
        try {
            return this.resourcePatternResolver.getResources(pattern);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Could not resolve resource location pattern [" + pattern + "]: " + ex.getMessage());
        }
    }
}

