/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager;

import android.content.Context;
import android.graphics.Rect;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChildViewsIterable;
import com.beloo.widget.chipslayoutmanager.DisappearingViewsManager;
import com.beloo.widget.chipslayoutmanager.HorizontalScrollingController;
import com.beloo.widget.chipslayoutmanager.IChipsLayoutManagerContract;
import com.beloo.widget.chipslayoutmanager.IDisappearingViewsManager;
import com.beloo.widget.chipslayoutmanager.IScrollingController;
import com.beloo.widget.chipslayoutmanager.IStateHolder;
import com.beloo.widget.chipslayoutmanager.Orientation;
import com.beloo.widget.chipslayoutmanager.ParcelableContainer;
import com.beloo.widget.chipslayoutmanager.ScrollingController;
import com.beloo.widget.chipslayoutmanager.VerticalScrollingController;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.anchor.IAnchorFactory;
import com.beloo.widget.chipslayoutmanager.cache.IViewCacheStorage;
import com.beloo.widget.chipslayoutmanager.cache.ViewCacheFactory;
import com.beloo.widget.chipslayoutmanager.gravity.CenterChildGravity;
import com.beloo.widget.chipslayoutmanager.gravity.CustomGravityResolver;
import com.beloo.widget.chipslayoutmanager.gravity.IChildGravityResolver;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractPositionIterator;
import com.beloo.widget.chipslayoutmanager.layouter.ColumnsStateFactory;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouter;
import com.beloo.widget.chipslayoutmanager.layouter.IMeasureSupporter;
import com.beloo.widget.chipslayoutmanager.layouter.IStateFactory;
import com.beloo.widget.chipslayoutmanager.layouter.LayouterFactory;
import com.beloo.widget.chipslayoutmanager.layouter.MeasureSupporter;
import com.beloo.widget.chipslayoutmanager.layouter.RowsStateFactory;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.EmptyRowBreaker;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.IRowBreaker;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.AbstractCriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.InfiniteCriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.placer.PlacerFactory;
import com.beloo.widget.chipslayoutmanager.util.AssertionUtils;
import com.beloo.widget.chipslayoutmanager.util.LayoutManagerUtil;
import com.beloo.widget.chipslayoutmanager.util.log.IFillLogger;
import com.beloo.widget.chipslayoutmanager.util.log.Log;
import com.beloo.widget.chipslayoutmanager.util.log.LoggerFactory;
import com.beloo.widget.chipslayoutmanager.util.testing.EmptySpy;
import com.beloo.widget.chipslayoutmanager.util.testing.ISpy;
import java.util.Locale;

public class ChipsLayoutManager
extends RecyclerView.LayoutManager
implements IChipsLayoutManagerContract,
IStateHolder,
ScrollingController.IScrollerListener {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int STRATEGY_DEFAULT = 1;
    public static final int STRATEGY_FILL_VIEW = 2;
    public static final int STRATEGY_FILL_SPACE = 4;
    public static final int STRATEGY_CENTER = 5;
    public static final int STRATEGY_CENTER_DENSE = 6;
    private static final String TAG = ChipsLayoutManager.class.getSimpleName();
    private static final int INT_ROW_SIZE_APPROXIMATELY_FOR_CACHE = 10;
    private static final int APPROXIMATE_ADDITIONAL_ROWS_COUNT = 5;
    private static final float FAST_SCROLLING_COEFFICIENT = 2.0f;
    private ICanvas canvas;
    private IDisappearingViewsManager disappearingViewsManager;
    private ChildViewsIterable childViews = new ChildViewsIterable(this);
    private SparseArray<View> childViewPositions = new SparseArray();
    private IChildGravityResolver childGravityResolver;
    private boolean isScrollingEnabledContract = true;
    private Integer maxViewsInRow = null;
    private IRowBreaker rowBreaker = new EmptyRowBreaker();
    @Orientation
    private int layoutOrientation = 1;
    private int rowStrategy = 1;
    private boolean isStrategyAppliedWithLastRow;
    private boolean isSmoothScrollbarEnabled = false;
    private IViewCacheStorage viewPositionsStorage;
    @Nullable
    private Integer cacheNormalizationPosition = null;
    private SparseArray<View> viewCache = new SparseArray();
    private ParcelableContainer container = new ParcelableContainer();
    private IFillLogger logger;
    private boolean isLayoutRTL = false;
    private int orientation;
    private AnchorViewState anchorView;
    private IStateFactory stateFactory;
    private IMeasureSupporter measureSupporter;
    private IAnchorFactory anchorFactory;
    private IScrollingController scrollingController;
    private PlacerFactory placerFactory = new PlacerFactory(this);
    private ISpy spy = new EmptySpy();
    private boolean isAfterPreLayout;

    @VisibleForTesting
    ChipsLayoutManager(Context context) {
        int orientation;
        this.orientation = orientation = context.getResources().getConfiguration().orientation;
        LoggerFactory loggerFactory = new LoggerFactory();
        this.logger = loggerFactory.getFillLogger(this.viewCache);
        this.viewPositionsStorage = new ViewCacheFactory(this).createCacheStorage();
        this.measureSupporter = new MeasureSupporter(this);
        this.setAutoMeasureEnabled(true);
    }

    public static Builder newBuilder(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("you have passed null context to builder");
        }
        return new ChipsLayoutManager(context).new StrategyBuilder();
    }

    public IChildGravityResolver getChildGravityResolver() {
        return this.childGravityResolver;
    }

    @Override
    public void setScrollingEnabledContract(boolean isEnabled) {
        this.isScrollingEnabledContract = isEnabled;
    }

    @Override
    public boolean isScrollingEnabledContract() {
        return this.isScrollingEnabledContract;
    }

    @Override
    public void setMaxViewsInRow(@IntRange(from=1L) Integer maxViewsInRow) {
        if (maxViewsInRow < 1) {
            throw new IllegalArgumentException("maxViewsInRow should be positive, but is = " + maxViewsInRow);
        }
        this.maxViewsInRow = maxViewsInRow;
        this.onRuntimeLayoutChanges();
    }

    private void onRuntimeLayoutChanges() {
        this.cacheNormalizationPosition = 0;
        this.viewPositionsStorage.purge();
        this.requestLayoutWithAnimations();
    }

    @Override
    public Integer getMaxViewsInRow() {
        return this.maxViewsInRow;
    }

    @Override
    public IRowBreaker getRowBreaker() {
        return this.rowBreaker;
    }

    @Override
    public int getRowStrategyType() {
        return this.rowStrategy;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isStrategyAppliedWithLastRow() {
        return this.isStrategyAppliedWithLastRow;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public IViewCacheStorage getViewPositionsStorage() {
        return this.viewPositionsStorage;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ICanvas getCanvas() {
        return this.canvas;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    AnchorViewState getAnchor() {
        return this.anchorView;
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void setSpy(ISpy spy) {
        this.spy = spy;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new RecyclerView.LayoutParams(-2, -2);
    }

    private void requestLayoutWithAnimations() {
        LayoutManagerUtil.requestLayoutWithAnimations(this);
    }

    public void onRestoreInstanceState(Parcelable state) {
        this.container = (ParcelableContainer)state;
        this.anchorView = this.container.getAnchorViewState();
        if (this.orientation != this.container.getOrientation()) {
            int anchorPos = this.anchorView.getPosition();
            this.anchorView = this.anchorFactory.createNotFound();
            this.anchorView.setPosition(anchorPos);
        }
        this.viewPositionsStorage.onRestoreInstanceState(this.container.getPositionsCache(this.orientation));
        this.cacheNormalizationPosition = this.container.getNormalizationPosition(this.orientation);
        Log.d(TAG, "RESTORE. last cache position before cleanup = " + this.viewPositionsStorage.getLastCachePosition());
        if (this.cacheNormalizationPosition != null) {
            this.viewPositionsStorage.purgeCacheFromPosition(this.cacheNormalizationPosition);
        }
        this.viewPositionsStorage.purgeCacheFromPosition(this.anchorView.getPosition());
        Log.d(TAG, "RESTORE. anchor position =" + this.anchorView.getPosition());
        Log.d(TAG, "RESTORE. layoutOrientation = " + this.orientation + " normalizationPos = " + this.cacheNormalizationPosition);
        Log.d(TAG, "RESTORE. last cache position = " + this.viewPositionsStorage.getLastCachePosition());
    }

    public Parcelable onSaveInstanceState() {
        this.container.putAnchorViewState(this.anchorView);
        this.container.putPositionsCache(this.orientation, this.viewPositionsStorage.onSaveInstanceState());
        this.container.putOrientation(this.orientation);
        Log.d(TAG, "STORE. last cache position =" + this.viewPositionsStorage.getLastCachePosition());
        Integer storedNormalizationPosition = this.cacheNormalizationPosition != null ? this.cacheNormalizationPosition : this.viewPositionsStorage.getLastCachePosition();
        Log.d(TAG, "STORE. layoutOrientation = " + this.orientation + " normalizationPos = " + storedNormalizationPosition);
        this.container.putNormalizationPosition(this.orientation, storedNormalizationPosition);
        return this.container;
    }

    public boolean supportsPredictiveItemAnimations() {
        return true;
    }

    public int getCompletelyVisibleViewsCount() {
        int visibleViewsCount = 0;
        for (View child : this.childViews) {
            if (!this.canvas.isFullyVisible(child)) continue;
            ++visibleViewsCount;
        }
        return visibleViewsCount;
    }

    @Override
    public int findFirstVisibleItemPosition() {
        if (this.getChildCount() == 0) {
            return -1;
        }
        return this.canvas.getMinPositionOnScreen();
    }

    @Override
    public int findFirstCompletelyVisibleItemPosition() {
        for (View view : this.childViews) {
            Rect rect = this.canvas.getViewRect(view);
            if (!this.canvas.isFullyVisible(rect) || !this.canvas.isInside(rect)) continue;
            return this.getPosition(view);
        }
        return -1;
    }

    @Override
    public int findLastVisibleItemPosition() {
        if (this.getChildCount() == 0) {
            return -1;
        }
        return this.canvas.getMaxPositionOnScreen();
    }

    @Override
    public int findLastCompletelyVisibleItemPosition() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            Rect rect = this.canvas.getViewRect(view);
            if (!this.canvas.isFullyVisible(rect) || !this.canvas.isInside(view)) continue;
            return this.getPosition(view);
        }
        return -1;
    }

    @Nullable
    View getChildWithPosition(int position) {
        return (View)this.childViewPositions.get(position);
    }

    @Override
    public boolean isLayoutRTL() {
        return this.getLayoutDirection() == 1;
    }

    @Override
    @Orientation
    public int layoutOrientation() {
        return this.layoutOrientation;
    }

    public int getItemCount() {
        return super.getItemCount() + this.disappearingViewsManager.getDeletingItemsOnScreenCount();
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.spy.onLayoutChildren(recycler, state);
        Log.d(TAG, "onLayoutChildren. State =" + state);
        if (this.getItemCount() == 0) {
            this.detachAndScrapAttachedViews(recycler);
            return;
        }
        Log.i("onLayoutChildren", "isPreLayout = " + state.isPreLayout(), 4);
        if (this.isLayoutRTL() != this.isLayoutRTL) {
            this.isLayoutRTL = this.isLayoutRTL();
            this.detachAndScrapAttachedViews(recycler);
        }
        this.calcRecyclerCacheSize(recycler);
        if (state.isPreLayout()) {
            int additionalLength = this.disappearingViewsManager.calcDisappearingViewsLength(recycler);
            Log.d("LayoutManager", "height =" + this.getHeight(), 4);
            Log.d("onDeletingHeightCalc", "additional height  = " + additionalLength, 4);
            this.anchorView = this.anchorFactory.getAnchor();
            this.anchorFactory.resetRowCoordinates(this.anchorView);
            Log.w(TAG, "anchor state in pre-layout = " + this.anchorView);
            this.detachAndScrapAttachedViews(recycler);
            AbstractCriteriaFactory criteriaFactory = this.stateFactory.createDefaultFinishingCriteriaFactory();
            criteriaFactory.setAdditionalRowsCount(5);
            criteriaFactory.setAdditionalLength(additionalLength);
            LayouterFactory layouterFactory = this.stateFactory.createLayouterFactory(criteriaFactory, this.placerFactory.createRealPlacerFactory());
            this.logger.onBeforeLayouter(this.anchorView);
            this.fill(recycler, layouterFactory.getBackwardLayouter(this.anchorView), layouterFactory.getForwardLayouter(this.anchorView));
            this.isAfterPreLayout = true;
        } else {
            this.detachAndScrapAttachedViews(recycler);
            this.viewPositionsStorage.purgeCacheFromPosition(this.anchorView.getPosition());
            if (this.cacheNormalizationPosition != null && this.anchorView.getPosition() <= this.cacheNormalizationPosition) {
                this.cacheNormalizationPosition = null;
            }
            AbstractCriteriaFactory criteriaFactory = this.stateFactory.createDefaultFinishingCriteriaFactory();
            criteriaFactory.setAdditionalRowsCount(5);
            LayouterFactory layouterFactory = this.stateFactory.createLayouterFactory(criteriaFactory, this.placerFactory.createRealPlacerFactory());
            ILayouter backwardLayouter = layouterFactory.getBackwardLayouter(this.anchorView);
            ILayouter forwardLayouter = layouterFactory.getForwardLayouter(this.anchorView);
            this.fill(recycler, backwardLayouter, forwardLayouter);
            if (this.scrollingController.normalizeGaps(recycler, null)) {
                Log.d(TAG, "normalize gaps");
                this.anchorView = this.anchorFactory.getAnchor();
                this.requestLayoutWithAnimations();
            }
            if (this.isAfterPreLayout) {
                this.layoutDisappearingViews(recycler, backwardLayouter, forwardLayouter);
            }
            this.isAfterPreLayout = false;
        }
        this.disappearingViewsManager.reset();
        if (!state.isMeasuring()) {
            this.measureSupporter.onSizeChanged();
        }
    }

    public void detachAndScrapAttachedViews(RecyclerView.Recycler recycler) {
        super.detachAndScrapAttachedViews(recycler);
        this.childViewPositions.clear();
    }

    private void layoutDisappearingViews(RecyclerView.Recycler recycler, @NonNull ILayouter upLayouter, ILayouter downLayouter) {
        InfiniteCriteriaFactory criteriaFactory = new InfiniteCriteriaFactory();
        LayouterFactory layouterFactory = this.stateFactory.createLayouterFactory(criteriaFactory, this.placerFactory.createDisappearingPlacerFactory());
        DisappearingViewsManager.DisappearingViewsContainer disappearingViews = this.disappearingViewsManager.getDisappearingViews(recycler);
        if (disappearingViews.size() > 0) {
            int position;
            int i;
            Log.d("disappearing views", "count = " + disappearingViews.size());
            Log.d("fill disappearing views", "");
            downLayouter = layouterFactory.buildForwardLayouter(downLayouter);
            for (i = 0; i < disappearingViews.getForwardViews().size(); ++i) {
                position = disappearingViews.getForwardViews().keyAt(i);
                downLayouter.placeView(recycler.getViewForPosition(position));
            }
            downLayouter.layoutRow();
            upLayouter = layouterFactory.buildBackwardLayouter(upLayouter);
            for (i = 0; i < disappearingViews.getBackwardViews().size(); ++i) {
                position = disappearingViews.getBackwardViews().keyAt(i);
                upLayouter.placeView(recycler.getViewForPosition(position));
            }
            upLayouter.layoutRow();
        }
    }

    private void fillCache() {
        int cnt = this.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            View view = this.getChildAt(i);
            int pos = this.getPosition(view);
            this.viewCache.put(pos, (Object)view);
        }
    }

    private void fill(RecyclerView.Recycler recycler, ILayouter backwardLayouter, ILayouter forwardLayouter) {
        int i;
        int startingPos = this.anchorView.getPosition();
        this.fillCache();
        for (i = 0; i < this.viewCache.size(); ++i) {
            this.detachView((View)this.viewCache.valueAt(i));
        }
        this.logger.onStartLayouter(startingPos - 1);
        if (this.anchorView.getAnchorViewRect() != null) {
            this.fillWithLayouter(recycler, backwardLayouter, startingPos - 1);
        }
        this.logger.onStartLayouter(startingPos);
        this.fillWithLayouter(recycler, forwardLayouter, startingPos);
        this.logger.onAfterLayouter();
        for (i = 0; i < this.viewCache.size(); ++i) {
            this.removeAndRecycleView((View)this.viewCache.valueAt(i), recycler);
            this.logger.onRemovedAndRecycled(i);
        }
        this.canvas.findBorderViews();
        this.buildChildWithPositionsMap();
        this.viewCache.clear();
        this.logger.onAfterRemovingViews();
    }

    private void buildChildWithPositionsMap() {
        this.childViewPositions.clear();
        for (View view : this.childViews) {
            int position = this.getPosition(view);
            this.childViewPositions.put(position, (Object)view);
        }
    }

    private void fillWithLayouter(RecyclerView.Recycler recycler, ILayouter layouter, int startingPos) {
        if (startingPos < 0) {
            return;
        }
        AbstractPositionIterator iterator = layouter.positionIterator();
        iterator.move(startingPos);
        while (iterator.hasNext()) {
            int pos = (Integer)iterator.next();
            View view = (View)this.viewCache.get(pos);
            if (view == null) {
                try {
                    view = recycler.getViewForPosition(pos);
                }
                catch (IndexOutOfBoundsException e) {
                    break;
                }
                this.logger.onItemRequested();
                if (layouter.placeView(view)) continue;
                recycler.recycleView(view);
                this.logger.onItemRecycled();
                break;
            }
            if (!layouter.onAttachView(view)) break;
            this.viewCache.remove(pos);
        }
        this.logger.onFinishedLayouter();
        layouter.layoutRow();
    }

    private void calcRecyclerCacheSize(RecyclerView.Recycler recycler) {
        int viewsInRow = this.maxViewsInRow == null ? 10 : this.maxViewsInRow;
        recycler.setViewCacheSize((int)((float)viewsInRow * 2.0f));
    }

    private void performNormalizationIfNeeded() {
        View firstView;
        int firstViewPosition;
        if (this.cacheNormalizationPosition != null && this.getChildCount() > 0 && ((firstViewPosition = this.getPosition(firstView = this.getChildAt(0))) < this.cacheNormalizationPosition || this.cacheNormalizationPosition == 0 && this.cacheNormalizationPosition == firstViewPosition)) {
            Log.d("normalization", "position = " + this.cacheNormalizationPosition + " top view position = " + firstViewPosition);
            Log.d(TAG, "cache purged from position " + firstViewPosition);
            this.viewPositionsStorage.purgeCacheFromPosition(firstViewPosition);
            this.cacheNormalizationPosition = null;
            this.requestLayoutWithAnimations();
        }
    }

    public void setMeasuredDimension(int widthSize, int heightSize) {
        this.measureSupporter.measure(widthSize, heightSize);
        Log.i(TAG, "measured dimension = " + heightSize);
        super.setMeasuredDimension(this.measureSupporter.getMeasuredWidth(), this.measureSupporter.getMeasuredHeight());
    }

    public void onAdapterChanged(RecyclerView.Adapter oldAdapter, RecyclerView.Adapter newAdapter) {
        if (oldAdapter != null && this.measureSupporter.isRegistered()) {
            try {
                this.measureSupporter.setRegistered(false);
                oldAdapter.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.measureSupporter);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (newAdapter != null) {
            this.measureSupporter.setRegistered(true);
            newAdapter.registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.measureSupporter);
        }
        this.removeAllViews();
    }

    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        Log.d("onItemsRemoved", "starts from = " + positionStart + ", item count = " + itemCount, 1);
        super.onItemsRemoved(recyclerView, positionStart, itemCount);
        this.onLayoutUpdatedFromPosition(positionStart);
        this.measureSupporter.onItemsRemoved(recyclerView);
    }

    public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        Log.d("onItemsAdded", "starts from = " + positionStart + ", item count = " + itemCount, 1);
        super.onItemsAdded(recyclerView, positionStart, itemCount);
        this.onLayoutUpdatedFromPosition(positionStart);
    }

    public void onItemsChanged(RecyclerView recyclerView) {
        Log.d("onItemsChanged", "", 1);
        super.onItemsChanged(recyclerView);
        this.viewPositionsStorage.purge();
        this.onLayoutUpdatedFromPosition(0);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount) {
        Log.d("onItemsUpdated", "starts from = " + positionStart + ", item count = " + itemCount, 1);
        super.onItemsUpdated(recyclerView, positionStart, itemCount);
        this.onLayoutUpdatedFromPosition(positionStart);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount, Object payload) {
        this.onItemsUpdated(recyclerView, positionStart, itemCount);
    }

    public void onItemsMoved(RecyclerView recyclerView, int from, int to, int itemCount) {
        Log.d("onItemsMoved", String.format(Locale.US, "from = %d, to = %d, itemCount = %d", from, to, itemCount), 1);
        super.onItemsMoved(recyclerView, from, to, itemCount);
        this.onLayoutUpdatedFromPosition(Math.min(from, to));
    }

    private void onLayoutUpdatedFromPosition(int position) {
        Log.d(TAG, "cache purged from position " + position);
        this.viewPositionsStorage.purgeCacheFromPosition(position);
        int startRowPos = this.viewPositionsStorage.getStartOfRow(position);
        this.cacheNormalizationPosition = this.cacheNormalizationPosition == null ? startRowPos : Math.min(this.cacheNormalizationPosition, startRowPos);
    }

    @Override
    public void setSmoothScrollbarEnabled(boolean enabled) {
        this.isSmoothScrollbarEnabled = enabled;
    }

    @Override
    public boolean isSmoothScrollbarEnabled() {
        return this.isSmoothScrollbarEnabled;
    }

    public void scrollToPosition(int position) {
        if (position >= this.getItemCount() || position < 0) {
            Log.e("span layout manager", "Cannot scroll to " + position + ", item count " + this.getItemCount());
            return;
        }
        Integer lastCachePosition = this.viewPositionsStorage.getLastCachePosition();
        Integer n = this.cacheNormalizationPosition = this.cacheNormalizationPosition != null ? this.cacheNormalizationPosition : lastCachePosition;
        if (lastCachePosition != null && position < lastCachePosition) {
            position = this.viewPositionsStorage.getStartOfRow(position);
        }
        this.anchorView = this.anchorFactory.createNotFound();
        this.anchorView.setPosition(position);
        super.requestLayout();
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int position) {
        if (position >= this.getItemCount() || position < 0) {
            Log.e("span layout manager", "Cannot scroll to " + position + ", item count " + this.getItemCount());
            return;
        }
        RecyclerView.SmoothScroller scroller = this.scrollingController.createSmoothScroller(recyclerView.getContext(), position, 150, this.anchorView);
        scroller.setTargetPosition(position);
        this.startSmoothScroll(scroller);
    }

    public boolean canScrollHorizontally() {
        return this.scrollingController.canScrollHorizontally();
    }

    public boolean canScrollVertically() {
        return this.scrollingController.canScrollVertically();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.scrollingController.scrollVerticallyBy(dy, recycler, state);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.scrollingController.scrollHorizontallyBy(dx, recycler, state);
    }

    public VerticalScrollingController verticalScrollingController() {
        return new VerticalScrollingController(this, this.stateFactory, this);
    }

    public HorizontalScrollingController horizontalScrollingController() {
        return new HorizontalScrollingController(this, this.stateFactory, this);
    }

    @Override
    public void onScrolled(IScrollingController scrollingController, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.performNormalizationIfNeeded();
        this.anchorView = this.anchorFactory.getAnchor();
        AbstractCriteriaFactory criteriaFactory = this.stateFactory.createDefaultFinishingCriteriaFactory();
        criteriaFactory.setAdditionalRowsCount(1);
        LayouterFactory factory = this.stateFactory.createLayouterFactory(criteriaFactory, this.placerFactory.createRealPlacerFactory());
        this.fill(recycler, factory.getBackwardLayouter(this.anchorView), factory.getForwardLayouter(this.anchorView));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeVerticalScrollOffset(RecyclerView.State state) {
        return this.scrollingController.computeVerticalScrollOffset(state);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeVerticalScrollExtent(RecyclerView.State state) {
        return this.scrollingController.computeVerticalScrollExtent(state);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeVerticalScrollRange(RecyclerView.State state) {
        return this.scrollingController.computeVerticalScrollRange(state);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeHorizontalScrollExtent(RecyclerView.State state) {
        return this.scrollingController.computeHorizontalScrollExtent(state);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeHorizontalScrollOffset(RecyclerView.State state) {
        return this.scrollingController.computeHorizontalScrollOffset(state);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int computeHorizontalScrollRange(RecyclerView.State state) {
        return this.scrollingController.computeHorizontalScrollRange(state);
    }

    public class Builder {
        private Integer gravity;

        private Builder() {
        }

        public Builder setChildGravity(int gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder setGravityResolver(@NonNull IChildGravityResolver gravityResolver) {
            AssertionUtils.assertNotNull(gravityResolver, "gravity resolver couldn't be null");
            ChipsLayoutManager.this.childGravityResolver = gravityResolver;
            return this;
        }

        public Builder setScrollingEnabled(boolean isEnabled) {
            ChipsLayoutManager.this.setScrollingEnabledContract(isEnabled);
            return this;
        }

        public StrategyBuilder setRowStrategy(int rowStrategy) {
            ChipsLayoutManager.this.rowStrategy = rowStrategy;
            return (StrategyBuilder)this;
        }

        public Builder setMaxViewsInRow(@IntRange(from=1L) int maxViewsInRow) {
            if (maxViewsInRow < 1) {
                throw new IllegalArgumentException("maxViewsInRow should be positive, but is = " + maxViewsInRow);
            }
            ChipsLayoutManager.this.maxViewsInRow = maxViewsInRow;
            return this;
        }

        public Builder setRowBreaker(@NonNull IRowBreaker breaker) {
            AssertionUtils.assertNotNull(breaker, "breaker couldn't be null");
            ChipsLayoutManager.this.rowBreaker = breaker;
            return this;
        }

        public Builder setOrientation(@Orientation int orientation) {
            if (orientation != 1 && orientation != 2) {
                return this;
            }
            ChipsLayoutManager.this.layoutOrientation = orientation;
            return this;
        }

        public ChipsLayoutManager build() {
            if (ChipsLayoutManager.this.childGravityResolver == null) {
                if (this.gravity != null) {
                    ChipsLayoutManager.this.childGravityResolver = new CustomGravityResolver(this.gravity);
                } else {
                    ChipsLayoutManager.this.childGravityResolver = new CenterChildGravity();
                }
            }
            ChipsLayoutManager.this.stateFactory = ChipsLayoutManager.this.layoutOrientation == 1 ? new RowsStateFactory(ChipsLayoutManager.this) : new ColumnsStateFactory(ChipsLayoutManager.this);
            ChipsLayoutManager.this.canvas = ChipsLayoutManager.this.stateFactory.createCanvas();
            ChipsLayoutManager.this.anchorFactory = ChipsLayoutManager.this.stateFactory.anchorFactory();
            ChipsLayoutManager.this.scrollingController = ChipsLayoutManager.this.stateFactory.scrollingController();
            ChipsLayoutManager.this.anchorView = ChipsLayoutManager.this.anchorFactory.createNotFound();
            ChipsLayoutManager.this.disappearingViewsManager = new DisappearingViewsManager(ChipsLayoutManager.this.canvas, ChipsLayoutManager.this.childViews, ChipsLayoutManager.this.stateFactory);
            return ChipsLayoutManager.this;
        }
    }

    public class StrategyBuilder
    extends Builder {
        public Builder withLastRow(boolean withLastRow) {
            ChipsLayoutManager.this.isStrategyAppliedWithLastRow = withLastRow;
            return this;
        }
    }
}

