/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChipsLayoutManager;
import com.beloo.widget.chipslayoutmanager.IScrollingController;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;
import com.beloo.widget.chipslayoutmanager.layouter.IStateFactory;

abstract class ScrollingController
implements IScrollingController {
    private ChipsLayoutManager lm;
    private IScrollerListener scrollerListener;
    private IStateFactory stateFactory;
    ICanvas canvas;

    ScrollingController(ChipsLayoutManager layoutManager, IStateFactory stateFactory, IScrollerListener scrollerListener) {
        this.lm = layoutManager;
        this.scrollerListener = scrollerListener;
        this.stateFactory = stateFactory;
        this.canvas = layoutManager.getCanvas();
    }

    final int calculateEndGap() {
        if (this.lm.getChildCount() == 0) {
            return 0;
        }
        int visibleViewsCount = this.lm.getCompletelyVisibleViewsCount();
        if (visibleViewsCount == this.lm.getItemCount()) {
            return 0;
        }
        int currentEnd = this.stateFactory.getEndViewBound();
        int desiredEnd = this.stateFactory.getEndAfterPadding();
        int diff = desiredEnd - currentEnd;
        if (diff < 0) {
            return 0;
        }
        return diff;
    }

    final int calculateStartGap() {
        int desiredStart;
        if (this.lm.getChildCount() == 0) {
            return 0;
        }
        int currentStart = this.stateFactory.getStartViewBound();
        int diff = currentStart - (desiredStart = this.stateFactory.getStartAfterPadding());
        if (diff < 0) {
            return 0;
        }
        return diff;
    }

    @Override
    public final boolean normalizeGaps(RecyclerView.Recycler recycler, RecyclerView.State state) {
        int backwardGap = this.calculateStartGap();
        if (backwardGap > 0) {
            this.offsetChildren(-backwardGap);
            return true;
        }
        int forwardGap = this.calculateEndGap();
        if (forwardGap > 0) {
            this.scrollBy(-forwardGap, recycler, state);
            return true;
        }
        return false;
    }

    final int calcOffset(int d) {
        int childCount = this.lm.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        int delta = 0;
        if (d < 0) {
            delta = this.onContentScrolledBackward(d);
        } else if (d > 0) {
            delta = this.onContentScrolledForward(d);
        }
        return delta;
    }

    final int onContentScrolledBackward(int d) {
        int delta;
        AnchorViewState anchor = this.lm.getAnchor();
        if (anchor.getAnchorViewRect() == null) {
            return 0;
        }
        if (anchor.getPosition() != 0) {
            delta = d;
        } else {
            int startBorder = this.stateFactory.getStartAfterPadding();
            int viewStart = this.stateFactory.getStart(anchor);
            int distance = viewStart - startBorder;
            delta = distance >= 0 ? distance : Math.max(distance, d);
        }
        return delta;
    }

    final int onContentScrolledForward(int d) {
        int delta;
        int childCount = this.lm.getChildCount();
        int itemCount = this.lm.getItemCount();
        View lastView = this.lm.getChildAt(childCount - 1);
        int lastViewAdapterPos = this.lm.getPosition(lastView);
        if (lastViewAdapterPos < itemCount - 1) {
            delta = d;
        } else {
            int viewEnd = this.stateFactory.getEndViewBound();
            int parentEnd = this.stateFactory.getEndAfterPadding();
            delta = Math.min(viewEnd - parentEnd, d);
        }
        return delta;
    }

    abstract void offsetChildren(int var1);

    @Override
    public final int scrollHorizontallyBy(int d, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.canScrollHorizontally() ? this.scrollBy(d, recycler, state) : 0;
    }

    @Override
    public final int scrollVerticallyBy(int d, RecyclerView.Recycler recycler, RecyclerView.State state) {
        return this.canScrollVertically() ? this.scrollBy(d, recycler, state) : 0;
    }

    private int scrollBy(int d, RecyclerView.Recycler recycler, RecyclerView.State state) {
        d = this.calcOffset(d);
        this.offsetChildren(-d);
        this.scrollerListener.onScrolled(this, recycler, state);
        return d;
    }

    private int getLaidOutArea() {
        return this.stateFactory.getEndViewBound() - this.stateFactory.getStartViewBound();
    }

    private int computeScrollOffset(RecyclerView.State state) {
        if (this.lm.getChildCount() == 0 || state.getItemCount() == 0) {
            return 0;
        }
        int firstVisiblePos = this.lm.findFirstVisibleItemPosition();
        int lastVisiblePos = this.lm.findLastVisibleItemPosition();
        int itemsBefore = Math.max(0, firstVisiblePos);
        if (!this.lm.isSmoothScrollbarEnabled()) {
            return itemsBefore;
        }
        int itemRange = Math.abs(firstVisiblePos - lastVisiblePos) + 1;
        float avgSizePerRow = (float)this.getLaidOutArea() / (float)itemRange;
        return Math.round((float)itemsBefore * avgSizePerRow + (float)(this.stateFactory.getStartAfterPadding() - this.stateFactory.getStartViewBound()));
    }

    private int computeScrollExtent(RecyclerView.State state) {
        if (this.lm.getChildCount() == 0 || state.getItemCount() == 0) {
            return 0;
        }
        int firstVisiblePos = this.lm.findFirstVisibleItemPosition();
        int lastVisiblePos = this.lm.findLastVisibleItemPosition();
        if (!this.lm.isSmoothScrollbarEnabled()) {
            return Math.abs(lastVisiblePos - firstVisiblePos) + 1;
        }
        return Math.min(this.stateFactory.getTotalSpace(), this.getLaidOutArea());
    }

    private int computeScrollRange(RecyclerView.State state) {
        if (this.lm.getChildCount() == 0 || state.getItemCount() == 0) {
            return 0;
        }
        if (!this.lm.isSmoothScrollbarEnabled()) {
            return state.getItemCount();
        }
        int firstVisiblePos = this.lm.findFirstVisibleItemPosition();
        int lastVisiblePos = this.lm.findLastVisibleItemPosition();
        int laidOutRange = Math.abs(firstVisiblePos - lastVisiblePos) + 1;
        return (int)((float)this.getLaidOutArea() / (float)laidOutRange * (float)state.getItemCount());
    }

    @Override
    public final int computeVerticalScrollExtent(RecyclerView.State state) {
        return this.canScrollVertically() ? this.computeScrollExtent(state) : 0;
    }

    @Override
    public final int computeVerticalScrollRange(RecyclerView.State state) {
        return this.canScrollVertically() ? this.computeScrollRange(state) : 0;
    }

    @Override
    public final int computeVerticalScrollOffset(RecyclerView.State state) {
        return this.canScrollVertically() ? this.computeScrollOffset(state) : 0;
    }

    @Override
    public final int computeHorizontalScrollRange(RecyclerView.State state) {
        return this.canScrollHorizontally() ? this.computeScrollRange(state) : 0;
    }

    @Override
    public final int computeHorizontalScrollOffset(RecyclerView.State state) {
        return this.canScrollHorizontally() ? this.computeScrollOffset(state) : 0;
    }

    @Override
    public final int computeHorizontalScrollExtent(RecyclerView.State state) {
        return this.canScrollHorizontally() ? this.computeScrollExtent(state) : 0;
    }

    static interface IScrollerListener {
        public void onScrolled(IScrollingController var1, RecyclerView.Recycler var2, RecyclerView.State var3);
    }
}

