/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.util.Pair;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractLayouter;

class LeftLayouter
extends AbstractLayouter {
    private LeftLayouter(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    Rect createViewRect(View view) {
        int left = this.viewRight - this.getCurrentViewWidth();
        int viewTop = this.viewBottom - this.getCurrentViewHeight();
        Rect viewRect = new Rect(left, viewTop, this.viewRight, this.viewBottom);
        this.viewBottom = viewRect.top;
        return viewRect;
    }

    @Override
    boolean isReverseOrder() {
        return true;
    }

    @Override
    void onPreLayout() {
        int topOffsetOfRow = this.viewBottom - this.getCanvasTopBorder();
        this.viewBottom = 0;
        for (Pair columnViewRectPair : this.rowViews) {
            Rect viewRect = (Rect)columnViewRectPair.first;
            viewRect.top -= topOffsetOfRow;
            viewRect.bottom -= topOffsetOfRow;
            this.viewBottom = Math.max(this.viewBottom, viewRect.bottom);
            this.viewLeft = Math.min(this.viewLeft, viewRect.left);
            this.viewRight = Math.max(this.viewRight, viewRect.right);
        }
    }

    @Override
    void onAfterLayout() {
        this.viewBottom = this.getCanvasBottomBorder();
        this.viewRight = this.viewLeft;
    }

    @Override
    boolean isAttachedViewFromNewRow(View view) {
        int bottomOfCurrentView = this.getLayoutManager().getDecoratedBottom(view);
        int rightOfCurrentView = this.getLayoutManager().getDecoratedRight(view);
        return this.viewLeft >= rightOfCurrentView && bottomOfCurrentView > this.viewBottom;
    }

    @Override
    void onInterceptAttachView(View view) {
        if (this.viewBottom != this.getCanvasBottomBorder() && this.viewBottom - this.getCurrentViewHeight() < this.getCanvasTopBorder()) {
            this.viewBottom = this.getCanvasBottomBorder();
            this.viewRight = this.viewLeft;
        } else {
            this.viewBottom = this.getLayoutManager().getDecoratedTop(view);
        }
        this.viewLeft = Math.min(this.viewLeft, this.getLayoutManager().getDecoratedLeft(view));
    }

    @Override
    public int getStartRowBorder() {
        return this.getViewLeft();
    }

    @Override
    public int getEndRowBorder() {
        return this.getViewRight();
    }

    @Override
    public int getRowLength() {
        return this.viewBottom - this.getCanvasTopBorder();
    }

    public static final class Builder
    extends AbstractLayouter.Builder {
        private Builder() {
        }

        @Override
        @NonNull
        public LeftLayouter createLayouter() {
            return new LeftLayouter(this);
        }
    }
}

