/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.util.Pair;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractLayouter;

class RTLDownLayouter
extends AbstractLayouter {
    private boolean isPurged;

    private RTLDownLayouter(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    void onPreLayout() {
        if (!this.rowViews.isEmpty()) {
            if (!this.isPurged) {
                this.isPurged = true;
                this.getCacheStorage().purgeCacheFromPosition(this.getLayoutManager().getPosition((View)((Pair)this.rowViews.get((int)0)).second));
            }
            this.getCacheStorage().storeRow(this.rowViews);
        }
    }

    @Override
    void onAfterLayout() {
        this.viewRight = this.getCanvasRightBorder();
        this.viewTop = this.viewBottom;
    }

    @Override
    boolean isAttachedViewFromNewRow(View view) {
        int topOfCurrentView = this.getLayoutManager().getDecoratedTop(view);
        int rightOfCurrentVIew = this.getLayoutManager().getDecoratedRight(view);
        return this.viewBottom <= topOfCurrentView && rightOfCurrentVIew > this.viewRight;
    }

    @Override
    Rect createViewRect(View view) {
        Rect viewRect = new Rect(this.viewRight - this.getCurrentViewWidth(), this.viewTop, this.viewRight, this.viewTop + this.getCurrentViewHeight());
        this.viewRight = viewRect.left;
        this.viewBottom = Math.max(this.viewBottom, viewRect.bottom);
        return viewRect;
    }

    @Override
    boolean isReverseOrder() {
        return false;
    }

    @Override
    public void onInterceptAttachView(View view) {
        this.viewTop = this.getLayoutManager().getDecoratedTop(view);
        this.viewRight = this.getLayoutManager().getDecoratedLeft(view);
        this.viewBottom = Math.max(this.viewBottom, this.getLayoutManager().getDecoratedBottom(view));
    }

    @Override
    public int getStartRowBorder() {
        return this.getViewTop();
    }

    @Override
    public int getEndRowBorder() {
        return this.getViewBottom();
    }

    @Override
    public int getRowLength() {
        return this.getCanvasRightBorder() - this.viewRight;
    }

    public static final class Builder
    extends AbstractLayouter.Builder {
        private Builder() {
        }

        @Override
        @NonNull
        public RTLDownLayouter createLayouter() {
            return new RTLDownLayouter(this);
        }
    }
}

