/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk;

import com.bimface.sdk.bean.request.FileUploadRequest;
import com.bimface.sdk.bean.request.OfflineDatabagRequest;
import com.bimface.sdk.bean.request.integrate.IntegrateRequest;
import com.bimface.sdk.bean.request.translate.TranslateRequest;
import com.bimface.sdk.bean.request.translate.TranslateSource;
import com.bimface.sdk.bean.response.AppendFileBean;
import com.bimface.sdk.bean.response.CategoryBean;
import com.bimface.sdk.bean.response.ElementsBean;
import com.bimface.sdk.bean.response.FileBean;
import com.bimface.sdk.bean.response.FloorTree;
import com.bimface.sdk.bean.response.IntegrateBean;
import com.bimface.sdk.bean.response.OfflineDatabagBean;
import com.bimface.sdk.bean.response.PropertyBean;
import com.bimface.sdk.bean.response.ShareLinkBean;
import com.bimface.sdk.bean.response.SpecialtyTree;
import com.bimface.sdk.bean.response.SupportFileBean;
import com.bimface.sdk.bean.response.TranslateBean;
import com.bimface.sdk.bean.response.TreeNode;
import com.bimface.sdk.bean.response.UploadPolicyBean;
import com.bimface.sdk.config.Config;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.config.authorization.AccessTokenStorage;
import com.bimface.sdk.config.authorization.Credential;
import com.bimface.sdk.config.authorization.DefaultAccessTokenStorage;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.service.CategoryTreeService;
import com.bimface.sdk.service.DownloadService;
import com.bimface.sdk.service.ElementService;
import com.bimface.sdk.service.IntegrateService;
import com.bimface.sdk.service.OfflineDatabagService;
import com.bimface.sdk.service.PropertyService;
import com.bimface.sdk.service.ShareLinkService;
import com.bimface.sdk.service.SignatureService;
import com.bimface.sdk.service.SupportFileService;
import com.bimface.sdk.service.TranslateService;
import com.bimface.sdk.service.UploadService;
import com.bimface.sdk.service.ViewTokenService;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BimfaceClient {
    private Credential credential;
    private Endpoint endpoint;
    private ServiceClient serviceClient;
    private AccessTokenService accessTokenService;
    private SupportFileService supportFileService;
    private UploadService uploadService;
    private TranslateService translateService;
    private ViewTokenService viewTokenService;
    private ShareLinkService shareLinkService;
    private PropertyService propertyService;
    private SignatureService signatureService;
    private DownloadService downloadService;
    private ElementService elementService;
    private CategoryTreeService categoryTreeService;
    private IntegrateService integrateService;
    private OfflineDatabagService offlineDatabagService;

    public BimfaceClient(String appKey, String appSecret) {
        this(appKey, appSecret, null, null, null);
    }

    public BimfaceClient(String appKey, String appSecret, Config config) {
        this(appKey, appSecret, null, config, null);
    }

    public BimfaceClient(String appKey, String appSecret, Endpoint endpoint, Config config) {
        this(appKey, appSecret, endpoint, config, null);
    }

    public BimfaceClient(String appKey, String appSecret, Endpoint endpoint, Config config, AccessTokenStorage accessTokenStorage) {
        this.credential = new Credential(appKey, appSecret);
        this.endpoint = endpoint == null ? new Endpoint() : endpoint;
        this.serviceClient = config == null ? new ServiceClient(new Config()) : new ServiceClient(config);
        AccessTokenStorage usedAccessTokenStorage = null;
        usedAccessTokenStorage = accessTokenStorage == null ? new DefaultAccessTokenStorage() : accessTokenStorage;
        this.accessTokenService = new AccessTokenService(this.serviceClient, this.endpoint, this.credential, usedAccessTokenStorage);
        this.supportFileService = new SupportFileService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.uploadService = new UploadService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.uploadService.setSupportFileService(this.supportFileService);
        this.translateService = new TranslateService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.viewTokenService = new ViewTokenService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.shareLinkService = new ShareLinkService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.propertyService = new PropertyService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.signatureService = new SignatureService(this.credential);
        this.downloadService = new DownloadService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.elementService = new ElementService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.categoryTreeService = new CategoryTreeService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.integrateService = new IntegrateService(this.serviceClient, this.endpoint, this.accessTokenService);
        this.offlineDatabagService = new OfflineDatabagService(this.serviceClient, this.endpoint, this.accessTokenService);
    }

    public SupportFileBean getSupport() throws BimfaceException {
        return this.supportFileService.getSupport();
    }

    public FileBean upload(FileUploadRequest fileUploadRequest) throws BimfaceException {
        return this.uploadService.upload(fileUploadRequest);
    }

    public FileBean upload(String name, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.upload(name, null, contentLength, inputStream);
    }

    public FileBean upload(String name, String sourceId, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.uploadService.upload(new FileUploadRequest(name, sourceId, contentLength, inputStream));
    }

    public FileBean upload(String name, String url) throws BimfaceException {
        return this.upload(name, null, url);
    }

    public FileBean upload(String name, String sourceId, String url) throws BimfaceException {
        return this.uploadService.upload(new FileUploadRequest(name, sourceId, url));
    }

    public FileBean getFileMetadata(Long fileId) throws BimfaceException {
        return this.uploadService.getFileMetadata(fileId);
    }

    public void deleteFile(Long fileId) throws BimfaceException {
        this.uploadService.deleteFile(fileId);
    }

    public UploadPolicyBean getPolicy(String name) throws BimfaceException {
        return this.getPolicy(name, null);
    }

    public UploadPolicyBean getPolicy(String name, String sourceId) throws BimfaceException {
        return this.uploadService.getPolicy(name, sourceId);
    }

    public FileBean uploadByPolicy(String name, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.uploadByPolicy(name, null, contentLength, inputStream);
    }

    public FileBean uploadByPolicy(String name, String sourceId, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.uploadService.uploadByPolicy(name, sourceId, contentLength, inputStream);
    }

    public String getDownloadUrl(Long fileId) throws BimfaceException {
        return this.downloadService.getDownloadUrl(fileId);
    }

    public String getDownloadUrl(Long fileId, String fileName) throws BimfaceException {
        return this.downloadService.getDownloadUrl(fileId, fileName);
    }

    public InputStream download(Long fileId, String fileName) throws BimfaceException {
        return this.downloadService.getFileContent(fileId, fileName);
    }

    @Deprecated
    public List<String> getElements(Long fileId, String categoryId, String family, String familyType) throws BimfaceException {
        return this.elementService.getElements(fileId, null, null, categoryId, family, familyType);
    }

    public List<String> getElements(Long fileId, String floor, String specialty, String categoryId, String family, String familyType) throws BimfaceException {
        return this.elementService.getElements(fileId, floor, specialty, categoryId, family, familyType);
    }

    public ElementsBean getIntegrationElements(Long integrateId, String floor, String specialty, String categoryId, String family, String familyType) throws BimfaceException {
        return this.elementService.getIntegrationElements(integrateId, floor, specialty, categoryId, family, familyType);
    }

    public TranslateBean translate(TranslateRequest fileTranslateRequest) throws BimfaceException {
        return this.translateService.translate(fileTranslateRequest);
    }

    public TranslateBean translate(Long fileId) throws BimfaceException {
        TranslateRequest fileTranslateRequest = new TranslateRequest();
        TranslateSource source = new TranslateSource();
        source.setFileId(fileId);
        fileTranslateRequest.setSource(source);
        return this.translateService.translate(fileTranslateRequest);
    }

    public TranslateBean translate(Long fileId, String callback) throws BimfaceException {
        TranslateRequest fileTranslateRequest = new TranslateRequest();
        fileTranslateRequest.setCallback(callback);
        TranslateSource source = new TranslateSource();
        source.setFileId(fileId);
        fileTranslateRequest.setSource(source);
        return this.translateService.translate(fileTranslateRequest);
    }

    public TranslateBean getTranslate(Long fileId) throws BimfaceException {
        return this.translateService.getTranslate(fileId);
    }

    @Deprecated
    public String getViewTokenByTransferId(String transferId) throws BimfaceException {
        return this.viewTokenService.grantViewTokenByTransferId(transferId);
    }

    public String getViewTokenByIntegrateId(Long integrateId) throws BimfaceException {
        return this.viewTokenService.grantViewTokenByIntegrateId(integrateId);
    }

    public String getViewTokenByFileId(Long fileId) throws BimfaceException {
        return this.viewTokenService.grantViewTokenByFileId(fileId);
    }

    public ShareLinkBean createShare(Long fileId, Integer activeHours) throws BimfaceException {
        return this.shareLinkService.createShare(fileId, activeHours);
    }

    public ShareLinkBean createShare(Long fileId) throws BimfaceException {
        return this.shareLinkService.createShare(fileId);
    }

    public void deleteShare(Long fileId) throws BimfaceException {
        this.shareLinkService.deleteShare(fileId);
    }

    public ShareLinkBean createShareIntegration(Long integrateId, Integer activeHours) throws BimfaceException {
        return this.shareLinkService.createShareIntegration(integrateId, activeHours);
    }

    public ShareLinkBean createShareIntegration(Long integrateId) throws BimfaceException {
        return this.shareLinkService.createShareIntegration(integrateId);
    }

    public void deleteShareIntegration(Long integrateId) throws BimfaceException {
        this.shareLinkService.deleteShareIntegration(integrateId);
    }

    public PropertyBean getProperty(Long fileId, String elementId) throws BimfaceException {
        return this.propertyService.getElementProperty(fileId, elementId);
    }

    public PropertyBean getIntegrationProperty(Long integrateId, Long fileId, String elementId) throws BimfaceException {
        return this.propertyService.getIntegrationElementProperty(integrateId, fileId, elementId);
    }

    public List<CategoryBean> getCategory(Long fileId) throws BimfaceException {
        return this.categoryTreeService.getCategoryTree(fileId);
    }

    public List<TreeNode> getCategoryV2(Long fileId) throws BimfaceException {
        return this.categoryTreeService.getCategoryTreeV2(fileId);
    }

    public SpecialtyTree getSpecialtyTree(Long integrateId) throws BimfaceException {
        return this.categoryTreeService.getSpecialtyTree(integrateId);
    }

    public FloorTree getFloorTree(Long integrateId) throws BimfaceException {
        return this.categoryTreeService.getFloorTree(integrateId);
    }

    public IntegrateBean integrate(IntegrateRequest request) throws BimfaceException {
        return this.integrateService.integrate(request);
    }

    public IntegrateBean getIntegrate(Long integrateId) throws BimfaceException {
        return this.integrateService.getIntegrate(integrateId);
    }

    public void deleteIntegrate(Long integrateId) throws BimfaceException {
        this.integrateService.deleteIntegrate(integrateId);
    }

    public boolean validateSignature(String signature, String id, String status, String nonce) throws BimfaceException {
        return this.signatureService.validate(signature, id, status, nonce);
    }

    public OfflineDatabagBean generateOfflineDatabag(OfflineDatabagRequest offlineDatabagRequest) throws BimfaceException {
        return this.offlineDatabagService.generateOfflineDatabag(offlineDatabagRequest);
    }

    public List<OfflineDatabagBean> queryOfflineDatabag(OfflineDatabagRequest offlineDatabagRequest) throws BimfaceException {
        return this.offlineDatabagService.queryOfflineDatabag(offlineDatabagRequest);
    }

    public String getOfflineDatabagUrl(OfflineDatabagRequest offlineDatabagRequest) throws BimfaceException {
        return this.offlineDatabagService.getOfflineDatabagUrl(offlineDatabagRequest);
    }

    public Credential getCredential() {
        return this.credential;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public AccessTokenService getAccessTokenService() {
        return this.accessTokenService;
    }

    public SupportFileService getSupportFileService() {
        return this.supportFileService;
    }

    public UploadService getUploadService() {
        return this.uploadService;
    }

    public TranslateService getTranslateService() {
        return this.translateService;
    }

    public ViewTokenService getViewTokenService() {
        return this.viewTokenService;
    }

    public ShareLinkService getShareLinkService() {
        return this.shareLinkService;
    }

    public PropertyService getPropertyService() {
        return this.propertyService;
    }

    public SignatureService getSignatureService() {
        return this.signatureService;
    }

    public DownloadService getDownloadService() {
        return this.downloadService;
    }

    public ElementService getElementService() {
        return this.elementService;
    }

    public CategoryTreeService getCategoryService() {
        return this.categoryTreeService;
    }

    public OfflineDatabagService getOfflineDatabagService() {
        return this.offlineDatabagService;
    }

    public AppendFileBean createAppendFile(String name, String sourceId, Long length) throws BimfaceException {
        return this.uploadService.createAppendFile(name, sourceId, length);
    }

    public AppendFileBean queryAppendFile(Long appendFileId) throws BimfaceException {
        return this.uploadService.queryAppendFile(appendFileId);
    }

    public AppendFileBean uploadAppendFile(InputStream inputStream, Long appendFileId) throws BimfaceException {
        return this.uploadService.uploadAppendFile(inputStream, appendFileId);
    }
}

