/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.http;

import com.bimface.sdk.utils.Base64;
import com.bimface.sdk.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaders {
    public static final String AUTHORIZATION = "Authorization";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String DATE = "Date";
    public static final String ETAG = "ETag";
    public static final String EXPIRES = "Expires";
    public static final String HOST = "Host";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String RANGE = "Range";
    public static final String LOCATION = "Location";
    public static final String CONNECTION = "Connection";
    private Map<String, String> headers = new HashMap<String, String>();

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addBasicAuthHeader(String appKey, String appSecret) {
        byte[] bytes = StringUtils.utf8Bytes(appKey + ":" + appSecret);
        String credential = "Basic " + Base64.encode(bytes);
        this.addHeader(AUTHORIZATION, credential.replaceAll("\n", "").replaceAll("\r", ""));
    }

    public void addOAuth2Header(String token) {
        this.addHeader(AUTHORIZATION, "Bearer " + token);
    }
}

