/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.http;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.exception.BimfaceException;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static <T> T response(Response response, TypeReference<GeneralResponse<T>> typeReference) throws BimfaceException {
        try {
            String body = response.body().string();
            if (logger.isDebugEnabled()) {
                logger.debug("call tracking log:\nresponse body: {}", (Object)body);
            }
            if (response.isSuccessful()) {
                GeneralResponse generalResponse = (GeneralResponse)JSONObject.parseObject((String)body, typeReference, (Feature[])new Feature[0]);
                if ("success".equalsIgnoreCase(generalResponse.getCode())) {
                    return generalResponse.getData();
                }
                logger.error("call failed: \nresponse code: {} \nresponse message: {} \nresponse body: {}", new Object[]{response.code(), response.message(), body});
                throw new BimfaceException(generalResponse.getMessage(), generalResponse.getCode());
            }
            logger.error("call failed: \nresponse code: {} \nresponse message: {} \nresponse body: {}", new Object[]{response.code(), response.message(), body});
            throw new BimfaceException(body, response.code());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceException(e);
        }
    }

    public static InputStream response(Response response) throws BimfaceException {
        try {
            return response.body().byteStream();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceException(e);
        }
    }
}

