/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.http;

import com.alibaba.fastjson.JSONObject;
import com.bimface.sdk.config.Config;
import com.bimface.sdk.constants.BimfaceConstants;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpFormEncoding;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.utils.StringUtils;
import com.bimface.sdk.utils.VersionInfoUtils;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceClient {
    private static final Logger logger = LoggerFactory.getLogger(ServiceClient.class);
    private OkHttpClient okHttpClient;
    public RequestBody emptyRequestBody = RequestBody.create((MediaType)BimfaceConstants.MEDIA_TYPE_JSON, (String)"");

    public ServiceClient() {
    }

    public ServiceClient(Config config) {
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(config.getMaxRequests());
        dispatcher.setMaxRequestsPerHost(config.getMaxRequestsPerHost());
        ConnectionPool connectionPool = new ConnectionPool(config.getMaxIdleConnections(), config.getKeepAliveDurationNs());
        this.okHttpClient = new OkHttpClient();
        this.okHttpClient.setDispatcher(dispatcher);
        this.okHttpClient.setConnectionPool(connectionPool);
        this.okHttpClient.networkInterceptors().add(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                System.out.println(request.toString());
                System.out.println(request.headers().toString());
                if (request.body() != null) {
                    System.out.println(request.body().contentType());
                }
                Response response = chain.proceed(request);
                return response;
            }
        });
        this.okHttpClient.setConnectTimeout((long)config.getConnectTimeout(), TimeUnit.SECONDS);
        this.okHttpClient.setReadTimeout((long)config.getReadTimeout(), TimeUnit.SECONDS);
        this.okHttpClient.setWriteTimeout((long)config.getWriteTimeout(), TimeUnit.SECONDS);
    }

    public Response get(String url) throws BimfaceException {
        return this.get(url, new HttpHeaders());
    }

    public Response get(String url, HttpHeaders headers) throws BimfaceException {
        Request.Builder requestBuilder = new Request.Builder().get().url(url);
        return this.send(requestBuilder, Headers.of(headers.getHeaders()));
    }

    public Response post(String url, byte[] body, HttpHeaders headers) throws BimfaceException {
        return this.post(url, body, headers, "application/octet-stream");
    }

    public Response post(String url, String body, HttpHeaders headers) throws BimfaceException {
        return this.post(url, StringUtils.utf8Bytes(body), headers, "application/octet-stream");
    }

    public Response post(String url, HttpFormEncoding params, HttpHeaders headers) throws BimfaceException {
        FormEncodingBuilder f = new FormEncodingBuilder();
        for (String key : params.getParams().keySet()) {
            f.add(key, params.getParams().get(key));
        }
        return this.post(url, f.build(), headers);
    }

    public Response post(String url, byte[] body, HttpHeaders headers, String contentType) throws BimfaceException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = RequestBody.create((MediaType)t, (byte[])body);
        } else {
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.post(url, rbody, headers);
    }

    public Response post(String url, byte[] body, int offset, int size, HttpHeaders headers, String contentType) throws BimfaceException {
        RequestBody rbody;
        if (body != null && body.length > 0) {
            MediaType t = MediaType.parse((String)contentType);
            rbody = ServiceClient.requestIO(t, body, offset, size);
        } else {
            rbody = RequestBody.create(null, (byte[])new byte[0]);
        }
        return this.post(url, rbody, headers);
    }

    public Response post(String url, InputStream inputStream, Long contentLength, HttpHeaders headers) throws BimfaceException {
        return this.post(url, ServiceClient.requestIO(inputStream, contentLength), headers);
    }

    public Response post(String url, RequestBody body, HttpHeaders headers) throws BimfaceException {
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        return this.send(requestBuilder, Headers.of(headers.getHeaders()));
    }

    public Response put(String url, HttpHeaders headers) throws BimfaceException {
        return this.put(url, this.emptyRequestBody, headers);
    }

    public Response put(String url, Object body, HttpHeaders headers) throws BimfaceException {
        return this.put(url, JSONObject.toJSONString((Object)body), headers);
    }

    public Response put(String url, String body, HttpHeaders headers) throws BimfaceException {
        return this.put(url, RequestBody.create((MediaType)BimfaceConstants.MEDIA_TYPE_JSON, (String)body), headers);
    }

    public Response put(String url, InputStream inputStream, Long contentLength, HttpHeaders headers) throws BimfaceException {
        return this.put(url, ServiceClient.requestIO(inputStream, contentLength), headers);
    }

    private Response put(String url, RequestBody body, HttpHeaders headers) throws BimfaceException {
        Request.Builder requestBuilder = new Request.Builder().url(url).put(body);
        return this.send(requestBuilder, Headers.of(headers.getHeaders()));
    }

    public Response delete(String url) throws BimfaceException {
        return this.delete(url, new HttpHeaders());
    }

    public Response delete(String url, HttpHeaders headers) throws BimfaceException {
        Request.Builder requestBuilder = new Request.Builder().url(url).delete();
        return this.send(requestBuilder, Headers.of(headers.getHeaders()));
    }

    public Response send(Request.Builder requestBuilder, Headers headers) throws BimfaceException {
        if (headers != null) {
            requestBuilder.headers(headers);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("call tracking log:\nrequest url: {}", (Object)requestBuilder.build().urlString());
        }
        try {
            requestBuilder.header("User-Agent", VersionInfoUtils.getDefaultUserAgent());
            Response response = this.okHttpClient.newCall(requestBuilder.build()).execute();
            if (response.code() >= 300) {
                logger.error("call failed:\nresponse code: {}\nresponse message: {}\nresponse body: {}", new Object[]{response.code(), response.message(), response.body().string()});
                throw new BimfaceException(response.message(), response.code());
            }
            return response;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BimfaceException(e);
        }
    }

    private static RequestBody requestIO(final MediaType contentType, final byte[] content, final int offset, final int size) {
        if (content == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() {
                return size;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content, offset, size);
            }
        };
    }

    private static RequestBody requestIO(final InputStream inputStream, final Long contentLength) {
        if (inputStream == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"application/octet-stream");
            }

            public long contentLength() {
                return contentLength;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                block7: {
                    try {
                        int l;
                        byte[] buffer = new byte[BimfaceConstants.PUT_THRESHOLD];
                        if (contentLength < (long)BimfaceConstants.PUT_THRESHOLD) {
                            int l2;
                            while ((l2 = inputStream.read(buffer)) != -1) {
                                sink.outputStream().write(buffer, 0, l2);
                            }
                            break block7;
                        }
                        for (long remaining = contentLength.longValue(); remaining > 0L; remaining -= (long)l) {
                            l = inputStream.read(buffer, 0, (int)Math.min((long)BimfaceConstants.PUT_THRESHOLD, remaining));
                            if (l == -1) {
                                break;
                            }
                            sink.outputStream().write(buffer, 0, l);
                        }
                    }
                    finally {
                        sink.close();
                    }
                }
            }
        };
    }

    private static RequestBody requestIOFromPosition(final InputStream inputStream, final Long contentLength, final Long position) {
        if (inputStream == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"application/octet-stream");
            }

            public long contentLength() {
                return contentLength;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                try {
                    int l;
                    inputStream.skip(position);
                    byte[] buffer = new byte[BimfaceConstants.PUT_THRESHOLD];
                    while ((l = inputStream.read(buffer)) != -1) {
                        sink.outputStream().write(buffer, 0, l);
                    }
                }
                finally {
                    sink.close();
                }
            }
        };
    }
}

