/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.response.AccessTokenBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.config.authorization.AccessTokenStorage;
import com.bimface.sdk.config.authorization.Credential;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractService;
import com.squareup.okhttp.Response;

public class AccessTokenService
extends AbstractService {
    private final String ACCESS_TOKEN_URL = this.getApiHost() + "/oauth2/token";
    private Credential credential;
    private AccessTokenStorage accessTokenStorage;

    public AccessTokenService(ServiceClient serviceClient, Endpoint endpoint, Credential credential, AccessTokenStorage accessTokenStorage) {
        super(serviceClient, endpoint);
        this.credential = credential;
        this.accessTokenStorage = accessTokenStorage;
    }

    public AccessTokenBean get() throws BimfaceException {
        AccessTokenBean accessTokenBean = this.accessTokenStorage.get();
        if (accessTokenBean == null) {
            accessTokenBean = this.grant();
            this.accessTokenStorage.put(accessTokenBean);
        }
        return accessTokenBean;
    }

    private AccessTokenBean grant() throws BimfaceException {
        HttpHeaders headers = new HttpHeaders();
        headers.addBasicAuthHeader(this.credential.getAppKey(), this.credential.getAppSecret());
        Response response = this.getServiceClient().post(this.ACCESS_TOKEN_URL, this.getServiceClient().emptyRequestBody.toString(), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<AccessTokenBean>>(){});
    }
}

