/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.response.CategoryBean;
import com.bimface.sdk.bean.response.FloorTree;
import com.bimface.sdk.bean.response.SpecialtyTree;
import com.bimface.sdk.bean.response.TreeNode;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryTreeService
extends AbstractAccessTokenService {
    private final String GET_CATEGORY_URL = this.getApiHost() + "/data/hierarchy?fileId=%s";
    private final String GET_CATEGORY_URL_V2 = this.getApiHost() + "/data/v2/files/%s/tree?v=2.0";
    private final String GET_TREE_URL = this.getApiHost() + "/data/integration/tree?integrateId=%s&treeType=%s";

    public CategoryTreeService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public CategoryTreeService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public List<CategoryBean> getCategoryTree(Long fileId) throws BimfaceException {
        return this.getCategoryTree(fileId, this.getAccessToken());
    }

    public List<CategoryBean> getCategoryTree(Long fileId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.GET_CATEGORY_URL, fileId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<List<CategoryBean>>>(){});
    }

    public List<TreeNode> getCategoryTreeV2(Long fileId) throws BimfaceException {
        return this.getCategoryTreeV2(fileId, this.getAccessToken());
    }

    public List<TreeNode> getCategoryTreeV2(Long fileId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.GET_CATEGORY_URL_V2, fileId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<List<TreeNode>>>(){});
    }

    public FloorTree getFloorTree(Long integrateId) throws BimfaceException {
        return this.getFloorTree(integrateId, this.getAccessToken());
    }

    public FloorTree getFloorTree(Long integrateId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        Integer treeType = 2;
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.GET_TREE_URL, integrateId, treeType), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<FloorTree>>(){});
    }

    public SpecialtyTree getSpecialtyTree(Long integrateId) throws BimfaceException {
        return this.getSpecialtyTree(integrateId, this.getAccessToken());
    }

    public SpecialtyTree getSpecialtyTree(Long integrateId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        Integer treeType = 1;
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.GET_TREE_URL, integrateId, treeType), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<SpecialtyTree>>(){});
    }
}

