/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;
import java.io.InputStream;

public class DownloadService
extends AbstractAccessTokenService {
    private final String DOWNLOAD_URL = this.getFileHost() + "/download/url?fileId=%s&fileName=%s";

    public DownloadService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public DownloadService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public String getDownloadUrl(String accessToken, Long fileId) throws BimfaceException {
        return this.getDownloadUrl(fileId, "", accessToken);
    }

    public String getDownloadUrl(Long fileId) throws BimfaceException {
        return this.getDownloadUrl(fileId, "", this.getAccessToken());
    }

    public String getDownloadUrl(Long fileId, String fileName) throws BimfaceException {
        return this.getDownloadUrl(fileId, fileName, this.getAccessToken());
    }

    public String getDownloadUrl(Long fileId, String fileName, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        AssertUtils.assertParameterNotNull(fileName, "fileName");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.DOWNLOAD_URL, fileId.toString(), fileName), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }

    public InputStream getFileContent(Long fileId, String name) throws BimfaceException {
        return this.getFileContent(fileId, name, this.getAccessToken());
    }

    public InputStream getFileContent(Long fileId, String name, String accessToken) throws BimfaceException {
        String url = null;
        url = name == null ? this.getDownloadUrl(accessToken, fileId) : this.getDownloadUrl(fileId, name, accessToken);
        HttpHeaders headers = new HttpHeaders();
        Response response = this.getServiceClient().get(url, headers);
        return HttpUtils.response(response);
    }
}

