/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.response.ElementsBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementService
extends AbstractAccessTokenService {
    private final String GET_ELEMENT_URL = this.getApiHost() + "/data/element/id?fileId=%s";
    private final String GET_INTEGRATE_ELEMENT_URL = this.getApiHost() + "/data/integration/element?integrateId=%s";

    public ElementService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public ElementService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public List<String> getElements(Long fileId, String floor, String specialty, String categoryId, String family, String familyType) throws BimfaceException {
        return this.getElements(fileId, floor, specialty, categoryId, family, familyType, this.getAccessToken());
    }

    public List<String> getElements(Long fileId, String floor, String specialty, String categoryId, String family, String familyType, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        StringBuilder sb = new StringBuilder().append(String.format(this.GET_ELEMENT_URL, fileId));
        if (categoryId != null) {
            sb.append("&categoryId=").append(categoryId);
        }
        if (family != null) {
            sb.append("&family=").append(family);
        }
        if (familyType != null) {
            sb.append("&familyType=").append(familyType);
        }
        if (floor != null) {
            sb.append("&floor=").append(floor);
        }
        if (specialty != null) {
            sb.append("&specialty=").append(specialty);
        }
        Response response = this.getServiceClient().get(sb.toString(), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<List<String>>>(){});
    }

    public ElementsBean getIntegrationElements(Long integrateId, String floor, String specialty, String categoryId, String family, String familyType) throws BimfaceException {
        return this.getIntegrationElements(integrateId, floor, specialty, categoryId, family, familyType, this.getAccessToken());
    }

    public ElementsBean getIntegrationElements(Long integrateId, String floor, String specialty, String categoryId, String family, String familyType, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        StringBuilder sb = new StringBuilder().append(String.format(this.GET_INTEGRATE_ELEMENT_URL, integrateId));
        if (categoryId != null) {
            sb.append("&categoryId=").append(categoryId);
        }
        if (family != null) {
            sb.append("&family=").append(family);
        }
        if (familyType != null) {
            sb.append("&familyType=").append(familyType);
        }
        if (floor != null) {
            sb.append("&floor=").append(floor);
        }
        if (specialty != null) {
            sb.append("&specialty=").append(specialty);
        }
        Response response = this.getServiceClient().get(sb.toString(), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<ElementsBean>>(){});
    }
}

