/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.request.integrate.IntegrateRequest;
import com.bimface.sdk.bean.response.IntegrateBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;

public class IntegrateService
extends AbstractAccessTokenService {
    private final String INTEGRATE_URL = this.getApiHost() + "/integrate";
    private final String GET_INTEGRATE_URL = this.getApiHost() + "/integrate?integrateId=%s";
    private final String DELETE_INTEGRATE_URL = this.getApiHost() + "/integrate?integrateId=%s";

    public IntegrateService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public IntegrateService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public IntegrateBean integrate(IntegrateRequest request) throws BimfaceException {
        return this.integrate(request, this.getAccessToken());
    }

    public IntegrateBean integrate(IntegrateRequest request, String accessToken) throws BimfaceException {
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().put(this.INTEGRATE_URL, request, headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<IntegrateBean>>(){});
    }

    public IntegrateBean getIntegrate(Long integrateId) throws BimfaceException {
        return this.getIntegrate(integrateId, this.getAccessToken());
    }

    public IntegrateBean getIntegrate(Long integrateId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.GET_INTEGRATE_URL, integrateId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<IntegrateBean>>(){});
    }

    public String deleteIntegrate(Long integrateId) throws BimfaceException {
        return this.deleteIntegrate(integrateId, this.getAccessToken());
    }

    public String deleteIntegrate(Long integrateId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().delete(String.format(this.DELETE_INTEGRATE_URL, integrateId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }
}

