/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.request.OfflineDatabagRequest;
import com.bimface.sdk.bean.response.OfflineDatabagBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineDatabagService
extends AbstractAccessTokenService {
    private final String CREATE_OFFLINE_DATABAG_BY_FILE_ID = this.getApiHost() + "/files/%s/offlineDatabag?callback=%s";
    private final String CREATE_OFFLINE_DATABAG_BY_INTEGRATE_ID = this.getApiHost() + "/integrations/%s/offlineDatabag?callback=%s";
    private final String CREATE_OFFLINE_DATABAG_BY_COMPARE_ID = this.getApiHost() + "/comparisions/%s/offlineDatabag?callback=%s";
    private final String QUERY_OFFLINE_DATABAG_BY_FILE_ID = this.getApiHost() + "/files/%s/offlineDatabag";
    private final String QUERY_OFFLINE_DATABAG_BY_INTEGRATE_ID = this.getApiHost() + "/integrations/%s/offlineDatabag";
    private final String QUERY_OFFLINE_DATABAG_BY_COMPARE_ID = this.getApiHost() + "/comparisions/%s/offlineDatabag";
    private final String GET_OFFLINE_DATABAG_URL_BY_FILE_ID = this.getApiHost() + "/data/databag/downloadUrl?fileId=%s&type=offline&databagVersion=%s";
    private final String GET_OFFLINE_DATABAG_URL_BY_INTEGRATE_ID = this.getApiHost() + "/data/databag/downloadUrl?integrateId=%s&type=offline&databagVersion=%s";
    private final String GET_OFFLINE_DATABAG_URL_BY_COMPARE_ID = this.getApiHost() + "/data/databag/downloadUrl?comapreId=%s&type=offline&databagVersion=%s";

    public OfflineDatabagService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public OfflineDatabagService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public OfflineDatabagBean generateOfflineDatabag(OfflineDatabagRequest request) throws BimfaceException {
        return this.generateOfflineDatabag(request, this.getAccessToken());
    }

    public OfflineDatabagBean generateOfflineDatabag(OfflineDatabagRequest request, String accessToken) throws BimfaceException {
        String url;
        this.check(request);
        String callback = "";
        if (request.getCallback() != null && !"".equals(request.getCallback().trim())) {
            try {
                callback = URLEncoder.encode(request.getCallback(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                callback = request.getCallback();
            }
        }
        if (request.getFileId() != null && !"".equals(request.getFileId().trim())) {
            url = String.format(this.CREATE_OFFLINE_DATABAG_BY_FILE_ID, request.getFileId(), callback);
        } else if (request.getIntegrateId() != null && !"".equals(request.getIntegrateId().trim())) {
            url = String.format(this.CREATE_OFFLINE_DATABAG_BY_INTEGRATE_ID, request.getIntegrateId(), callback);
        } else if (request.getCompareId() != null && !"".equals(request.getCompareId().trim())) {
            url = String.format(this.CREATE_OFFLINE_DATABAG_BY_COMPARE_ID, request.getCompareId(), callback);
        } else {
            throw new NullPointerException("'fileId', 'integrateId', 'compareId' can't be all empty");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().put(url, "", headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<OfflineDatabagBean>>(){});
    }

    public List<OfflineDatabagBean> queryOfflineDatabag(OfflineDatabagRequest request) throws BimfaceException {
        return this.queryOfflineDatabag(request, this.getAccessToken());
    }

    public List<OfflineDatabagBean> queryOfflineDatabag(OfflineDatabagRequest request, String accessToken) throws BimfaceException {
        String url;
        this.check(request);
        if (request.getFileId() != null && !"".equals(request.getFileId().trim())) {
            url = String.format(this.QUERY_OFFLINE_DATABAG_BY_FILE_ID, request.getFileId());
        } else if (request.getIntegrateId() != null && !"".equals(request.getIntegrateId().trim())) {
            url = String.format(this.QUERY_OFFLINE_DATABAG_BY_INTEGRATE_ID, request.getIntegrateId());
        } else if (request.getCompareId() != null && !"".equals(request.getCompareId().trim())) {
            url = String.format(this.QUERY_OFFLINE_DATABAG_BY_COMPARE_ID, request.getCompareId());
        } else {
            throw new NullPointerException("'fileId', 'integrateId', 'compareId' can't be all empty");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(url, headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<List<OfflineDatabagBean>>>(){});
    }

    public String getOfflineDatabagUrl(OfflineDatabagRequest request) throws BimfaceException {
        return this.getOfflineDatabagUrl(request, this.getAccessToken());
    }

    public String getOfflineDatabagUrl(OfflineDatabagRequest request, String accessToken) throws BimfaceException {
        String url;
        this.check(request);
        if (request.getFileId() != null && !"".equals(request.getFileId().trim())) {
            url = String.format(this.GET_OFFLINE_DATABAG_URL_BY_FILE_ID, request.getFileId(), request.getDatabagVersion());
        } else if (request.getIntegrateId() != null && !"".equals(request.getIntegrateId().trim())) {
            url = String.format(this.GET_OFFLINE_DATABAG_URL_BY_INTEGRATE_ID, request.getIntegrateId(), request.getDatabagVersion());
        } else if (request.getCompareId() != null && !"".equals(request.getCompareId().trim())) {
            url = String.format(this.GET_OFFLINE_DATABAG_URL_BY_COMPARE_ID, request.getCompareId(), request.getDatabagVersion());
        } else {
            throw new NullPointerException("'fileId', 'integrateId', 'compareId' can't be all empty");
        }
        if (request.getDatabagVersion() == null || "".equals(request.getDatabagVersion().trim())) {
            url = url.substring(0, url.lastIndexOf("&databagVersion"));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(url, headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }

    private void check(OfflineDatabagRequest request) {
        AssertUtils.assertParameterNotNull(request, "OfflineDatabagRequest");
        if (!(request.getFileId() != null && !"".equals(request.getFileId().trim()) || request.getIntegrateId() != null && !"".equals(request.getIntegrateId().trim()) || request.getCompareId() != null && !"".equals(request.getCompareId().trim()))) {
            throw new NullPointerException("'fileId', 'integrateId', 'compareId' can't be all empty");
        }
    }
}

