/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.response.PropertyBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;

public class PropertyService
extends AbstractAccessTokenService {
    private final String PROPERTIES_URL = this.getApiHost() + "/data/element/property?fileId=%s&elementId=%s";
    private final String INTEGRATE_PROPERTIES_URL = this.getApiHost() + "/data/integration/element/property?integrateId=%s&fileId=%s&elementId=%s";

    public PropertyService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public PropertyService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public PropertyBean getElementProperty(Long fileId, String elementId) throws BimfaceException {
        return this.getElementProperty(fileId, elementId, this.getAccessToken());
    }

    public PropertyBean getElementProperty(Long fileId, String elementId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        AssertUtils.assertStringNotNullOrEmpty(elementId, "elementId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.PROPERTIES_URL, fileId, elementId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<PropertyBean>>(){});
    }

    public PropertyBean getIntegrationElementProperty(Long integrateId, Long fileId, String elementId) throws BimfaceException {
        return this.getIntegrationElementProperty(integrateId, fileId, elementId, this.getAccessToken());
    }

    public PropertyBean getIntegrationElementProperty(Long integrateId, Long fileId, String elementId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        AssertUtils.assertStringNotNullOrEmpty(elementId, "elementId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.INTEGRATE_PROPERTIES_URL, integrateId, fileId, elementId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<PropertyBean>>(){});
    }
}

