/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.response.ShareLinkBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;

public class ShareLinkService
extends AbstractAccessTokenService {
    private final String CREATE_TRANSLATE_SHARE_URL = this.getApiHost() + "/share?fileId=%s&activeHours=%s";
    private final String CREATE_TRANSLATE_SHARE_URL_FOREVER = this.getApiHost() + "/share?fileId=%s";
    private final String DELETE_TRANSLATE_SHARE_URL = this.getApiHost() + "/share?fileId=%s";
    private final String CREATE_INTEGRATE_SHARE_URL = this.getApiHost() + "/share?integrateId=%s&activeHours=%s";
    private final String CREATE_INTEGRATE_SHARE_URL_FOREVER = this.getApiHost() + "/share?integrateId=%s";
    private final String DELETE_INTEGRATE_SHARE_URL = this.getApiHost() + "/share?integrateId=%s";

    public ShareLinkService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public ShareLinkService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public ShareLinkBean createShare(Long fileId, Integer activeHours) throws BimfaceException {
        return this.createShare(fileId, activeHours, this.getAccessToken());
    }

    public ShareLinkBean createShare(Long fileId, Integer activeHours, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "transferId");
        if (activeHours == null) {
            HttpHeaders headers = new HttpHeaders();
            headers.addOAuth2Header(accessToken);
            Response response = this.getServiceClient().post(String.format(this.CREATE_TRANSLATE_SHARE_URL_FOREVER, fileId), "", headers);
            return HttpUtils.response(response, new TypeReference<GeneralResponse<ShareLinkBean>>(){});
        }
        if (activeHours != null && activeHours <= 0) {
            throw new IllegalArgumentException("activeHours must not less than zero.");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(this.getAccessToken());
        Response response = this.getServiceClient().post(String.format(this.CREATE_TRANSLATE_SHARE_URL, fileId, activeHours), "", headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<ShareLinkBean>>(){});
    }

    public ShareLinkBean createShare(Long fileId) throws BimfaceException {
        return this.createShare(fileId, this.getAccessToken());
    }

    public ShareLinkBean createShare(Long fileId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().post(String.format(this.CREATE_TRANSLATE_SHARE_URL_FOREVER, fileId), "", headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<ShareLinkBean>>(){});
    }

    public String deleteShare(Long fileId) throws BimfaceException {
        return this.deleteShare(fileId, this.getAccessToken());
    }

    public String deleteShare(Long fileId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().delete(String.format(this.DELETE_TRANSLATE_SHARE_URL, fileId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }

    public ShareLinkBean createShareIntegration(Long integrateId, Integer activeHours) throws BimfaceException {
        return this.createShareIntegration(integrateId, activeHours, this.getAccessToken());
    }

    public ShareLinkBean createShareIntegration(Long integrateId, Integer activeHours, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().post(String.format(this.CREATE_INTEGRATE_SHARE_URL, integrateId, activeHours), "", headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<ShareLinkBean>>(){});
    }

    public ShareLinkBean createShareIntegration(Long integrateId) throws BimfaceException {
        return this.createShareIntegration(integrateId, this.getAccessToken());
    }

    public ShareLinkBean createShareIntegration(Long integrateId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().post(String.format(this.CREATE_INTEGRATE_SHARE_URL_FOREVER, integrateId), "", headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<ShareLinkBean>>(){});
    }

    public String deleteShareIntegration(Long integrateId) throws BimfaceException {
        return this.deleteShareIntegration(integrateId, this.getAccessToken());
    }

    public String deleteShareIntegration(Long integrateId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().delete(String.format(this.DELETE_INTEGRATE_SHARE_URL, integrateId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }
}

