/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.request.translate.TranslateRequest;
import com.bimface.sdk.bean.response.TranslateBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;

public class TranslateService
extends AbstractAccessTokenService {
    private final String TRANSLATE_URL = this.getApiHost() + "/translate";
    private final String GET_TRANSLATE_URL = this.getApiHost() + "/translate?fileId=%s";

    public TranslateService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public TranslateService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public TranslateBean translate(TranslateRequest request) throws BimfaceException {
        return this.translate(request, this.getAccessToken());
    }

    public TranslateBean translate(TranslateRequest request, String accessToken) throws BimfaceException {
        this.check(request);
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().put(this.TRANSLATE_URL, request, headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<TranslateBean>>(){});
    }

    public TranslateBean getTranslate(Long fileId) throws BimfaceException {
        return this.getTranslate(fileId, this.getAccessToken());
    }

    public TranslateBean getTranslate(Long fileId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.GET_TRANSLATE_URL, fileId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<TranslateBean>>(){});
    }

    private void check(TranslateRequest request) {
        AssertUtils.assertParameterNotNull(request, "TranslateRequest");
        AssertUtils.assertParameterNotNull(request.getSource(), "source");
        AssertUtils.assertParameterNotNull(request.getSource().getFileId(), "fileId");
    }
}

