/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.bean.request.FileUploadRequest;
import com.bimface.sdk.bean.response.AppendFileBean;
import com.bimface.sdk.bean.response.FileBean;
import com.bimface.sdk.bean.response.SupportFileBean;
import com.bimface.sdk.bean.response.UploadPolicyBean;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.constants.BimfaceConstants;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.service.SupportFileService;
import com.bimface.sdk.utils.AssertUtils;
import com.bimface.sdk.utils.FileNameUtils;
import com.bimface.sdk.utils.RequestBodyUtil;
import com.bimface.sdk.utils.StringUtils;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import okio.BufferedSink;

public class UploadService
extends AbstractAccessTokenService {
    private final String UPLOAD_URL = this.getFileHost() + "/upload?name=%s";
    private final String UPLOAD_BY_URL_URL = this.getFileHost() + "/upload?name=%s&url=%s";
    private final String GET_UPLOAD_POLICY_URL = this.getFileHost() + "/upload/policy?name=%s";
    private final String UPLOAD_BY_OSS_URL = this.getFileHost() + "/upload?name=%s&bucket=%s&objectKey=%s";
    private final String DELETE_FILE_URL = this.getFileHost() + "/file?fileId=%s";
    private final String GET_FILE_METADATA = this.getFileHost() + "/metadata?fileId=%s";
    private final String CREATE_APPEND_FILE_URL = this.getFileHost() + "/appendFiles?name=%s&sourceId=%s&length=%s";
    private final String QUERY_APPEND_FILE_URL = this.getFileHost() + "/appendFiles/%s";
    private final String UPLOAD_APPEND_FILE_URL = this.getFileHost() + "/appendFiless/%s/data?position=%s";
    private SupportFileService supportFileService;

    public UploadService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public UploadService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public FileBean upload(FileUploadRequest fileUploadRequest) throws BimfaceException {
        return this.upload(fileUploadRequest, this.getAccessToken());
    }

    public FileBean upload(FileUploadRequest fileUploadRequest, String accessToken) throws BimfaceException {
        this.check(fileUploadRequest, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = null;
        StringBuilder requestUrl = new StringBuilder();
        if (fileUploadRequest.isByUrl()) {
            try {
                requestUrl.append(String.format(this.UPLOAD_BY_URL_URL, URLEncoder.encode(fileUploadRequest.getName(), "utf-8"), URLEncoder.encode(fileUploadRequest.getUrl(), "utf-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (fileUploadRequest.getSourceId() != null) {
                try {
                    requestUrl.append("&sourceId=").append(URLEncoder.encode(fileUploadRequest.getSourceId(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            response = this.getServiceClient().put(requestUrl.toString(), headers);
        } else if (fileUploadRequest.isByOSS()) {
            try {
                requestUrl.append(String.format(this.UPLOAD_BY_OSS_URL, URLEncoder.encode(fileUploadRequest.getName(), "utf-8"), fileUploadRequest.getBucket(), fileUploadRequest.getObjectKey()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (fileUploadRequest.getSourceId() != null) {
                try {
                    requestUrl.append("&sourceId=").append(URLEncoder.encode(fileUploadRequest.getSourceId(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            response = this.getServiceClient().put(requestUrl.toString(), headers);
        } else {
            try {
                requestUrl.append(String.format(this.UPLOAD_URL, URLEncoder.encode(fileUploadRequest.getName(), "utf-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (fileUploadRequest.getSourceId() != null) {
                try {
                    requestUrl.append("&sourceId=").append(URLEncoder.encode(fileUploadRequest.getSourceId(), "utf-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            headers.addHeader("Content-Length", fileUploadRequest.getContentLength().toString());
            response = this.getServiceClient().put(requestUrl.toString(), fileUploadRequest.getInputStream(), fileUploadRequest.getContentLength(), headers);
        }
        return HttpUtils.response(response, new TypeReference<GeneralResponse<FileBean>>(){});
    }

    public UploadPolicyBean getPolicy(String name, String sourceId) throws BimfaceException {
        return this.getPolicy(name, sourceId, this.getAccessToken());
    }

    public UploadPolicyBean getPolicy(String name, String sourceId, String accessToken) throws BimfaceException {
        FileNameUtils.checkFileName(name);
        if (StringUtils.isNullOrEmpty(sourceId)) {
            sourceId = "";
        }
        SupportFileBean supportFileBean = this.getSupportFileService().getSupport(accessToken);
        String[] allSupportedType = supportFileBean.getTypes();
        FileNameUtils.checkFileType(allSupportedType, name);
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        StringBuilder requestUrl = null;
        try {
            requestUrl = new StringBuilder().append(String.format(this.GET_UPLOAD_POLICY_URL, URLEncoder.encode(name, BimfaceConstants.UTF_8.name())));
            if (sourceId != null) {
                requestUrl.append("&sourceId=").append(URLEncoder.encode(sourceId, BimfaceConstants.UTF_8.name()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Response response = this.getServiceClient().get(requestUrl.toString(), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<UploadPolicyBean>>(){});
    }

    public FileBean uploadByPolicy(String name, String sourceId, Long contentLength, InputStream inputStream) throws BimfaceException {
        return this.uploadByPolicy(name, sourceId, contentLength, inputStream, this.getAccessToken());
    }

    public FileBean uploadByPolicy(String name, String sourceId, Long contentLength, InputStream inputStream, String accessToken) throws BimfaceException {
        this.check(new FileUploadRequest(name, sourceId, contentLength, inputStream), accessToken);
        UploadPolicyBean policy = this.getPolicy(name, sourceId, accessToken);
        return this.uploadByPolicy(policy, name, contentLength, inputStream, accessToken);
    }

    private FileBean uploadByPolicy(UploadPolicyBean policy, String name, Long contentLength, InputStream inputStream, String accessToken) throws BimfaceException {
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        RequestBody body = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart("key", policy.getObjectKey()).addFormDataPart("success_action_status", "200").addFormDataPart("Content-Disposition", "attachment;filename=" + name).addFormDataPart("OSSAccessKeyId", policy.getAccessId()).addFormDataPart("policy", policy.getPolicy()).addFormDataPart("Signature", policy.getSignature()).addFormDataPart("callback", policy.getCallbackBody()).addFormDataPart("file", name, RequestBodyUtil.create(MediaType.parse((String)"application/octet-stream"), inputStream)).build();
        Response response = this.getServiceClient().post(policy.getHost(), body, headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<FileBean>>(){});
    }

    public void check(FileUploadRequest fileUploadRequest, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileUploadRequest, "fileUploadRequest");
        String fileName = null;
        try {
            fileName = URLDecoder.decode(fileUploadRequest.getName(), BimfaceConstants.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        FileNameUtils.checkFileName(fileName);
        SupportFileBean supportFileBean = this.getSupportFileService().getSupport(accessToken);
        String[] allSupportedType = supportFileBean.getTypes();
        FileNameUtils.checkFileType(allSupportedType, fileUploadRequest.getName());
        if (fileUploadRequest.isByUrl()) {
            AssertUtils.checkUrl(fileUploadRequest.getUrl());
        } else if (!fileUploadRequest.isByOSS()) {
            if (fileUploadRequest.getContentLength() == null || fileUploadRequest.getContentLength() < 0L) {
                throw new IllegalArgumentException("ContentLength is null.");
            }
            AssertUtils.assertParameterNotNull(fileUploadRequest.getInputStream(), "inputStream");
            AssertUtils.checkFileLength(supportFileBean.getLength(), fileUploadRequest.getContentLength());
        }
    }

    public String deleteFile(Long fileId) throws BimfaceException {
        return this.deleteFile(fileId, this.getAccessToken());
    }

    public String deleteFile(Long fileId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().delete(String.format(this.DELETE_FILE_URL, fileId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }

    public void setSupportFileService(SupportFileService supportFileService) {
        this.supportFileService = supportFileService;
    }

    public SupportFileService getSupportFileService() {
        return this.supportFileService;
    }

    public AppendFileBean createAppendFile(String name, String sourceId, Long length) throws BimfaceException {
        return this.createAppendFile(name, sourceId, length, this.getAccessToken());
    }

    public AppendFileBean createAppendFile(String name, String sourceId, Long length, String accessToken) throws BimfaceException {
        FileNameUtils.checkFileName(name);
        AssertUtils.assertParameterNotNull(length, "length");
        if (StringUtils.isNullOrEmpty(sourceId)) {
            sourceId = "";
        }
        SupportFileBean supportFileBean = this.getSupportFileService().getSupport(accessToken);
        String[] allSupportedType = supportFileBean.getTypes();
        FileNameUtils.checkFileType(allSupportedType, name);
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        String url = null;
        try {
            url = String.format(this.CREATE_APPEND_FILE_URL, URLEncoder.encode(name, "utf-8"), URLEncoder.encode(sourceId, "utf-8"), length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Response response = this.getServiceClient().post(url, new byte[0], headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<AppendFileBean>>(){});
    }

    public AppendFileBean queryAppendFile(Long appendFileId) throws BimfaceException {
        return this.queryAppendFile(appendFileId, this.getAccessToken());
    }

    public AppendFileBean queryAppendFile(Long appendFileId, String accessToken) throws BimfaceException {
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.QUERY_APPEND_FILE_URL, appendFileId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<AppendFileBean>>(){});
    }

    public AppendFileBean uploadAppendFile(InputStream inputStream, Long appendFileId) throws BimfaceException {
        return this.uploadAppendFile(inputStream, appendFileId, this.getAccessToken());
    }

    public AppendFileBean uploadAppendFile(InputStream inputStream, Long appendFileId, String accessToken) throws BimfaceException {
        AppendFileBean appendFileBean = this.queryAppendFile(appendFileId, accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        RequestBody body = UploadService.requestIOFromPosition(inputStream, appendFileBean);
        Request.Builder requestBuilder = new Request.Builder().url(String.format(this.UPLOAD_APPEND_FILE_URL, appendFileId, appendFileBean.getPosition())).post(body);
        Response response = this.getServiceClient().send(requestBuilder, Headers.of(headers.getHeaders()));
        return HttpUtils.response(response, new TypeReference<GeneralResponse<AppendFileBean>>(){});
    }

    private static RequestBody requestIOFromPosition(final InputStream inputStream, final AppendFileBean appendFileBean) {
        if (inputStream == null) {
            throw new NullPointerException("content == null");
        }
        return new RequestBody(){

            public MediaType contentType() {
                return MediaType.parse((String)"application/octet-stream");
            }

            public long contentLength() {
                return appendFileBean.getLength() - appendFileBean.getPosition();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                try {
                    int l;
                    inputStream.skip(appendFileBean.getPosition());
                    byte[] buffer = new byte[BimfaceConstants.PUT_THRESHOLD];
                    while ((l = inputStream.read(buffer)) != -1) {
                        sink.outputStream().write(buffer, 0, l);
                    }
                }
                finally {
                    sink.close();
                }
            }
        };
    }

    public FileBean getFileMetadata(Long fileId) throws BimfaceException {
        return this.getFileMetadata(fileId, this.getAccessToken());
    }

    public FileBean getFileMetadata(Long fileId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.GET_FILE_METADATA, fileId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<FileBean>>(){});
    }
}

