/*
 * Decompiled with CFR 0.152.
 */
package com.bimface.sdk.service;

import com.alibaba.fastjson.TypeReference;
import com.bimface.sdk.bean.GeneralResponse;
import com.bimface.sdk.config.Endpoint;
import com.bimface.sdk.exception.BimfaceException;
import com.bimface.sdk.http.HttpHeaders;
import com.bimface.sdk.http.HttpUtils;
import com.bimface.sdk.http.ServiceClient;
import com.bimface.sdk.service.AbstractAccessTokenService;
import com.bimface.sdk.service.AccessTokenService;
import com.bimface.sdk.utils.AssertUtils;
import com.squareup.okhttp.Response;

public class ViewTokenService
extends AbstractAccessTokenService {
    private final String VIEW_TOKEN_FILEID_URL = this.getApiHost() + "/view/token?fileId=%s";
    private final String VIEW_TOKEN_TRANSFERID_URL = this.getApiHost() + "/view/token?transferId=%s";
    private final String VIEW_TOKEN_INTEGRATEID_URL = this.getApiHost() + "/view/token?integrateId=%s";

    public ViewTokenService(ServiceClient serviceClient, Endpoint endpoint) {
        super(serviceClient, endpoint);
    }

    public ViewTokenService(ServiceClient serviceClient, Endpoint endpoint, AccessTokenService accessTokenService) {
        super(serviceClient, endpoint, accessTokenService);
    }

    public String grantViewTokenByTransferId(String transferId) throws BimfaceException {
        return this.grantViewTokenByTransferId(transferId, this.getAccessToken());
    }

    public String grantViewTokenByTransferId(String transferId, String accessToken) throws BimfaceException {
        AssertUtils.assertStringNotNullOrEmpty(transferId, "transferId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.VIEW_TOKEN_TRANSFERID_URL, transferId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }

    public String grantViewTokenByFileId(Long fileId) throws BimfaceException {
        return this.grantViewTokenByFileId(fileId, this.getAccessToken());
    }

    public String grantViewTokenByFileId(Long fileId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(fileId, "fileId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.VIEW_TOKEN_FILEID_URL, fileId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }

    public String grantViewTokenByIntegrateId(Long integrateId) throws BimfaceException {
        return this.grantViewTokenByIntegrateId(integrateId, this.getAccessToken());
    }

    public String grantViewTokenByIntegrateId(Long integrateId, String accessToken) throws BimfaceException {
        AssertUtils.assertParameterNotNull(integrateId, "integrateId");
        HttpHeaders headers = new HttpHeaders();
        headers.addOAuth2Header(accessToken);
        Response response = this.getServiceClient().get(String.format(this.VIEW_TOKEN_INTEGRATEID_URL, integrateId), headers);
        return HttpUtils.response(response, new TypeReference<GeneralResponse<String>>(){});
    }
}

