/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.android.plugin;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.bytedance.android.plugin.extensions.AabResGuardExtension;
import com.bytedance.android.plugin.internal.ProjectResolutionKt;
import com.bytedance.android.plugin.tasks.AabResGuardTask;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/bytedance/android/plugin/AabResGuardPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "checkApplicationPlugin", "createAabResGuardTask", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "plugin"})
public final class AabResGuardPlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.checkApplicationPlugin(project);
        project.getExtensions().create("aabResGuard", AabResGuardExtension.class, new Object[0]);
        project.afterEvaluate((Action)new Action<Project>(this, project){
            final /* synthetic */ AabResGuardPlugin this$0;
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                List list = ProjectResolutionKt.getVariantManager(this.$project).getVariantScopes();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"getVariantManager(project).variantScopes");
                Iterable $receiver$iv = list;
                for (T element$iv : $receiver$iv) {
                    VariantScope scope;
                    VariantScope variantScope = scope = (VariantScope)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)variantScope, (String)"scope");
                    AabResGuardPlugin.access$createAabResGuardTask(this.this$0, this.$project, variantScope);
                }
            }
            {
                this.this$0 = aabResGuardPlugin;
                this.$project = project;
            }
        });
    }

    private final void createAabResGuardTask(Project project, VariantScope scope) {
        AabResGuardTask aabResGuardTask;
        BaseVariantData baseVariantData = scope.getVariantData();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"scope.variantData");
        String string = baseVariantData.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scope.variantData.name");
        String variantName = StringsKt.capitalize((String)string);
        String bundleTaskName = "bundle" + variantName;
        if (project.getTasks().findByName(bundleTaskName) == null) {
            return;
        }
        String aabResGuardTaskName = "aabresguard" + variantName;
        if (project.getTasks().findByName(aabResGuardTaskName) == null) {
            Task task = project.getTasks().create(aabResGuardTaskName, AabResGuardTask.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"project.tasks.create(aab\u2026ResGuardTask::class.java)");
            aabResGuardTask = (AabResGuardTask)task;
        } else {
            Task task = project.getTasks().getByName(aabResGuardTaskName);
            if (task == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.bytedance.android.plugin.tasks.AabResGuardTask");
            }
            aabResGuardTask = (AabResGuardTask)task;
        }
        AabResGuardTask aabResGuardTask2 = aabResGuardTask;
        aabResGuardTask2.setVariantScope(scope);
        Task task = project.getTasks().getByName(bundleTaskName);
        Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"project.tasks.getByName(bundleTaskName)");
        Task bundleTask = task;
        Task task2 = project.getTasks().getByName("package" + variantName + "Bundle");
        Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"project.tasks.getByName(\u2026age${variantName}Bundle\")");
        Task bundlePackageTask = task2;
        bundleTask.dependsOn(new Object[]{aabResGuardTask2});
        aabResGuardTask2.dependsOn(new Object[]{bundlePackageTask});
        String finalizeBundleTaskName = "sign" + variantName + "Bundle";
        if (project.getTasks().findByName(finalizeBundleTaskName) != null) {
            aabResGuardTask2.dependsOn(new Object[]{project.getTasks().getByName(finalizeBundleTaskName)});
        }
    }

    private final void checkApplicationPlugin(Project project) {
        if (!project.getPlugins().hasPlugin("com.android.application")) {
            throw (Throwable)new GradleException("Android Application plugin required");
        }
    }

    public static final /* synthetic */ void access$createAabResGuardTask(AabResGuardPlugin $this, @NotNull Project project, @NotNull VariantScope scope) {
        $this.createAabResGuardTask(project, scope);
    }
}

