/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.android.plugin.internal;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.bytedance.android.plugin.internal.ProjectResolutionKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"getBundleFileForAGP3", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "flavor", "", "getBundleFileForAGP4", "getBundleFilePath", "Ljava/nio/file/Path;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "plugin"})
public final class BundleResolutionKt {
    @NotNull
    public static final Path getBundleFilePath(@NotNull Project project, @NotNull VariantScope variantScope) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        String agpVersion = ProjectResolutionKt.getAGPVersion(project);
        BaseVariantData baseVariantData = variantScope.getVariantData();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.variantData");
        String flavor = baseVariantData.getName();
        if (StringsKt.startsWith$default((String)agpVersion, (String)"3.", (boolean)false, (int)2, null)) {
            String string = flavor;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"flavor");
            Path path2 = BundleResolutionKt.getBundleFileForAGP3(project, string).toPath();
            path = path2;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"getBundleFileForAGP3(project, flavor).toPath()");
        } else {
            String string = flavor;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"flavor");
            Path path3 = BundleResolutionKt.getBundleFileForAGP4(project, string).toPath();
            path = path3;
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"getBundleFileForAGP4(project, flavor).toPath()");
        }
        return path;
    }

    @NotNull
    public static final File getBundleFileForAGP3(@NotNull Project project, @NotNull String flavor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)flavor, (String)"flavor");
        String bundleTaskName = "package" + StringsKt.capitalize((String)flavor) + "Bundle";
        Task bundleTask = project.getTasks().getByName(bundleTaskName);
        Object object = bundleTask.property("bundleLocation");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.File");
        }
        Object object2 = bundleTask.property("fileName");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        return new File((File)object, (String)object2);
    }

    @NotNull
    public static final File getBundleFileForAGP4(@NotNull Project project, @NotNull String flavor) {
        Object bundleFile;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)flavor, (String)"flavor");
        Task finalizeBundleTask = project.getTasks().getByName("sign" + StringsKt.capitalize((String)flavor) + "Bundle");
        Object object = bundleFile = finalizeBundleTask.property("finalBundleFile");
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Object regularFile = object.getClass().getMethod("get", new Class[0]).invoke(bundleFile, new Object[0]);
        Object object2 = regularFile.getClass().getMethod("getAsFile", new Class[0]).invoke(regularFile, new Object[0]);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.File");
        }
        return (File)object2;
    }
}

