/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.android.plugin.internal;

import com.android.build.gradle.internal.VariantManager;
import java.lang.reflect.Method;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\t"}, d2={"getAGPVersion", "", "project", "Lorg/gradle/api/Project;", "getVariantManager", "Lcom/android/build/gradle/internal/VariantManager;", "getVariantManagerFromAppPlugin", "appPlugin", "", "plugin"})
public final class ProjectResolutionKt {
    @NotNull
    public static final VariantManager getVariantManager(@NotNull Project project) {
        Plugin plugin;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (project.getPlugins().hasPlugin("com.android.internal.application")) {
            plugin = project.getPlugins().getPlugin("com.android.internal.application");
        } else if (project.getPlugins().hasPlugin("com.android.application")) {
            plugin = project.getPlugins().getPlugin("com.android.application");
        } else {
            throw (Throwable)new GradleException("Unexpected AppPlugin");
        }
        Plugin appPlugin = plugin;
        VariantManager variantManager = ProjectResolutionKt.getVariantManagerFromAppPlugin(appPlugin);
        if (variantManager == null) {
            throw (Throwable)new GradleException("get VariantManager failed");
        }
        return variantManager;
    }

    private static final VariantManager getVariantManagerFromAppPlugin(Object appPlugin) {
        if (appPlugin == null) {
            return null;
        }
        try {
            Method method;
            int n;
            Method[] methodArray = appPlugin.getClass().getMethods();
            int n2 = methodArray.length;
            for (n = 0; n < n2; ++n) {
                Method method2 = method = methodArray[n];
                Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
                if (!Intrinsics.areEqual((Object)method2.getName(), (Object)"getVariantManager")) continue;
                return (VariantManager)method.invoke(appPlugin, new Object[0]);
            }
            methodArray = appPlugin.getClass().getDeclaredMethods();
            n2 = methodArray.length;
            for (n = 0; n < n2; ++n) {
                Method method3 = method = methodArray[n];
                Intrinsics.checkExpressionValueIsNotNull((Object)method3, (String)"method");
                if (!Intrinsics.areEqual((Object)method3.getName(), (Object)"getVariantManager")) continue;
                return (VariantManager)method.invoke(appPlugin, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            Object var1_6 = null;
            return var1_6;
        }
    }

    @NotNull
    public static final String getAGPVersion(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String agpVersion = null;
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        ScriptHandler scriptHandler = project2.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.rootProject.buildscript");
        Configuration configuration = scriptHandler.getConfigurations().getByName("classpath");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"project.rootProject.buil\u2026.CLASSPATH_CONFIGURATION)");
        ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"project.rootProject.buil\u2026   .resolvedConfiguration");
        Iterator iterator = resolvedConfiguration.getResolvedArtifacts().iterator();
        while (iterator.hasNext()) {
            ResolvedArtifact artifact;
            ResolvedArtifact resolvedArtifact = artifact = (ResolvedArtifact)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"artifact");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifact.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
            ComponentIdentifier identifier = componentArtifactIdentifier.getComponentIdentifier();
            if (!(identifier instanceof DefaultModuleComponentIdentifier) || !Intrinsics.areEqual((Object)((DefaultModuleComponentIdentifier)identifier).getGroup(), (Object)"com.android.tools.build") || !Intrinsics.areEqual((Object)((DefaultModuleComponentIdentifier)identifier).getModule(), (Object)"gradle")) continue;
            agpVersion = ((DefaultModuleComponentIdentifier)identifier).getVersion();
        }
        if (agpVersion == null) {
            throw (Throwable)new GradleException("get AGP version failed");
        }
        return agpVersion;
    }
}

