/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.android.plugin.tasks;

import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.bytedance.android.aabresguard.commands.ObfuscateBundleCommand;
import com.bytedance.android.plugin.extensions.AabResGuardExtension;
import com.bytedance.android.plugin.internal.BundleResolutionKt;
import com.bytedance.android.plugin.internal.SigningConfigResolutionKt;
import com.bytedance.android.plugin.model.SigningConfig;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0003J\u0006\u0010\u0019\u001a\u00020\nJ\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/bytedance/android/plugin/tasks/AabResGuardTask;", "Lorg/gradle/api/DefaultTask;", "()V", "aabResGuard", "Lcom/bytedance/android/plugin/extensions/AabResGuardExtension;", "getAabResGuard", "()Lcom/bytedance/android/plugin/extensions/AabResGuardExtension;", "setAabResGuard", "(Lcom/bytedance/android/plugin/extensions/AabResGuardExtension;)V", "bundlePath", "Ljava/nio/file/Path;", "obfuscatedBundlePath", "signingConfig", "Lcom/bytedance/android/plugin/model/SigningConfig;", "getSigningConfig", "()Lcom/bytedance/android/plugin/model/SigningConfig;", "setSigningConfig", "(Lcom/bytedance/android/plugin/model/SigningConfig;)V", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "encrypt", "", "value", "execute", "", "getObfuscatedBundlePath", "prepareUnusedFile", "printSignConfiguration", "setVariantScope", "plugin"})
public class AabResGuardTask
extends DefaultTask {
    private VariantScope variantScope;
    @NotNull
    public SigningConfig signingConfig;
    @NotNull
    private AabResGuardExtension aabResGuard;
    private Path bundlePath;
    private Path obfuscatedBundlePath;

    @NotNull
    public final SigningConfig getSigningConfig() {
        SigningConfig signingConfig = this.signingConfig;
        if (signingConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        return signingConfig;
    }

    public final void setSigningConfig(@NotNull SigningConfig signingConfig) {
        Intrinsics.checkParameterIsNotNull((Object)signingConfig, (String)"<set-?>");
        this.signingConfig = signingConfig;
    }

    @NotNull
    public final AabResGuardExtension getAabResGuard() {
        return this.aabResGuard;
    }

    public final void setAabResGuard(@NotNull AabResGuardExtension aabResGuardExtension) {
        Intrinsics.checkParameterIsNotNull((Object)aabResGuardExtension, (String)"<set-?>");
        this.aabResGuard = aabResGuardExtension;
    }

    public final void setVariantScope(@NotNull VariantScope variantScope) {
        Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
        this.variantScope = variantScope;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Path path = this.bundlePath = BundleResolutionKt.getBundleFilePath(project, variantScope);
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundlePath");
        }
        File file = path.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"bundlePath.toFile()");
        Path path2 = new File(file.getParentFile(), this.aabResGuard.getObfuscatedBundleFileName()).toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"File(bundlePath.toFile()\u2026dBundleFileName).toPath()");
        this.obfuscatedBundlePath = path2;
    }

    @NotNull
    public final Path getObfuscatedBundlePath() {
        Path path = this.obfuscatedBundlePath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"obfuscatedBundlePath");
        }
        return path;
    }

    @TaskAction
    private final void execute() {
        String string = this.aabResGuard.toString();
        System.out.println((Object)string);
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        VariantScope variantScope = this.variantScope;
        if (variantScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantScope");
        }
        this.signingConfig = SigningConfigResolutionKt.getSigningConfig(project, variantScope);
        this.printSignConfiguration();
        this.prepareUnusedFile();
        ObfuscateBundleCommand.Builder builder = ObfuscateBundleCommand.builder();
        Path path = this.bundlePath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundlePath");
        }
        ObfuscateBundleCommand.Builder builder2 = builder.setBundlePath(path);
        Path path2 = this.obfuscatedBundlePath;
        if (path2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"obfuscatedBundlePath");
        }
        ObfuscateBundleCommand.Builder command = builder2.setOutputPath(path2).setMappingPath(this.aabResGuard.getMappingFile()).setMergeDuplicatedResources(Boolean.valueOf(this.aabResGuard.getMergeDuplicatedRes())).setWhiteList(this.aabResGuard.getWhiteList()).setFilterFile(Boolean.valueOf(this.aabResGuard.getEnableFilterFiles())).setFileFilterRules(this.aabResGuard.getFilterList()).setRemoveStr(Boolean.valueOf(this.aabResGuard.getEnableFilterStrings())).setUnusedStrPath(this.aabResGuard.getUnusedStringPath()).setLanguageWhiteList(this.aabResGuard.getLanguageWhiteList());
        SigningConfig signingConfig = this.signingConfig;
        if (signingConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        if (signingConfig.getStoreFile() != null) {
            SigningConfig signingConfig2 = this.signingConfig;
            if (signingConfig2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
            }
            File file = signingConfig2.getStoreFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
            if (file.exists()) {
                SigningConfig signingConfig3 = this.signingConfig;
                if (signingConfig3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
                }
                File file2 = signingConfig3.getStoreFile();
                if (file2 == null) {
                    Intrinsics.throwNpe();
                }
                ObfuscateBundleCommand.Builder builder3 = command.setStoreFile(file2.toPath());
                SigningConfig signingConfig4 = this.signingConfig;
                if (signingConfig4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
                }
                ObfuscateBundleCommand.Builder builder4 = builder3.setKeyAlias(signingConfig4.getKeyAlias());
                SigningConfig signingConfig5 = this.signingConfig;
                if (signingConfig5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
                }
                ObfuscateBundleCommand.Builder builder5 = builder4.setKeyPassword(signingConfig5.getKeyPassword());
                SigningConfig signingConfig6 = this.signingConfig;
                if (signingConfig6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
                }
                builder5.setStorePassword(signingConfig6.getStorePassword());
            }
        }
        command.build().execute();
    }

    private final void prepareUnusedFile() {
        block6: {
            File usedFile;
            block5: {
                String string;
                block7: {
                    VariantScope variantScope = this.variantScope;
                    if (variantScope == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"variantScope");
                    }
                    BaseVariantData baseVariantData = variantScope.getVariantData();
                    Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.variantData");
                    String string2 = baseVariantData.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variantScope.variantData.name");
                    String simpleName = StringsKt.replace$default((String)string2, (String)"Release", (String)"", (boolean)false, (int)4, null);
                    char c = simpleName.charAt(0);
                    c = Character.toLowerCase(c);
                    String string3 = simpleName;
                    int n = 1;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    string3 = string5;
                    String name = String.valueOf(c) + string3;
                    StringBuilder stringBuilder = new StringBuilder();
                    Project project = this.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                    String resourcePath = stringBuilder.append(project.getBuildDir()).append("/outputs/mapping/").append(name).append("/release/unused.txt").toString();
                    usedFile = new File(resourcePath);
                    if (!usedFile.exists()) break block5;
                    string = "find unused.txt : " + usedFile.getAbsolutePath();
                    System.out.println((Object)string);
                    if (!this.aabResGuard.getEnableFilterStrings()) break block6;
                    if (this.aabResGuard.getUnusedStringPath() == null) break block7;
                    String string6 = this.aabResGuard.getUnusedStringPath();
                    if (string6 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!StringsKt.isBlank((CharSequence)string6)) break block6;
                }
                this.aabResGuard.setUnusedStringPath(usedFile.getAbsolutePath());
                string = "replace unused.txt!";
                System.out.println((Object)string);
                break block6;
            }
            String string = "not exists unused.txt : " + usedFile.getAbsolutePath() + '\n' + "use default path : " + this.aabResGuard.getUnusedStringPath();
            System.out.println((Object)string);
        }
    }

    private final void printSignConfiguration() {
        String string = "-------------- sign configuration --------------";
        System.out.println((Object)string);
        StringBuilder stringBuilder = new StringBuilder().append("\tstoreFile : ");
        SigningConfig signingConfig = this.signingConfig;
        if (signingConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        string = stringBuilder.append(signingConfig.getStoreFile()).toString();
        System.out.println((Object)string);
        StringBuilder stringBuilder2 = new StringBuilder().append("\tkeyPassword : ");
        SigningConfig signingConfig2 = this.signingConfig;
        if (signingConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        string = stringBuilder2.append(this.encrypt(signingConfig2.getKeyPassword())).toString();
        System.out.println((Object)string);
        StringBuilder stringBuilder3 = new StringBuilder().append("\talias : ");
        SigningConfig signingConfig3 = this.signingConfig;
        if (signingConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        string = stringBuilder3.append(this.encrypt(signingConfig3.getKeyAlias())).toString();
        System.out.println((Object)string);
        StringBuilder stringBuilder4 = new StringBuilder().append("\tstorePassword : ");
        SigningConfig signingConfig4 = this.signingConfig;
        if (signingConfig4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signingConfig");
        }
        string = stringBuilder4.append(this.encrypt(signingConfig4.getStorePassword())).toString();
        System.out.println((Object)string);
        string = "-------------- sign configuration --------------";
        System.out.println((Object)string);
    }

    private final String encrypt(String value) {
        if (value == null) {
            return "/";
        }
        if (value.length() > 2) {
            String string = value;
            int n = 0;
            int n2 = value.length() / 2;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = string.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            return stringBuilder.append(string3).append("****").toString();
        }
        return "****";
    }

    public AabResGuardTask() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Object object = project.getExtensions().getByName("aabResGuard");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.bytedance.android.plugin.extensions.AabResGuardExtension");
        }
        this.aabResGuard = (AabResGuardExtension)object;
        this.setDescription("Assemble resource proguard for bundle file");
        this.setGroup("bundle");
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }
}

