/*
 * Decompiled with CFR 0.152.
 */
package com.jpegkit;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.jpegkit.Jpeg;

public class JpegImageView
extends ImageView {
    private Jpeg mJpeg;
    private int mInSampleSize = 1;
    private Bitmap mBitmap;

    public JpegImageView(Context context) {
        super(context);
    }

    public JpegImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public JpegImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public JpegImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.adjustSize(w, h);
    }

    private void adjustSize(int w, int h) {
        if (w > 0 && h > 0 && this.mJpeg != null) {
            int jpegHeight;
            int jpegWidth = this.mJpeg.getWidth();
            if ((float)(jpegWidth * (jpegHeight = this.mJpeg.getHeight())) > (float)(w * h) * 1.5f) {
                float widthRatio = (float)w / (float)jpegWidth;
                float heightRatio = (float)h / (float)jpegHeight;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = widthRatio <= heightRatio ? (int)(1.0f / widthRatio) : (int)(1.0f / heightRatio);
                if (options.inSampleSize != this.mInSampleSize || this.mBitmap == null) {
                    this.mInSampleSize = options.inSampleSize;
                    byte[] jpegBytes = this.mJpeg.getJpegBytes();
                    this.mBitmap = BitmapFactory.decodeByteArray((byte[])jpegBytes, (int)0, (int)jpegBytes.length, (BitmapFactory.Options)options);
                    this.setImageBitmap(this.mBitmap);
                }
            } else if (this.mBitmap == null) {
                byte[] jpegBytes = this.mJpeg.getJpegBytes();
                this.mBitmap = BitmapFactory.decodeByteArray((byte[])jpegBytes, (int)0, (int)jpegBytes.length);
                this.setImageBitmap(this.mBitmap);
            }
        }
    }

    public void setJpeg(Jpeg jpeg) {
        this.setImageBitmap(null);
        this.mJpeg = jpeg;
        this.mInSampleSize = 1;
        this.mBitmap = null;
        this.adjustSize(this.getWidth(), this.getHeight());
    }
}

