/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.EmptyImmutableSortedMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedMapFauxverideShim;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import javax.annotation.Nullable;

public abstract class ImmutableSortedMap
extends ImmutableSortedMapFauxverideShim
implements NavigableMap {
    private static final Comparator NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedMap NATURAL_EMPTY_MAP = new EmptyImmutableSortedMap(NATURAL_ORDER);
    private transient ImmutableSortedMap descendingMap;

    ImmutableSortedMap() {
    }

    ImmutableSortedMap(ImmutableSortedMap immutableSortedMap) {
        this.descendingMap = immutableSortedMap;
    }

    @Override
    public int size() {
        return this.values().size();
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return this.values().contains(object);
    }

    @Override
    boolean isPartialView() {
        return this.keySet().isPartialView() || this.values().isPartialView();
    }

    @Override
    public ImmutableSet entrySet() {
        return super.entrySet();
    }

    @Override
    public abstract ImmutableSortedSet keySet();

    @Override
    public abstract ImmutableCollection values();

    @Override
    public Comparator comparator() {
        return this.keySet().comparator();
    }

    @Override
    public Object firstKey() {
        return this.keySet().first();
    }

    @Override
    public Object lastKey() {
        return this.keySet().last();
    }

    public ImmutableSortedMap headMap(Object object) {
        return this.headMap(object, false);
    }

    public abstract ImmutableSortedMap headMap(Object var1, boolean var2);

    public ImmutableSortedMap subMap(Object object, Object object2) {
        return this.subMap(object, true, object2, false);
    }

    public ImmutableSortedMap subMap(Object object, boolean bl, Object object2, boolean bl2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(object2);
        Preconditions.checkArgument(this.comparator().compare(object, object2) <= 0, "expected fromKey <= toKey but %s > %s", object, object2);
        return this.headMap(object2, bl2).tailMap(object, bl);
    }

    public ImmutableSortedMap tailMap(Object object) {
        return this.tailMap(object, true);
    }

    public abstract ImmutableSortedMap tailMap(Object var1, boolean var2);

    public Map.Entry lowerEntry(Object object) {
        return this.headMap(object, false).lastEntry();
    }

    public Object lowerKey(Object object) {
        return Maps.keyOrNull(this.lowerEntry(object));
    }

    public Map.Entry floorEntry(Object object) {
        return this.headMap(object, true).lastEntry();
    }

    public Object floorKey(Object object) {
        return Maps.keyOrNull(this.floorEntry(object));
    }

    public Map.Entry ceilingEntry(Object object) {
        return this.tailMap(object, true).firstEntry();
    }

    public Object ceilingKey(Object object) {
        return Maps.keyOrNull(this.ceilingEntry(object));
    }

    public Map.Entry higherEntry(Object object) {
        return this.tailMap(object, false).firstEntry();
    }

    public Object higherKey(Object object) {
        return Maps.keyOrNull(this.higherEntry(object));
    }

    @Override
    public Map.Entry firstEntry() {
        return this.isEmpty() ? null : (Map.Entry)this.entrySet().asList().get(0);
    }

    @Override
    public Map.Entry lastEntry() {
        return this.isEmpty() ? null : (Map.Entry)this.entrySet().asList().get(this.size() - 1);
    }

    @Override
    @Deprecated
    public final Map.Entry pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Map.Entry pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    public ImmutableSortedMap descendingMap() {
        ImmutableSortedMap immutableSortedMap = this.descendingMap;
        if (immutableSortedMap == null) {
            immutableSortedMap = this.descendingMap = this.createDescendingMap();
        }
        return immutableSortedMap;
    }

    abstract ImmutableSortedMap createDescendingMap();

    public ImmutableSortedSet navigableKeySet() {
        return this.keySet();
    }

    public ImmutableSortedSet descendingKeySet() {
        return this.keySet().descendingSet();
    }
}

